/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.internal.pager;

import afu.org.tmatesoft.sqljet.core.SqlJetErrorCode;
import afu.org.tmatesoft.sqljet.core.SqlJetException;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import afu.org.tmatesoft.sqljet.core.internal.ISqlJetPager;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetMemoryBufferType;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetPageFlags;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetPagerJournalMode;
import afu.org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import afu.org.tmatesoft.sqljet.core.internal.pager.SqlJetPageCache;
import afu.org.tmatesoft.sqljet.core.internal.pager.SqlJetPager;
import afu.org.tmatesoft.sqljet.core.internal.pager.SqlJetPagerState;
import java.util.BitSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetPage
implements ISqlJetPage {
    public static final SqlJetMemoryBufferType BUFFER_TYPE = SqlJetUtility.getEnumSysProp("SqlJetPage.BUFFER_TYPE", SqlJetMemoryBufferType.ARRAY);
    ISqlJetMemoryPointer pData;
    Object pExtra;
    SqlJetPage pDirty;
    int pgno;
    SqlJetPager pPager;
    long pageHash;
    Set<SqlJetPageFlags> flags = SqlJetUtility.noneOf(SqlJetPageFlags.class);
    int nRef;
    SqlJetPageCache pCache;
    SqlJetPage pDirtyNext;
    SqlJetPage pDirtyPrev;

    public SqlJetPage() {
    }

    SqlJetPage(int szPage) {
        this.pData = SqlJetUtility.allocatePtr(szPage, BUFFER_TYPE);
    }

    @Override
    public void dontRollback() {
        assert (this.pPager.state.compareTo(SqlJetPagerState.RESERVED) >= 0);
        if (!this.pPager.journalOpen || SqlJetUtility.bitSetTest(this.pPager.pagesAlwaysRollback, this.pgno) || this.pgno > this.pPager.dbOrigSize) {
            return;
        }
        if (SqlJetUtility.bitSetTest(this.pPager.pagesInJournal, this.pgno) || this.pgno > this.pPager.dbOrigSize) {
            return;
        }
        assert (this.pPager.pagesInJournal != null);
        this.flags.remove((Object)SqlJetPageFlags.NEED_READ);
        this.pPager.pagesInJournal.set(this.pgno);
        this.pPager.addToSavepointBitSets(this.pgno);
        SqlJetPager.PAGERTRACE("DONT_ROLLBACK page %d of %s\n", this.pgno, this.pPager.PAGERID());
    }

    @Override
    public void dontWrite() {
        if (this.pgno > this.pPager.dbOrigSize) {
            return;
        }
        if (this.pPager.pagesAlwaysRollback == null) {
            assert (this.pPager.pagesInJournal != null);
            this.pPager.pagesAlwaysRollback = new BitSet(this.pPager.dbOrigSize);
        }
        this.pPager.pagesAlwaysRollback.set(this.pgno);
        if (this.flags.contains((Object)SqlJetPageFlags.DIRTY) && this.pPager.nSavepoint == 0) {
            assert (this.pPager.state.compareTo(SqlJetPagerState.SHARED) >= 0);
            if (this.pPager.dbSize != this.pgno || this.pPager.dbOrigSize >= this.pPager.dbSize) {
                SqlJetPager.PAGERTRACE("DONT_WRITE page %d of %s\n", this.pgno, this.pPager.PAGERID());
                this.flags.add(SqlJetPageFlags.DONT_WRITE);
                this.pageHash = this.pPager.pageHash(this);
            }
        }
    }

    @Override
    public ISqlJetMemoryPointer getData() {
        return this.pData;
    }

    @Override
    public Object getExtra() {
        return this.pPager != null ? this.pExtra : null;
    }

    @Override
    public void setExtra(Object extra) {
        this.pExtra = extra;
    }

    @Override
    public void move(int pageNumber, boolean isCommit) throws SqlJetException {
        int needSyncPgno = 0;
        assert (this.nRef > 0);
        if (this.flags.contains((Object)SqlJetPageFlags.DIRTY) && SqlJetPager.subjRequiresPage(this)) {
            this.pPager.subjournalPage(this);
        }
        SqlJetPager.PAGERTRACE("MOVE %s page %d (needSync=%b) moves to %d\n", this.pPager.PAGERID(), this.pgno, this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC), pageNumber);
        this.pPager.getContent(this);
        if (this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC) && !isCommit) {
            needSyncPgno = this.pgno;
            assert (SqlJetPager.pageInJournal(this) || this.pgno > this.pPager.dbOrigSize);
            assert (this.flags.contains((Object)SqlJetPageFlags.DIRTY));
            assert (this.pPager.needSync);
        }
        this.flags.remove((Object)SqlJetPageFlags.NEED_SYNC);
        SqlJetPage pPgOld = (SqlJetPage)this.pPager.lookup(pageNumber);
        assert (pPgOld == null || pPgOld.nRef >= 1);
        if (pPgOld != null && pPgOld.flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) {
            this.flags.add(SqlJetPageFlags.NEED_SYNC);
        }
        if (pPgOld != null) {
            this.pPager.pageCache.drop(pPgOld);
        }
        this.pPager.pageCache.move(this, pageNumber);
        this.pPager.pageCache.makeDirty(this);
        this.pPager.dirtyCache = true;
        this.pPager.dbModified = true;
        if (needSyncPgno != 0) {
            SqlJetPage pPgHdr;
            assert (this.pPager.needSync);
            try {
                pPgHdr = (SqlJetPage)this.pPager.getPage(needSyncPgno);
            }
            catch (SqlJetException e) {
                if (this.pPager.pagesInJournal != null && needSyncPgno <= this.pPager.dbOrigSize) {
                    this.pPager.pagesInJournal.clear(needSyncPgno);
                }
                throw e;
            }
            this.pPager.needSync = true;
            assert (!this.pPager.noSync && !this.pPager.memDb);
            pPgHdr.flags.add(SqlJetPageFlags.NEED_SYNC);
            this.pPager.pageCache.makeDirty(pPgHdr);
            pPgHdr.unref();
        }
    }

    @Override
    public void ref() {
        assert (this.nRef > 0);
        ++this.nRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unref() throws SqlJetException {
        try {
            this.pPager.pageCache.release(this);
        }
        finally {
            this.pPager.unlockIfUnused();
        }
    }

    @Override
    public void write() throws SqlJetException {
        int nPagePerSector = this.pPager.sectorSize / this.pPager.pageSize;
        if (nPagePerSector > 1) {
            int ii;
            boolean needSync = false;
            assert (!this.pPager.memDb);
            assert (!this.pPager.doNotSync);
            this.pPager.doNotSync = true;
            int pg1 = (this.pgno - 1 & ~(nPagePerSector - 1)) + 1;
            int nPageCount = this.pPager.getPageCount();
            int nPage = this.pgno > nPageCount ? this.pgno - pg1 + 1 : (pg1 + nPagePerSector - 1 > nPageCount ? nPageCount + 1 - pg1 : nPagePerSector);
            assert (nPage > 0);
            assert (pg1 <= this.pgno);
            assert (pg1 + nPage > this.pgno);
            for (ii = 0; ii < nPage; ++ii) {
                SqlJetPage pPage;
                int pg = pg1 + ii;
                if (pg == this.pgno || !SqlJetUtility.bitSetTest(this.pPager.pagesInJournal, pg)) {
                    if ((long)pg == this.pPager.PAGER_MJ_PGNO()) continue;
                    pPage = (SqlJetPage)this.pPager.getPage(pg);
                    pPage.doWrite();
                    if (pPage.flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) {
                        needSync = true;
                    }
                    pPage.unref();
                    continue;
                }
                pPage = (SqlJetPage)this.pPager.lookup(pg);
                if (pPage == null) continue;
                if (pPage.flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) {
                    needSync = true;
                    assert (this.pPager.needSync);
                }
                pPage.unref();
            }
            if (needSync) {
                assert (!this.pPager.memDb && !this.pPager.noSync);
                for (ii = 0; ii < nPage && needSync; ++ii) {
                    SqlJetPage pPage = (SqlJetPage)this.pPager.lookup(pg1 + ii);
                    if (pPage == null) continue;
                    pPage.flags.add(SqlJetPageFlags.NEED_SYNC);
                    pPage.unref();
                }
                assert (this.pPager.needSync);
            }
            assert (this.pPager.doNotSync);
            this.pPager.doNotSync = false;
        } else {
            this.doWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite() throws SqlJetException {
        block26: {
            block27: {
                block28: {
                    block25: {
                        if (this.pPager.errCode != null) {
                            throw new SqlJetException(this.pPager.errCode);
                        }
                        if (this.pPager.readOnly) {
                            throw new SqlJetException(SqlJetErrorCode.PERM);
                        }
                        assert (!this.pPager.setMaster);
                        this.pPager.getContent(this);
                        this.pCache.makeDirty(this);
                        if (!SqlJetPager.pageInJournal(this) || SqlJetPager.subjRequiresPage(this)) break block25;
                        this.pPager.dirtyCache = true;
                        this.pPager.dbModified = true;
                        break block26;
                    }
                    assert (this.pPager.state != SqlJetPagerState.UNLOCK);
                    this.pPager.begin(false);
                    assert (this.pPager.state.compareTo(SqlJetPagerState.RESERVED) >= 0);
                    if (!this.pPager.journalOpen && this.pPager.useJournal && this.pPager.journalMode != SqlJetPagerJournalMode.OFF) {
                        this.pPager.openJournal();
                    }
                    this.pPager.dirtyCache = true;
                    this.pPager.dbModified = true;
                    if (SqlJetPager.pageInJournal(this) || !this.pPager.journalOpen) break block27;
                    if (this.pgno > this.pPager.dbOrigSize) break block28;
                    assert ((long)this.pgno != this.pPager.PAGER_MJ_PGNO());
                    try {
                        long cksum = this.pPager.cksum(this.pData);
                        SqlJetPager.write32bits(this.pPager.jfd, this.pPager.journalOff, this.pgno);
                        try {
                            this.pPager.jfd.write(this.pData, this.pPager.pageSize, this.pPager.journalOff + 4L);
                        }
                        finally {
                            this.pPager.journalOff += (long)(this.pPager.pageSize + 4);
                        }
                        try {
                            SqlJetPager.write32bitsUnsigned(this.pPager.jfd, this.pPager.journalOff, cksum);
                        }
                        finally {
                            this.pPager.journalOff += 4L;
                        }
                    }
                    catch (Throwable throwable) {
                        SqlJetPager.PAGERTRACE("JOURNAL %s page %d needSync=%b hash(%08x)\n", this.pPager.PAGERID(), this.pgno, this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC), this.pPager.pageHash(this));
                        if (!this.pPager.noSync) {
                            this.flags.add(SqlJetPageFlags.NEED_SYNC);
                            this.pPager.needSync = true;
                        }
                        throw throwable;
                    }
                    SqlJetPager.PAGERTRACE("JOURNAL %s page %d needSync=%b hash(%08x)\n", this.pPager.PAGERID(), this.pgno, this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC), this.pPager.pageHash(this));
                    if (!this.pPager.noSync) {
                        this.flags.add(SqlJetPageFlags.NEED_SYNC);
                        this.pPager.needSync = true;
                    }
                    ++this.pPager.nRec;
                    assert (this.pPager.pagesInJournal != null);
                    this.pPager.pagesInJournal.set(this.pgno);
                    this.pPager.addToSavepointBitSets(this.pgno);
                    break block27;
                }
                if (!this.pPager.journalStarted && !this.pPager.noSync) {
                    this.flags.add(SqlJetPageFlags.NEED_SYNC);
                    this.pPager.needSync = true;
                }
                SqlJetPager.PAGERTRACE("APPEND %s page %d needSync=%b\n", this.pPager.PAGERID(), this.pgno, this.flags.contains((Object)SqlJetPageFlags.NEED_SYNC));
            }
            if (SqlJetPager.subjRequiresPage(this)) {
                this.pPager.subjournalPage(this);
            }
        }
        assert (this.pPager.state.compareTo(SqlJetPagerState.SHARED) >= 0);
        if (this.pPager.dbSize < this.pgno) {
            this.pPager.dbSize = this.pgno;
            if ((long)this.pPager.dbSize == this.pPager.PAGER_MJ_PGNO() - 1L) {
                ++this.pPager.dbSize;
            }
        }
    }

    @Override
    public Set<SqlJetPageFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getHash() {
        return this.pageHash;
    }

    @Override
    public ISqlJetPager getPager() {
        return this.pPager;
    }

    @Override
    public void setFlags(Set<SqlJetPageFlags> flags) {
        this.flags = flags;
    }

    @Override
    public void setHash(long hash) {
        this.pageHash = hash;
    }

    @Override
    public void setPager(ISqlJetPager pager) {
        this.pPager = (SqlJetPager)pager;
    }

    @Override
    public int getPageNumber() {
        return this.pgno;
    }

    @Override
    public void setPageNumber(int pageNumber) {
        this.pgno = pageNumber;
    }

    @Override
    public ISqlJetPage getNext() {
        return this.pDirtyNext;
    }

    @Override
    public ISqlJetPage getPrev() {
        return this.pDirtyPrev;
    }

    @Override
    public int getRefCount() {
        return this.nRef;
    }

    @Override
    public boolean isWriteable() {
        return this.flags.contains((Object)SqlJetPageFlags.DIRTY);
    }

    @Override
    public ISqlJetPage getDirty() {
        return this.pDirty;
    }
}

