/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.internal.schema;

import afu.org.antlr.runtime.tree.CommonTree;
import afu.org.tmatesoft.sqljet.core.internal.schema.SqlJetExpression;
import afu.org.tmatesoft.sqljet.core.schema.ISqlJetColumnExpression;

public class SqlJetColumnExpression
extends SqlJetExpression
implements ISqlJetColumnExpression {
    private final String columnName;
    private final String tableName;
    private final String databaseName;

    public SqlJetColumnExpression(CommonTree ast) {
        assert ("column_expression".equalsIgnoreCase(ast.getText()));
        CommonTree columnNode = (CommonTree)ast.getChild(0);
        this.columnName = columnNode.getText();
        if (columnNode.getChildCount() > 0) {
            CommonTree tableNode = (CommonTree)columnNode.getChild(0);
            this.tableName = tableNode.getText();
            this.databaseName = tableNode.getChildCount() > 0 ? tableNode.getChild(0).getText() : null;
        } else {
            this.tableName = null;
            this.databaseName = null;
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.getDatabaseName() != null) {
            buffer.append(this.getDatabaseName());
            buffer.append('.');
        }
        if (this.getTableName() != null) {
            buffer.append(this.getTableName());
            buffer.append('.');
        }
        buffer.append(this.getColumnName());
        return buffer.toString();
    }
}

