/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli;

import afu.org.tmatesoft.svn.cli.AbstractSVNOption;
import afu.org.tmatesoft.svn.cli.SVNOptionValue;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.util.SVNHashMap;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class SVNCommandLine {
    private static final Map ourOptions = new SVNHashMap();
    private String myCommand;
    private Collection myArguments = new LinkedList();
    private Collection myOptions = new LinkedList();
    private boolean myNeedsCommand;
    private int myArgumentIndex;
    private int myArgumentPosition;
    private String[] myInputArguments;

    public static void registerOption(AbstractSVNOption option) {
        if (option.getName() != null) {
            ourOptions.put("--" + option.getName(), option);
        }
        if (option.getAlias() != null) {
            ourOptions.put("-" + option.getAlias(), option);
        }
    }

    public SVNCommandLine() {
        this(true);
    }

    public SVNCommandLine(boolean needsCommand) {
        this.myNeedsCommand = needsCommand;
    }

    public void init(String[] args) throws SVNException {
        SVNOptionValue value;
        this.myInputArguments = args;
        this.myArgumentPosition = 0;
        this.myArgumentIndex = 0;
        this.myArguments = new LinkedList();
        this.myOptions = new LinkedList();
        this.myCommand = null;
        while ((value = this.nextOption()) != null) {
            this.myOptions.add(value);
        }
    }

    private SVNOptionValue nextOption() throws SVNException {
        String argument;
        if (this.myArgumentPosition == 0) {
            while (this.myArgumentIndex < this.myInputArguments.length && !this.myInputArguments[this.myArgumentIndex].startsWith("-")) {
                argument = this.myInputArguments[this.myArgumentIndex];
                if (this.myNeedsCommand && this.myCommand == null) {
                    this.myCommand = argument;
                } else {
                    this.myArguments.add(argument);
                }
                ++this.myArgumentIndex;
            }
            if (this.myArgumentIndex >= this.myInputArguments.length) {
                return null;
            }
            argument = this.myInputArguments[this.myArgumentIndex];
            if (argument.startsWith("--")) {
                int valueIndex = argument.indexOf(61);
                String optionName = valueIndex > 0 ? argument.substring(0, valueIndex) : argument;
                AbstractSVNOption option = (AbstractSVNOption)ourOptions.get(optionName);
                if (option == null) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "invalid option: {0}", (Object)optionName);
                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                }
                String value = null;
                if (!option.isUnary()) {
                    if (valueIndex > 0) {
                        value = argument.substring(valueIndex + 1);
                    } else {
                        ++this.myArgumentIndex;
                        String string = value = this.myArgumentIndex < this.myInputArguments.length ? this.myInputArguments[this.myArgumentIndex] : null;
                    }
                    if (value == null) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "missing argument: {0}", (Object)optionName);
                        SVNErrorManager.error(err, SVNLogType.CLIENT);
                    }
                }
                ++this.myArgumentIndex;
                return new SVNOptionValue(option, optionName, value);
            }
            this.myArgumentPosition = 1;
        }
        argument = this.myInputArguments[this.myArgumentIndex];
        String optionName = "-" + argument.charAt(this.myArgumentPosition++);
        AbstractSVNOption option = (AbstractSVNOption)ourOptions.get(optionName);
        if (option == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "invalid option: {0}", (Object)optionName);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        String value = null;
        if (!option.isUnary()) {
            if (this.myArgumentPosition < argument.length()) {
                value = argument.substring(this.myArgumentPosition);
                if (value.startsWith("=")) {
                    value = value.substring(1);
                }
            } else {
                ++this.myArgumentIndex;
                value = this.myArgumentIndex < this.myInputArguments.length ? this.myInputArguments[this.myArgumentIndex] : null;
            }
            this.myArgumentPosition = 0;
            ++this.myArgumentIndex;
            if (value == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "missing argument: {0}", (Object)optionName);
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
        }
        if (this.myArgumentPosition >= argument.length()) {
            this.myArgumentPosition = 0;
            ++this.myArgumentIndex;
        }
        return new SVNOptionValue(option, optionName, value);
    }

    public Iterator optionValues() {
        return this.myOptions.iterator();
    }

    public String getCommandName() {
        return this.myCommand;
    }

    public Collection getArguments() {
        return this.myArguments;
    }
}

