/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svn;

import afu.org.tmatesoft.svn.cli.svn.SVNCommand;
import afu.org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import afu.org.tmatesoft.svn.cli.svn.SVNOption;
import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPath;
import afu.org.tmatesoft.svn.core.wc.SVNChangelistClient;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SVNChangeListCommand
extends SVNCommand {
    public SVNChangeListCommand() {
        super("changelist", new String[]{"cl"});
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.QUIET);
        options.add(SVNOption.RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.REMOVE);
        options.add(SVNOption.TARGETS);
        options.add(SVNOption.CHANGELIST);
        return options;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() throws SVNException {
        List<Object> targets = new ArrayList();
        String changelist = null;
        if (this.getSVNEnvironment().getTargets() != null) {
            targets.addAll(this.getSVNEnvironment().getTargets());
        }
        targets = this.getSVNEnvironment().combineTargets(targets, true);
        if (this.getSVNEnvironment().isRemove()) {
            if (targets.size() < 1) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS), SVNLogType.CLIENT);
            }
            changelist = null;
        } else {
            if (targets.size() < 2) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS), SVNLogType.CLIENT);
            }
            changelist = (String)targets.remove(0);
        }
        ArrayList<File> paths = new ArrayList<File>();
        for (String string : targets) {
            SVNPath target = new SVNPath(string);
            paths.add(target.getFile());
        }
        File[] files = paths.toArray(new File[paths.size()]);
        SVNDepth sVNDepth = this.getSVNEnvironment().getDepth();
        if (sVNDepth == SVNDepth.UNKNOWN) {
            SVNDepth sVNDepth2 = SVNDepth.EMPTY;
        }
        SVNChangelistClient client = this.getSVNEnvironment().getClientManager().getChangelistClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        ArrayList<SVNErrorCode> errors = new ArrayList<SVNErrorCode>();
        for (int i = 0; i < files.length; ++i) {
            try {
                void var5_8;
                if (changelist != null) {
                    client.doAddToChangelist(new File[]{files[i]}, (SVNDepth)var5_8, changelist, this.getSVNEnvironment().getChangelists());
                    continue;
                }
                client.doRemoveFromChangelist(new File[]{files[i]}, (SVNDepth)var5_8, this.getSVNEnvironment().getChangelists());
                continue;
            }
            catch (SVNException e) {
                if (this.getSVNEnvironment().handleWarning(e.getErrorMessage(), new SVNErrorCode[]{SVNErrorCode.UNVERSIONED_RESOURCE, SVNErrorCode.WC_PATH_NOT_FOUND}, this.getSVNEnvironment().isQuiet())) continue;
                errors.add(e.getErrorMessage().getErrorCode());
            }
        }
        if (!errors.isEmpty()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET);
            for (SVNErrorCode code : errors) {
                if (code == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Could not set changelist on all targets because some targets don't exist");
                    continue;
                }
                if (code != SVNErrorCode.UNVERSIONED_RESOURCE) continue;
                err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Could not set changelist on all targets because some targets are not versioned");
            }
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
    }
}

