/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svn;

import afu.org.tmatesoft.svn.cli.SVNCommandUtil;
import afu.org.tmatesoft.svn.cli.svn.SVNCommandEnvironment;
import afu.org.tmatesoft.svn.core.SVNCancelException;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNMergeRange;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNProperty;
import afu.org.tmatesoft.svn.core.internal.util.SVNFormatUtil;
import afu.org.tmatesoft.svn.core.internal.wc.patch.SVNPatchHunk;
import afu.org.tmatesoft.svn.core.internal.wc.patch.SVNPatchHunkInfo;
import afu.org.tmatesoft.svn.core.internal.wc2.patch.SvnHunkInfo;
import afu.org.tmatesoft.svn.core.wc.ISVNEventHandler;
import afu.org.tmatesoft.svn.core.wc.SVNConflictStats;
import afu.org.tmatesoft.svn.core.wc.SVNEvent;
import afu.org.tmatesoft.svn.core.wc.SVNEventAction;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc.SVNStatusType;
import afu.org.tmatesoft.svn.util.SVNDebugLog;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.io.PrintStream;

public class SVNNotifyPrinter
implements ISVNEventHandler {
    private SVNCommandEnvironment myEnvironment;
    private boolean myIsInExternal;
    private boolean myIsChangesReceived;
    private boolean myIsDeltaSent;
    private boolean myIsCheckout;
    private boolean myIsExport;
    private boolean myIsSuppressLastLine;
    private boolean myHasExternalErrors;
    private boolean myHasLockingError;
    private boolean myIsWcToReposCopy;

    public SVNNotifyPrinter(SVNCommandEnvironment env) {
        this(env, false, false, false);
    }

    public SVNNotifyPrinter(SVNCommandEnvironment env, boolean isCheckout, boolean isExport, boolean suppressLastLine) {
        this.myEnvironment = env;
        this.myIsCheckout = isCheckout;
        this.myIsExport = isExport;
        this.myIsSuppressLastLine = suppressLastLine;
    }

    public void setWcToReposCopy(boolean wcToReposCopy) {
        this.myIsWcToReposCopy = wcToReposCopy;
    }

    public boolean isWcToReposCopy() {
        return this.myIsWcToReposCopy;
    }

    public boolean hasExternalErrors() {
        return this.myHasExternalErrors;
    }

    public boolean hasLockingErrors() {
        return this.myHasLockingError;
    }

    @Override
    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        File file = event.getFile();
        String path = null;
        if (file != null) {
            path = this.myEnvironment.getRelativePath(file);
            path = SVNCommandUtil.getLocalPath(path);
        }
        PrintStream out = this.myEnvironment.getOut();
        StringBuffer buffer = new StringBuffer();
        if (event.getAction() == SVNEventAction.STATUS_EXTERNAL) {
            buffer.append("\nPerforming status on external item at '" + path + "'\n");
        } else if (event.getAction() == SVNEventAction.STATUS_COMPLETED) {
            if (SVNRevision.isValidRevisionNumber(event.getRevision())) {
                String revStr = Long.toString(event.getRevision());
                buffer.append("Status against revision: " + SVNFormatUtil.formatString(revStr, 6, false) + "\n");
            }
        } else if (event.getAction() == SVNEventAction.SKIP) {
            if (event.getErrorMessage() != null && event.getExpectedAction() == SVNEventAction.UPDATE_EXTERNAL) {
                this.myEnvironment.getErr().println(event.getErrorMessage());
            }
            this.getConflictStats().incrementSkippedPaths();
            if (event.getContentsStatus() == SVNStatusType.MISSING) {
                buffer.append("Skipped missing target: '" + path + "'\n");
            } else if (path != null) {
                buffer.append("Skipped '" + path + "'\n");
            }
        } else if (event.getAction() == SVNEventAction.UPDATE_SKIP_OBSTRUCTION) {
            this.getConflictStats().incrementSkippedPaths();
            buffer.append("Skipped '" + path + "' -- An obstructing working copy was found\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_SKIP_WORKING_ONLY) {
            this.getConflictStats().incrementSkippedPaths();
            buffer.append("Skipped '" + path + "' -- Has no versioned parent\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_SKIP_ACCESS_DENINED) {
            this.getConflictStats().incrementSkippedPaths();
            buffer.append("Skipped '" + path + "' -- Access denied\n");
        } else if (event.getAction() == SVNEventAction.SKIP_CONFLICTED) {
            this.getConflictStats().incrementSkippedPaths();
            buffer.append("Skipped '" + path + "' -- Node remains in conflict\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_DELETE) {
            this.myIsChangesReceived = true;
            buffer.append("D    " + path + "\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_BROKEN_LOCK) {
            buffer.append("B    " + path + "\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_REPLACE) {
            this.myIsChangesReceived = true;
            buffer.append("R    " + path + "\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_ADD) {
            this.myIsChangesReceived = true;
            if (event.getContentsStatus() == SVNStatusType.CONFLICTED) {
                this.getConflictStats().storeTextConflict(file.getAbsolutePath());
                buffer.append("C    " + path + "\n");
            } else {
                buffer.append("A    " + path + "\n");
            }
        } else if (event.getAction() == SVNEventAction.UPDATE_EXISTS) {
            this.myIsChangesReceived = true;
            if (event.getContentsStatus() == SVNStatusType.CONFLICTED) {
                this.getConflictStats().storeTextConflict(file.getAbsolutePath());
                buffer.append('C');
            } else {
                buffer.append('E');
            }
            if (event.getPropertiesStatus() == SVNStatusType.CONFLICTED) {
                this.getConflictStats().storePropConflict(file.getAbsolutePath());
                buffer.append('C');
            } else if (event.getPropertiesStatus() == SVNStatusType.MERGED) {
                buffer.append('G');
            } else {
                buffer.append(' ');
            }
            buffer.append("   " + path + "\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_UPDATE || event.getAction() == SVNEventAction.MERGE_RECORD_INFO) {
            SVNStatusType propStatus = event.getPropertiesStatus();
            if (event.getNodeKind() == SVNNodeKind.DIR && (propStatus == SVNStatusType.INAPPLICABLE || propStatus == SVNStatusType.UNKNOWN || propStatus == SVNStatusType.UNCHANGED)) {
                return;
            }
            if (event.getNodeKind() == SVNNodeKind.FILE) {
                if (event.getContentsStatus() == SVNStatusType.CONFLICTED) {
                    this.getConflictStats().storeTextConflict(file.getAbsolutePath());
                    buffer.append('C');
                } else if (event.getContentsStatus() == SVNStatusType.MERGED) {
                    buffer.append('G');
                } else if (event.getContentsStatus() == SVNStatusType.CHANGED) {
                    buffer.append('U');
                } else {
                    buffer.append(' ');
                }
            } else {
                buffer.append(' ');
            }
            if (event.getPropertiesStatus() == SVNStatusType.CONFLICTED) {
                this.getConflictStats().storePropConflict(file.getAbsolutePath());
                buffer.append('C');
            } else if (event.getPropertiesStatus() == SVNStatusType.MERGED) {
                buffer.append('G');
            } else if (event.getPropertiesStatus() == SVNStatusType.CHANGED) {
                buffer.append('U');
            } else {
                buffer.append(' ');
            }
            if (buffer.toString().trim().length() > 0) {
                this.myIsChangesReceived = true;
            }
            if (event.getLockStatus() == SVNStatusType.LOCK_UNLOCKED) {
                buffer.append('B');
            } else {
                buffer.append(' ');
            }
            if (buffer.toString().trim().length() == 0) {
                return;
            }
            buffer.append("  " + path + "\n");
        } else if (event.getAction() == SVNEventAction.MERGE_BEGIN) {
            SVNMergeRange range = event.getMergeRange();
            if (range == null) {
                buffer.append("--- Merging differences between repository URLs into '" + path + "':\n");
            } else {
                long end;
                long start = range.getStartRevision();
                if (start == (end = range.getEndRevision()) || start == end - 1L) {
                    buffer.append("--- Merging r" + end + " into '" + path + "':\n");
                } else if (start - 1L == end) {
                    buffer.append("--- Reverse-merging r" + start + " into '" + path + "':\n");
                } else if (start < end) {
                    buffer.append("--- Merging r" + (start + 1L) + " through r" + end + " into '" + path + "':\n");
                } else {
                    buffer.append("--- Reverse-merging r" + start + " through r" + (end + 1L) + " into '" + path + "':\n");
                }
            }
        } else if (event.getAction() == SVNEventAction.MERGE_RECORD_INFO_BEGIN) {
            SVNMergeRange range = event.getMergeRange();
            if (range == null) {
                buffer.append("--- Recording mergeinfo for merge between repository URLs into '" + path + "':\n");
            } else {
                long end;
                long start = range.getStartRevision();
                if (start == (end = range.getEndRevision()) || start == end - 1L) {
                    buffer.append("--- Recording mergeinfo for merge of r" + end + " into '" + path + "':\n");
                } else if (start - 1L == end) {
                    buffer.append("--- Recording mergeinfo for reverse merge of r" + start + " into '" + path + "':\n");
                } else if (start < end) {
                    buffer.append("--- Recording mergeinfo for merge of r" + (start + 1L) + " through r" + end + " into '" + path + "':\n");
                } else {
                    buffer.append("--- Recording mergeinfo for reverse merge of r" + start + " through r" + (end + 1L) + " into '" + path + "':\n");
                }
            }
        } else if (event.getAction() == SVNEventAction.FOREIGN_MERGE_BEGIN) {
            SVNMergeRange range = event.getMergeRange();
            if (range == null) {
                buffer.append("--- Merging differences between foreign repository URLs into '" + path + "':\n");
            } else {
                long end;
                long start = range.getStartRevision();
                if (start == (end = range.getEndRevision()) || start == end - 1L) {
                    buffer.append("--- Merging (from foreign repository) r" + end + " into '" + path + "':\n");
                } else if (start - 1L == end) {
                    buffer.append("--- Reverse-merging (from foreign repository) r" + start + " into '" + path + "':\n");
                } else if (start < end) {
                    buffer.append("--- Merging (from foreign repository) r" + (start + 1L) + " through r" + end + " into '" + path + "':\n");
                } else {
                    buffer.append("--- Reverse-merging (from foreign repository) r" + start + " through r" + (end + 1L) + " into '" + path + "':\n");
                }
            }
        } else if (event.getAction() == SVNEventAction.MERGE_ELIDE_INFO) {
            buffer.append("--- Eliding mergeinfo from '" + path + "':\n");
        } else if (event.getAction() == SVNEventAction.TREE_CONFLICT) {
            this.getConflictStats().storeTreeConflict(file.getAbsolutePath());
            buffer.append("   C ");
            buffer.append(path);
            buffer.append("\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_SHADOWED_ADD) {
            this.myIsChangesReceived = true;
            buffer.append("   A ");
            buffer.append(path);
            buffer.append("\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_SHADOWED_UPDATE) {
            this.myIsChangesReceived = true;
            buffer.append("   U ");
            buffer.append(path);
            buffer.append("\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_SHADOWED_DELETE) {
            this.myIsChangesReceived = true;
            buffer.append("   D ");
            buffer.append(path);
            buffer.append("\n");
        } else if (event.getAction() == SVNEventAction.RESTORE) {
            buffer.append("Restored '" + path + "'\n");
        } else if (event.getAction() == SVNEventAction.RESTORE) {
            buffer.append("Restored '" + path + "'\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_EXTERNAL) {
            this.myIsInExternal = true;
            buffer.append("\nFetching external item into '" + path + "':\n");
        } else if (event.getAction() == SVNEventAction.UPDATE_EXTERNAL_REMOVED) {
            buffer.append("Removed external '" + path + "'");
            if (event.getErrorMessage() != null) {
                buffer.append(": " + event.getErrorMessage().getMessage());
            }
            buffer.append("\n");
        } else {
            if (event.getAction() == SVNEventAction.FAILED_EXTERNAL) {
                this.myHasExternalErrors = true;
                if (this.myIsInExternal) {
                    this.myEnvironment.handleWarning(event.getErrorMessage(), new SVNErrorCode[]{event.getErrorMessage().getErrorCode()}, this.myEnvironment.isQuiet());
                    this.myIsInExternal = false;
                    return;
                }
                SVNErrorMessage warnMessage = SVNErrorMessage.create(SVNErrorCode.BASE, "Error handling externals definition for ''{0}'':", (Object)path);
                this.myEnvironment.handleWarning(warnMessage, new SVNErrorCode[]{warnMessage.getErrorCode()}, this.myEnvironment.isQuiet());
                this.myEnvironment.handleWarning(event.getErrorMessage(), new SVNErrorCode[]{event.getErrorMessage().getErrorCode()}, this.myEnvironment.isQuiet());
                return;
            }
            if (event.getAction() == SVNEventAction.UPDATE_STARTED) {
                if (!(this.myIsSuppressLastLine || this.myIsInExternal || this.myIsCheckout || this.myIsExport)) {
                    buffer.append("Updating '" + path + "':\n");
                }
            } else if (event.getAction() == SVNEventAction.UPDATE_COMPLETED) {
                if (!this.myIsSuppressLastLine) {
                    long rev = event.getRevision();
                    if (rev >= 0L) {
                        if (this.myIsExport) {
                            buffer.append(this.myIsInExternal ? "Exported external at revision " + rev + ".\n" : "Exported revision " + rev + ".\n");
                        } else if (this.myIsCheckout) {
                            buffer.append(this.myIsInExternal ? "Checked out external at revision " + rev + ".\n" : "Checked out revision " + rev + ".\n");
                        } else if (this.myIsChangesReceived) {
                            buffer.append(this.myIsInExternal ? "Updated external to revision " + rev + ".\n" : "Updated to revision " + rev + ".\n");
                        } else {
                            buffer.append(this.myIsInExternal ? "External at revision " + rev + ".\n" : "At revision " + rev + ".\n");
                        }
                    } else if (this.myIsExport) {
                        buffer.append(this.myIsInExternal ? "External export complete.\n" : "Export complete.\n");
                    } else if (this.myIsCheckout) {
                        buffer.append(this.myIsInExternal ? "External checkout complete.\n" : "Checkout complete.\n");
                    }
                }
                if (this.myIsInExternal) {
                    buffer.append('\n');
                    this.myIsInExternal = false;
                }
            } else if (event.getAction() == SVNEventAction.COMMIT_MODIFIED) {
                buffer.append((!this.isWcToReposCopy() ? "Sending        " : "Sending copy of       ") + path + "\n");
            } else if (event.getAction() == SVNEventAction.COMMIT_ADDED) {
                if (SVNProperty.isBinaryMimeType(event.getMimeType())) {
                    buffer.append((!this.isWcToReposCopy() ? "Adding  (bin)  " : "Adding copy of (bin)  ") + path + "\n");
                } else {
                    buffer.append((!this.isWcToReposCopy() ? "Adding         " : "Adding copy of        ") + path + "\n");
                }
            } else if (event.getAction() == SVNEventAction.COMMIT_DELETED) {
                buffer.append((!this.isWcToReposCopy() ? "Deleting       " : "Deleting copy of      ") + path + "\n");
            } else if (event.getAction() == SVNEventAction.COMMIT_REPLACED) {
                buffer.append((!this.isWcToReposCopy() ? "Replacing      " : "Replacing copy of     ") + path + "\n");
            } else if (event.getAction() == SVNEventAction.COMMIT_DELTA_SENT) {
                if (!this.myIsDeltaSent) {
                    this.myIsDeltaSent = true;
                    buffer.append("Transmitting file data ");
                }
                buffer.append('.');
            } else if (event.getAction() == SVNEventAction.ADD || event.getAction() == SVNEventAction.COPY) {
                if (SVNProperty.isBinaryMimeType(event.getMimeType())) {
                    buffer.append("A  (bin)  " + path + "\n");
                } else {
                    buffer.append("A         " + path + "\n");
                }
            } else if (event.getAction() == SVNEventAction.DELETE) {
                buffer.append("D         " + path + "\n");
            } else if (event.getAction() == SVNEventAction.REVERT) {
                buffer.append("Reverted '" + path + "'\n");
            } else if (event.getAction() == SVNEventAction.FAILED_REVERT) {
                buffer.append("Failed to revert '" + path + "' -- try updating instead.\n");
            } else if (event.getAction() == SVNEventAction.LOCKED) {
                buffer.append("'" + path + "' locked by user '" + event.getLock().getOwner() + "'.\n");
            } else if (event.getAction() == SVNEventAction.UNLOCKED) {
                buffer.append("'" + path + "' unlocked.\n");
            } else {
                if (event.getAction() == SVNEventAction.LOCK_FAILED || event.getAction() == SVNEventAction.UNLOCK_FAILED) {
                    this.myEnvironment.handleWarning(event.getErrorMessage(), new SVNErrorCode[]{event.getErrorMessage().getErrorCode()}, this.myEnvironment.isQuiet());
                    this.myHasLockingError = true;
                    return;
                }
                if (event.getAction() == SVNEventAction.RESOLVED) {
                    buffer.append("Resolved conflicted state of '" + path + "'\n");
                } else if (event.getAction() == SVNEventAction.CHANGELIST_SET) {
                    buffer.append("A [" + event.getChangelistName() + "] " + path + "\n");
                } else if (event.getAction() == SVNEventAction.CHANGELIST_CLEAR) {
                    buffer.append("D [" + event.getChangelistName() + "] " + path + "\n");
                } else {
                    if (event.getAction() == SVNEventAction.CHANGELIST_MOVED) {
                        this.myEnvironment.handleWarning(event.getErrorMessage(), new SVNErrorCode[]{event.getErrorMessage().getErrorCode()}, this.myEnvironment.isQuiet());
                        return;
                    }
                    if (event.getAction() == SVNEventAction.PATCH) {
                        this.myIsChangesReceived = true;
                        if (event.getContentsStatus() == SVNStatusType.CONFLICTED) {
                            this.getConflictStats().storeTextConflict(file.getAbsolutePath());
                            buffer.append('C');
                        } else if (event.getNodeKind() == SVNNodeKind.FILE) {
                            if (event.getContentsStatus() == SVNStatusType.MERGED) {
                                buffer.append('G');
                            } else if (event.getContentsStatus() == SVNStatusType.CHANGED) {
                                buffer.append('U');
                            }
                        }
                        if (buffer.length() < 1) {
                            buffer.append(' ');
                        }
                        if (event.getPropertiesStatus() == SVNStatusType.CONFLICTED) {
                            this.getConflictStats().storePropConflict(file.getAbsolutePath());
                            buffer.append('C');
                        } else if (event.getPropertiesStatus() == SVNStatusType.CHANGED) {
                            buffer.append('U');
                        }
                        if (buffer.length() < 2) {
                            buffer.append(' ');
                        }
                        if (buffer.charAt(0) != ' ' || buffer.charAt(1) != ' ') {
                            while (buffer.length() < 10) {
                                buffer.append(' ');
                            }
                            buffer.append(path);
                            buffer.append('\n');
                        }
                    } else if (event.getAction() == SVNEventAction.PATCH_APPLIED_HUNK) {
                        int hunkFuzz;
                        int hunkMatchedLine;
                        int hunkModifiedLength;
                        int hunkModifiedStart;
                        int hunkOriginalLength;
                        int hunkOriginalStart;
                        this.myIsChangesReceived = true;
                        Object info = event.getInfo();
                        if (info == null || !(info instanceof SVNPatchHunkInfo) && !(info instanceof SvnHunkInfo)) {
                            return;
                        }
                        if (info instanceof SVNPatchHunkInfo) {
                            SVNPatchHunkInfo hi = (SVNPatchHunkInfo)info;
                            SVNPatchHunk hunk = hi.getHunk();
                            hunkOriginalStart = hunk.getOriginal().getStart();
                            hunkOriginalLength = hunk.getOriginal().getLength();
                            hunkModifiedStart = hunk.getModified().getStart();
                            hunkModifiedLength = hunk.getModified().getLength();
                            hunkMatchedLine = hi.getMatchedLine();
                            hunkFuzz = hi.getFuzz();
                        } else {
                            assert (info instanceof SvnHunkInfo);
                            SvnHunkInfo hunkInfo = (SvnHunkInfo)info;
                            hunkOriginalStart = hunkInfo.getHunk().getDirectedOriginalStart();
                            hunkOriginalLength = hunkInfo.getHunk().getDirectedOriginalLength();
                            hunkModifiedStart = hunkInfo.getHunk().getDirectedModifiedStart();
                            hunkModifiedLength = hunkInfo.getHunk().getDirectedModifiedLength();
                            hunkMatchedLine = hunkInfo.getMatchedLine();
                            hunkFuzz = hunkInfo.getFuzz();
                        }
                        if (hunkOriginalStart != hunkMatchedLine) {
                            String minus;
                            long off;
                            if (hunkMatchedLine > hunkOriginalStart) {
                                off = hunkOriginalStart == 0 && hunkMatchedLine == 1 ? 0L : (long)(hunkMatchedLine - hunkOriginalStart);
                                minus = "";
                            } else {
                                off = hunkOriginalStart - hunkMatchedLine;
                                minus = "-";
                            }
                            if (hunkFuzz != 0) {
                                if (event.getPropertyName() != null) {
                                    buffer.append(">         applied hunk ## -");
                                    buffer.append(hunkOriginalStart);
                                    buffer.append(",");
                                    buffer.append(hunkOriginalLength);
                                    buffer.append(" +");
                                    buffer.append(hunkModifiedStart);
                                    buffer.append(",");
                                    buffer.append(hunkModifiedLength);
                                    buffer.append(" ## with offset ");
                                    buffer.append(minus);
                                    buffer.append(off);
                                    buffer.append(" and fuzz ");
                                    buffer.append(hunkFuzz);
                                    buffer.append(" (");
                                    buffer.append(event.getPropertyName());
                                    buffer.append(")\n");
                                } else {
                                    buffer.append(">         applied hunk @@ -");
                                    buffer.append(hunkOriginalStart);
                                    buffer.append(",");
                                    buffer.append(hunkOriginalLength);
                                    buffer.append(" +");
                                    buffer.append(hunkModifiedStart);
                                    buffer.append(",");
                                    buffer.append(hunkModifiedLength);
                                    buffer.append(" @@ with offset ");
                                    buffer.append(minus);
                                    buffer.append(off);
                                    buffer.append(" and fuzz ");
                                    buffer.append(hunkFuzz);
                                    buffer.append('\n');
                                }
                            } else if (event.getPropertyName() != null) {
                                buffer.append(">         applied hunk ## -");
                                buffer.append(hunkOriginalStart);
                                buffer.append(",");
                                buffer.append(hunkOriginalLength);
                                buffer.append(" +");
                                buffer.append(hunkModifiedStart);
                                buffer.append(",");
                                buffer.append(hunkModifiedLength);
                                buffer.append(" ## with offset ");
                                buffer.append(minus);
                                buffer.append(off);
                                buffer.append(" (");
                                buffer.append(event.getPropertyName());
                                buffer.append(")\n");
                            } else {
                                buffer.append(">         applied hunk @@ -");
                                buffer.append(hunkOriginalStart);
                                buffer.append(",");
                                buffer.append(hunkOriginalLength);
                                buffer.append(" +");
                                buffer.append(hunkModifiedStart);
                                buffer.append(",");
                                buffer.append(hunkModifiedLength);
                                buffer.append(" @@ with offset ");
                                buffer.append(minus);
                                buffer.append(off);
                                buffer.append('\n');
                            }
                        } else if (hunkFuzz > 0) {
                            if (event.getPropertyName() != null) {
                                buffer.append(">         applied hunk ## -");
                                buffer.append(hunkOriginalStart);
                                buffer.append(",");
                                buffer.append(hunkOriginalLength);
                                buffer.append(" +");
                                buffer.append(hunkModifiedStart);
                                buffer.append(",");
                                buffer.append(hunkModifiedLength);
                                buffer.append(" ## with fuzz ");
                                buffer.append(hunkFuzz);
                                buffer.append(" (");
                                buffer.append(event.getPropertyName());
                                buffer.append(")\n");
                            } else {
                                buffer.append(">         applied hunk @@ -");
                                buffer.append(hunkOriginalStart);
                                buffer.append(",");
                                buffer.append(hunkOriginalLength);
                                buffer.append(" +");
                                buffer.append(hunkModifiedStart);
                                buffer.append(",");
                                buffer.append(hunkModifiedLength);
                                buffer.append(" @@ with fuzz ");
                                buffer.append(hunkFuzz);
                                buffer.append('\n');
                            }
                        }
                    } else if (event.getAction() == SVNEventAction.PATCH_REJECTED_HUNK) {
                        int hunkModifiedLength;
                        int hunkModifiedStart;
                        int hunkOriginalLength;
                        int hunkOriginalStart;
                        this.myIsChangesReceived = true;
                        Object info = event.getInfo();
                        if (info == null || !(info instanceof SVNPatchHunkInfo) && !(info instanceof SvnHunkInfo)) {
                            return;
                        }
                        if (info instanceof SVNPatchHunkInfo) {
                            SVNPatchHunkInfo hi = (SVNPatchHunkInfo)info;
                            SVNPatchHunk hunk = hi.getHunk();
                            hunkOriginalStart = hunk.getOriginal().getStart();
                            hunkOriginalLength = hunk.getOriginal().getLength();
                            hunkModifiedStart = hunk.getModified().getStart();
                            hunkModifiedLength = hunk.getModified().getLength();
                            int hunkMatchedLine = hi.getMatchedLine();
                            int hunkFuzz = hi.getFuzz();
                        } else {
                            assert (info instanceof SvnHunkInfo);
                            SvnHunkInfo hunkInfo = (SvnHunkInfo)info;
                            hunkOriginalStart = hunkInfo.getHunk().getDirectedOriginalStart();
                            hunkOriginalLength = hunkInfo.getHunk().getDirectedOriginalLength();
                            hunkModifiedStart = hunkInfo.getHunk().getDirectedModifiedStart();
                            hunkModifiedLength = hunkInfo.getHunk().getDirectedModifiedLength();
                            int hunkMatchedLine = hunkInfo.getMatchedLine();
                            int hunkFuzz = hunkInfo.getFuzz();
                        }
                        buffer.append(">         rejected hunk @@ -");
                        buffer.append(hunkOriginalStart);
                        buffer.append(",");
                        buffer.append(hunkOriginalLength);
                        buffer.append(" +");
                        buffer.append(hunkModifiedStart);
                        buffer.append(",");
                        buffer.append(hunkModifiedLength);
                        buffer.append(" @@\n");
                    } else if (event.getAction() == SVNEventAction.PATCH_HUNK_ALREADY_APPLIED) {
                        int hunkMatchedLine;
                        int hunkModifiedLength;
                        int hunkModifiedStart;
                        int hunkOriginalLength;
                        int hunkOriginalStart;
                        this.myIsChangesReceived = true;
                        Object info = event.getInfo();
                        if (info == null || !(info instanceof SVNPatchHunkInfo) && !(info instanceof SvnHunkInfo)) {
                            return;
                        }
                        if (info instanceof SVNPatchHunkInfo) {
                            SVNPatchHunkInfo hi = (SVNPatchHunkInfo)info;
                            SVNPatchHunk hunk = hi.getHunk();
                            hunkOriginalStart = hunk.getOriginal().getStart();
                            hunkOriginalLength = hunk.getOriginal().getLength();
                            hunkModifiedStart = hunk.getModified().getStart();
                            hunkModifiedLength = hunk.getModified().getLength();
                            hunkMatchedLine = hi.getMatchedLine();
                            int hunkFuzz = hi.getFuzz();
                        } else {
                            assert (info instanceof SvnHunkInfo);
                            SvnHunkInfo hunkInfo = (SvnHunkInfo)info;
                            hunkOriginalStart = hunkInfo.getHunk().getDirectedOriginalStart();
                            hunkOriginalLength = hunkInfo.getHunk().getDirectedOriginalLength();
                            hunkModifiedStart = hunkInfo.getHunk().getDirectedModifiedStart();
                            hunkModifiedLength = hunkInfo.getHunk().getDirectedModifiedLength();
                            hunkMatchedLine = hunkInfo.getMatchedLine();
                            int hunkFuzz = hunkInfo.getFuzz();
                        }
                        if (event.getPropertyName() != null) {
                            buffer.append(">         hunk ## -");
                            buffer.append(hunkOriginalStart);
                            buffer.append(",");
                            buffer.append(hunkOriginalLength);
                            buffer.append(" +");
                            buffer.append(hunkModifiedStart);
                            buffer.append(",");
                            buffer.append(hunkMatchedLine);
                            buffer.append(" ## already applied (");
                            buffer.append(event.getPropertyName());
                            buffer.append(")\n");
                        } else {
                            buffer.append(">         hunk @@ -");
                            buffer.append(hunkOriginalStart);
                            buffer.append(",");
                            buffer.append(hunkOriginalLength);
                            buffer.append(" +");
                            buffer.append(hunkModifiedStart);
                            buffer.append(",");
                            buffer.append(hunkModifiedLength);
                            buffer.append(" @@ already applied\n");
                        }
                    } else if (event.getAction() == SVNEventAction.UPGRADED_PATH) {
                        this.myIsChangesReceived = true;
                        buffer.append("Upgraded '" + path + "'\n");
                    } else if (event.getAction() == SVNEventAction.FOREIGN_COPY_BEGIN && event.getMergeRange() == null) {
                        buffer.append("--- Copying from foreign repository URL '");
                        buffer.append(event.getURL());
                        buffer.append("':\n");
                    }
                }
            }
        }
        if (buffer.length() > 0) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.CLIENT, buffer.toString());
            out.print(buffer);
        }
    }

    @Override
    public void checkCancelled() throws SVNCancelException {
        this.myEnvironment.checkCancelled();
    }

    public void printConflictStatus(StringBuffer buffer) {
        SVNConflictStats conflictStats = this.getConflictStats();
        int textConflicts = 0;
        int propConflicts = 0;
        int treeConflicts = 0;
        int skippedPaths = 0;
        String header = null;
        header = "Summary of conflicts:\n";
        textConflicts = conflictStats.getTextConflictsCount();
        propConflicts = conflictStats.getPropConflictsCount();
        treeConflicts = conflictStats.getTreeConflictsCount();
        skippedPaths = conflictStats.getSkippedPathsCount();
        if (textConflicts > 0 || propConflicts > 0 || treeConflicts > 0 || skippedPaths > 0 || conflictStats.getResolvedTextConflictsCount() > 0 || conflictStats.getResolvedPropConflictsCount() > 0 || conflictStats.getResolvedTreeConflictsCount() > 0) {
            buffer.append(header);
        }
        if (conflictStats.getResolvedTextConflictsCount() == 0 && conflictStats.getResolvedPropConflictsCount() == 0 && conflictStats.getResolvedTreeConflictsCount() == 0) {
            if (textConflicts > 0) {
                buffer.append("  Text conflicts: ");
                buffer.append(textConflicts);
                buffer.append("\n");
            }
            if (propConflicts > 0) {
                buffer.append("  Property conflicts: ");
                buffer.append(propConflicts);
                buffer.append("\n");
            }
            if (treeConflicts > 0) {
                buffer.append("  Tree conflicts: ");
                buffer.append(treeConflicts);
                buffer.append("\n");
            }
        } else {
            if (textConflicts > 0 || conflictStats.getResolvedTextConflictsCount() > 0) {
                buffer.append("  Text conflicts: ");
                this.appendRemaining(buffer, textConflicts);
                buffer.append(" (");
                this.appendResolved(buffer, conflictStats.getResolvedTextConflictsCount());
                buffer.append(")");
                buffer.append("\n");
            }
            if (propConflicts > 0 || conflictStats.getResolvedPropConflictsCount() > 0) {
                buffer.append("  Property conflicts: ");
                this.appendRemaining(buffer, propConflicts);
                buffer.append(" (");
                this.appendResolved(buffer, conflictStats.getResolvedPropConflictsCount());
                buffer.append(")");
                buffer.append("\n");
            }
            if (treeConflicts > 0 || conflictStats.getResolvedTreeConflictsCount() > 0) {
                buffer.append("  Tree conflicts: ");
                this.appendRemaining(buffer, treeConflicts);
                buffer.append(" (");
                this.appendResolved(buffer, conflictStats.getResolvedTreeConflictsCount());
                buffer.append(")");
                buffer.append("\n");
            }
        }
        if (skippedPaths > 0) {
            buffer.append("  Skipped paths: ");
            buffer.append(skippedPaths);
            buffer.append("\n");
        }
    }

    private void appendRemaining(StringBuffer buffer, int conflictsCount) {
        buffer.append(conflictsCount).append(" remaining");
    }

    private void appendResolved(StringBuffer buffer, int resolvedTreeConflictsCount) {
        buffer.append("and ").append(resolvedTreeConflictsCount).append(" already resolved");
    }

    private SVNConflictStats getConflictStats() {
        return this.myEnvironment.getConflictStats();
    }
}

