/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnlook;

import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookOption;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.DefaultSVNGNUDiffGenerator;
import afu.org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;

public class SVNLookDiffCommand
extends SVNLookCommand {
    public SVNLookDiffCommand() {
        super("diff", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNLookOption> options = new LinkedList<SVNLookOption>();
        options.add(SVNLookOption.REVISION);
        options.add(SVNLookOption.TRANSACTION);
        options.add(SVNLookOption.NO_DIFF_DELETED);
        options.add(SVNLookOption.NO_DIFF_ADDED);
        options.add(SVNLookOption.DIFF_COPY_FROM);
        options.add(SVNLookOption.EXTENSIONS);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        SVNLookClient client = environment.getClientManager().getLookClient();
        DefaultSVNGNUDiffGenerator defaultDiffGenerator = new DefaultSVNGNUDiffGenerator();
        defaultDiffGenerator.setOptions(client.getOptions());
        defaultDiffGenerator.setDiffOptions(environment.getDiffOptions());
        client.setDiffGenerator(defaultDiffGenerator);
        if (environment.isRevision()) {
            client.doGetDiff(environment.getRepositoryFile(), this.getRevisionObject(), !environment.isNoDiffDeleted(), !environment.isNoDiffAdded(), environment.isDiffCopyFrom(), (OutputStream)environment.getOut());
        } else {
            client.doGetDiff(environment.getRepositoryFile(), environment.getTransaction(), !environment.isNoDiffDeleted(), !environment.isNoDiffAdded(), environment.isDiffCopyFrom(), (OutputStream)environment.getOut());
        }
    }
}

