/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svnlook;

import afu.org.tmatesoft.svn.cli.SVNCommandUtil;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommand;
import afu.org.tmatesoft.svn.cli.svnlook.SVNLookCommandEnvironment;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNLock;
import afu.org.tmatesoft.svn.core.internal.util.SVNDate;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.wc.ISVNOptions;
import afu.org.tmatesoft.svn.core.wc.admin.SVNLookClient;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.util.Collection;
import java.util.LinkedList;

public class SVNLookLockCommand
extends SVNLookCommand {
    protected SVNLookLockCommand() {
        super("lock", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        return new LinkedList();
    }

    @Override
    public void run() throws SVNException {
        SVNLookClient client;
        SVNLock lock;
        SVNLookCommandEnvironment environment = this.getSVNLookEnvironment();
        String path = environment.getFirstArgument();
        if (environment.getFirstArgument() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Missing path argument");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if ((lock = (client = environment.getClientManager().getLookClient()).doGetLock(environment.getRepositoryFile(), path)) != null) {
            String comment;
            ISVNOptions options = this.getEnvironment().getClientManager().getOptions();
            String creationDate = SVNDate.formatHumanDate(lock.getCreationDate(), options);
            String expirationDate = lock.getExpirationDate() != null ? SVNDate.formatHumanDate(lock.getExpirationDate(), options) : "";
            int commentLinesCount = lock.getComment() != null ? SVNCommandUtil.getLinesCount(lock.getComment()) : 0;
            this.getSVNLookEnvironment().getOut().println("UUID Token: " + lock.getID());
            this.getSVNLookEnvironment().getOut().println("Owner: " + lock.getOwner());
            this.getSVNLookEnvironment().getOut().println("Created: " + creationDate);
            this.getSVNLookEnvironment().getOut().println("Expires: " + expirationDate);
            String countMessage = "Comment (" + commentLinesCount + " ";
            String string = comment = lock.getComment() != null ? lock.getComment() : "";
            if (commentLinesCount != 1) {
                this.getSVNLookEnvironment().getOut().println(countMessage + " lines):");
                this.getSVNLookEnvironment().getOut().println(comment);
            } else {
                this.getSVNLookEnvironment().getOut().println(countMessage + "line):");
                this.getSVNLookEnvironment().getOut().println(comment);
            }
        }
    }
}

