/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.auth;

import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.auth.SVNAuthentication;
import afu.org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;

public class SVNPasswordAuthentication
extends SVNAuthentication {
    private char[] myPassword;

    public static SVNPasswordAuthentication newInstance(String userName, char[] password, boolean storageAllowed, SVNURL url, boolean isPartial) {
        return new SVNPasswordAuthentication(userName, password, storageAllowed, url, isPartial);
    }

    public SVNPasswordAuthentication(String userName, String password, boolean storageAllowed) {
        this(userName, password == null ? new char[]{} : password.toCharArray(), storageAllowed, null, false);
    }

    public SVNPasswordAuthentication(String userName, String password, boolean storageAllowed, SVNURL url, boolean isPartial) {
        this(userName, password == null ? new char[]{} : password.toCharArray(), storageAllowed, url, isPartial);
    }

    private SVNPasswordAuthentication(String userName, char[] password, boolean storageAllowed, SVNURL url, boolean isPartial) {
        super("svn.simple", userName, storageAllowed, url, isPartial);
        this.myPassword = password == null ? new char[]{} : password;
    }

    public String getPassword() {
        return new String(this.myPassword);
    }

    public char[] getPasswordValue() {
        return this.myPassword;
    }

    @Override
    public void dismissSensitiveData() {
        super.dismissSensitiveData();
        SVNEncodingUtil.clearArray(this.myPassword);
    }

    @Override
    public SVNAuthentication copy() {
        return new SVNPasswordAuthentication(this.getUserName(), this.copyOf(this.myPassword), this.isStorageAllowed(), this.getURL(), this.isPartial());
    }
}

