/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.db;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import afu.org.tmatesoft.svn.core.internal.db.SVNSqlJetSelectStatement;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.util.ArrayList;
import java.util.List;

public abstract class SVNSqlJetSelectFieldsStatement<E extends Enum<E>>
extends SVNSqlJetSelectStatement {
    protected final List<E> fields = new ArrayList();

    public SVNSqlJetSelectFieldsStatement(SVNSqlJetDb sDb, Enum<?> fromTable) throws SVNException {
        this(sDb, fromTable.toString());
    }

    public SVNSqlJetSelectFieldsStatement(SVNSqlJetDb sDb, String fromTable) throws SVNException {
        super(sDb, fromTable);
        this.defineFields();
    }

    public SVNSqlJetSelectFieldsStatement(SVNSqlJetDb sDb, Enum<?> fromTable, Enum<?> indexName) throws SVNException {
        super(sDb, fromTable, indexName);
        this.defineFields();
    }

    protected abstract void defineFields();

    public long getColumnLong(int f) throws SVNException {
        return this.getColumnLong(this.getFieldName(f));
    }

    public String getColumnString(int f) throws SVNException {
        return this.getColumnString(this.getFieldName(f));
    }

    public boolean isColumnNull(int f) throws SVNException {
        return this.isColumnNull(this.getFieldName(f));
    }

    public byte[] getColumnBlob(int f) throws SVNException {
        return this.getColumnBlob(this.getFieldName(f));
    }

    protected void checkField(int f) throws SVNException {
        SVNErrorManager.assertionFailure(this.fields.size() > 0, "fields not defined", SVNLogType.WC);
        SVNErrorManager.assertionFailure(f >= 0 && f < this.fields.size(), String.format("%d is not valid field index", f), SVNLogType.WC);
        SVNErrorManager.assertionFailure(this.fields.get(f) != null, String.format("field #%d is not defined", f), SVNLogType.WC);
    }

    protected String getFieldName(int f) throws SVNException {
        this.checkField(f);
        return ((Enum)this.fields.get(f)).toString();
    }
}

