/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.io.dav.http;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.HTTPConnection;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnection;
import afu.org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import afu.org.tmatesoft.svn.core.io.SVNRepository;
import java.io.File;

public class DefaultHTTPConnectionFactory
implements IHTTPConnectionFactory {
    private File mySpoolDirectory;
    private String myHTTPCharset;
    private boolean myIsSpoolAll;
    private boolean myIsUseSendAll;

    public DefaultHTTPConnectionFactory(File spoolDirectory, boolean spoolAll, String httpCharset) {
        this(spoolDirectory, spoolAll, false, httpCharset);
    }

    public DefaultHTTPConnectionFactory(File spoolDirectory, boolean spoolAll, boolean useSendAllForDiff, String httpCharset) {
        this.mySpoolDirectory = spoolDirectory;
        this.myIsSpoolAll = spoolAll;
        this.myHTTPCharset = httpCharset;
        this.myIsUseSendAll = useSendAllForDiff;
    }

    @Override
    public IHTTPConnection createHTTPConnection(SVNRepository repository) throws SVNException {
        String charset = this.myHTTPCharset != null ? this.myHTTPCharset : System.getProperty("svnkit.http.encoding", "UTF-8");
        File spoolLocation = this.mySpoolDirectory;
        if (this.mySpoolDirectory != null && !this.mySpoolDirectory.isDirectory()) {
            spoolLocation = null;
        }
        return new HTTPConnection(repository, charset, spoolLocation, this.myIsSpoolAll);
    }

    @Override
    public boolean useSendAllForDiff(SVNRepository repository) throws SVNException {
        return this.myIsUseSendAll;
    }
}

