/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.internal.wc17;

import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNProperties;
import afu.org.tmatesoft.svn.core.SVNPropertyValue;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.util.SVNDate;
import afu.org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;
import java.util.Arrays;

public class SVNWCUtils {
    public static boolean isRecursiveDepth(SVNDepth depth) {
        return depth == SVNDepth.INFINITY || depth == SVNDepth.UNKNOWN;
    }

    public static File admChild(File dirAbsPath, String admChildFileName) {
        return SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(dirAbsPath, SVNFileUtil.getAdminDirectoryName()), admChildFileName);
    }

    public static void admCleanupTmpArea(SVNWCContext context, File dirAbsPath) throws SVNException {
        assert (SVNFileUtil.isAbsolute(dirAbsPath));
        context.writeCheck(dirAbsPath);
        File tmpPath = SVNWCUtils.admChild(dirAbsPath, "tmp");
        SVNFileUtil.deleteAll(tmpPath, true);
        SVNWCUtils.admInitTmpArea(dirAbsPath);
    }

    public static void admInitTmpArea(File dirAbsPath) throws SVNException {
        SVNFileUtil.ensureDirectoryExists(SVNWCUtils.admChild(dirAbsPath, "tmp"));
    }

    public static SVNDate readDate(long date) {
        long time = date / 1000L;
        return new SVNDate(time, (int)(date - time * 1000L));
    }

    public static SVNProperties propDiffs(SVNProperties targetProps, SVNProperties sourceProps) {
        SVNProperties propdiffs = new SVNProperties();
        for (String key : sourceProps.nameSet()) {
            SVNPropertyValue p;
            byte[] propVal1 = SVNPropertyValue.getPropertyAsBytes(sourceProps.getSVNPropertyValue(key));
            byte[] propVal2 = SVNPropertyValue.getPropertyAsBytes(targetProps.getSVNPropertyValue(key));
            if (propVal2 == null) {
                p = SVNPropertyValue.create(null);
                propdiffs.put(key, p);
                continue;
            }
            if (Arrays.equals(propVal1, propVal2)) continue;
            p = SVNPropertyValue.create(key, propVal2);
            propdiffs.put(key, p);
        }
        for (String key : targetProps.nameSet()) {
            SVNPropertyValue propVal = targetProps.getSVNPropertyValue(key);
            if (null != sourceProps.getSVNPropertyValue(key)) continue;
            SVNPropertyValue p = propVal;
            propdiffs.put(key, p);
        }
        return propdiffs;
    }

    public static int relpathDepth(File relpath) {
        if (relpath == null) {
            return 0;
        }
        return SVNWCUtils.relpathDepth(relpath.getPath().replace(File.separatorChar, '/'));
    }

    public static int relpathDepth(String relpath) {
        if (relpath == null || "".equals(relpath)) {
            return 0;
        }
        int n = 1;
        int length = relpath.length();
        for (int i = 0; i < length; ++i) {
            if (relpath.charAt(i) != '/') continue;
            ++n;
        }
        return n;
    }

    public static UnserializedFileExternalInfo unserializeFileExternal(String str) throws SVNException {
        UnserializedFileExternalInfo info = new UnserializedFileExternalInfo();
        if (str != null) {
            StringBuffer buffer = new StringBuffer(str);
            info.pegRevision = SVNAdminUtil.parseRevision(buffer);
            info.revision = SVNAdminUtil.parseRevision(buffer);
            info.path = buffer.toString();
        }
        return info;
    }

    public static String serializeFileExternal(String path, SVNRevision pegRevision, SVNRevision revision) throws SVNException {
        String representation = null;
        if (path != null) {
            String revStr = SVNAdminUtil.asString(revision, path);
            String pegRevStr = SVNAdminUtil.asString(pegRevision, path);
            representation = pegRevStr + ":" + revStr + ":" + path;
        }
        return representation;
    }

    public static String getPathAsChild(File parent, File child) {
        if (parent == null || child == null) {
            return null;
        }
        if (parent.equals(child)) {
            return null;
        }
        String parentPath = parent.toString();
        String childPath = child.toString();
        return SVNWCUtils.isChild(parentPath, childPath);
    }

    public static boolean isChild(File parent, File child) {
        return SVNWCUtils.isChild(SVNFileUtil.getFilePath(parent), SVNFileUtil.getFilePath(child)) != null;
    }

    public static String isChild(String parentPath, String childPath) {
        if (childPath.equals(parentPath)) {
            return "";
        }
        if ("".equals(parentPath)) {
            return childPath;
        }
        if (!(childPath = childPath.replace(File.separatorChar, '/')).startsWith((parentPath = parentPath.replace(File.separatorChar, '/')) + '/')) {
            return null;
        }
        return childPath.substring(parentPath.length() + 1);
    }

    public static boolean isAncestor(File parent, File child) {
        if (parent == null || child == null) {
            return false;
        }
        if (parent.equals(child)) {
            return true;
        }
        String parentPath = parent.getPath().replace(File.separatorChar, '/');
        String childPath = child.getPath().replace(File.separatorChar, '/');
        if ("".equals(parentPath)) {
            return !childPath.startsWith("/");
        }
        return childPath.startsWith(parentPath + "/");
    }

    public static File skipAncestor(File parent, File child) {
        if (!SVNWCUtils.isAncestor(parent, child)) {
            return child;
        }
        return SVNFileUtil.createFilePath(SVNWCUtils.getPathAsChild(parent, child));
    }

    public static String isChild(SVNURL parent, SVNURL child) {
        if (parent == null || child == null) {
            return null;
        }
        if (parent.equals(child)) {
            return null;
        }
        String parentPath = parent.toDecodedString();
        String childPath = child.toDecodedString();
        return SVNWCUtils.isChild(parentPath, childPath);
    }

    public static SVNURL join(SVNURL rootUrl, File relPath) throws SVNException {
        return rootUrl.appendPath(SVNFileUtil.getFilePath(relPath), false);
    }

    public static long parseLong(String value) throws SVNException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Could not convert ''{0}'' into a number", (Object)value);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
            return 0L;
        }
    }

    public static class UnserializedFileExternalInfo {
        public String path = null;
        public SVNRevision pegRevision = SVNRevision.UNDEFINED;
        public SVNRevision revision = SVNRevision.UNDEFINED;
    }
}

