/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.javahl;

import afu.org.tigris.subversion.javahl.JavaHLObjectFactory;
import afu.org.tigris.subversion.javahl.PropertyData;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import afu.org.tmatesoft.svn.core.wc.SVNPropertyData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

class JavaHLPropertyHandler
implements ISVNPropertyHandler {
    private PropertyData myData = null;
    private Object myOwner;
    private Collection myAllData;

    public JavaHLPropertyHandler(Object owner) {
        this.myOwner = owner;
        this.myAllData = new ArrayList();
    }

    @Override
    public void handleProperty(File path, SVNPropertyData property) throws SVNException {
        this.myData = JavaHLObjectFactory.createPropertyData(this.myOwner, path.getAbsolutePath(), property.getName(), property.getValue());
        this.myAllData.add(this.myData);
    }

    @Override
    public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
        this.myData = JavaHLObjectFactory.createPropertyData(this.myOwner, url.toString(), property.getName(), property.getValue());
        this.myAllData.add(this.myData);
    }

    @Override
    public void handleProperty(long revision, SVNPropertyData property) throws SVNException {
        this.myData = JavaHLObjectFactory.createPropertyData(this.myOwner, null, property.getName(), property.getValue());
        this.myAllData.add(this.myData);
    }

    public PropertyData getPropertyData() {
        if (this.myData == null) {
            return null;
        }
        if (this.myData.getValue() == null) {
            return null;
        }
        return this.myData;
    }

    public PropertyData[] getAllPropertyData() {
        return this.myAllData.toArray(new PropertyData[this.myAllData.size()]);
    }
}

