/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.wc;

import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import afu.org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import afu.org.tmatesoft.svn.core.internal.wc16.SVNBasicDelegate;
import afu.org.tmatesoft.svn.core.wc.DefaultSVNRepositoryPool;
import afu.org.tmatesoft.svn.core.wc.ISVNEventHandler;
import afu.org.tmatesoft.svn.core.wc.ISVNOptions;
import afu.org.tmatesoft.svn.core.wc.ISVNPathListHandler;
import afu.org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc.SVNWCUtil;
import afu.org.tmatesoft.svn.core.wc2.SvnGetInfo;
import afu.org.tmatesoft.svn.core.wc2.SvnInfo;
import afu.org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import afu.org.tmatesoft.svn.core.wc2.SvnTarget;
import afu.org.tmatesoft.svn.util.ISVNDebugLog;
import afu.org.tmatesoft.svn.util.SVNDebugLog;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.io.File;

public class SVNBasicClient {
    private static final String SVNKIT_WC_17_PROPERTY = "svnkit.wc.17";
    private static final String SVNKIT_WC_17_DEFAULT = "true";
    private static final String SVNKIT_WC_17_EXPECTED = "true";
    private SvnOperationFactory operationFactory;
    private boolean ignoreExternals;
    private boolean leaveConflictsUnresolved;
    private ISVNPathListHandler pathListHandler;
    private ISVNDebugLog debugLog;

    protected SVNBasicClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        if (authManager == null) {
            authManager = SVNWCUtil.createDefaultAuthenticationManager();
        }
        if (options == null) {
            options = SVNWCUtil.createDefaultOptions(true);
        }
        this.operationFactory = new SvnOperationFactory();
        this.setOptions(options);
        this.operationFactory.setAuthenticationManager(authManager);
        this.operationFactory.setRepositoryPool(new DefaultSVNRepositoryPool(authManager, options));
        this.operationFactory.setAutoDisposeRepositoryPool(true);
        this.initDefaults();
    }

    protected SVNBasicClient(ISVNRepositoryPool pool, ISVNOptions options) {
        boolean autoDisposeRepositoryPool = false;
        if (pool == null) {
            pool = new DefaultSVNRepositoryPool(SVNWCUtil.createDefaultAuthenticationManager(), options);
            autoDisposeRepositoryPool = true;
        }
        if (options == null) {
            options = SVNWCUtil.createDefaultOptions(true);
        }
        this.operationFactory = new SvnOperationFactory();
        this.setOptions(options);
        this.operationFactory.setRepositoryPool(pool);
        this.operationFactory.setAutoDisposeRepositoryPool(autoDisposeRepositoryPool);
        this.initDefaults();
    }

    protected SVNBasicClient(SvnOperationFactory of) {
        this.operationFactory = of;
        this.setOptions(of.getOptions());
        this.initDefaults();
    }

    protected void initDefaults() {
        this.setPathListHandler(null);
        this.setDebugLog(null);
        this.setEventPathPrefix(null);
        this.setEventHandler(null);
    }

    public static boolean isWC17Supported() {
        return "true".equalsIgnoreCase(System.getProperty(SVNKIT_WC_17_PROPERTY, "true"));
    }

    protected static SVNBasicDelegate dontWC17Support() throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_UNSUPPORTED_FORMAT);
        SVNErrorManager.error(err, SVNLogType.CLIENT);
        return null;
    }

    public ISVNOptions getOptions() {
        return this.getOperationsFactory().getOptions();
    }

    public void setOptions(ISVNOptions options) {
        if (options == null) {
            options = SVNWCUtil.createDefaultOptions(true);
        }
        this.getOperationsFactory().setOptions(options);
    }

    public void setIgnoreExternals(boolean ignore) {
        this.ignoreExternals = ignore;
    }

    public boolean isIgnoreExternals() {
        return this.ignoreExternals;
    }

    public void setLeaveConflictsUnresolved(boolean leave) {
        this.leaveConflictsUnresolved = leave;
    }

    public boolean isLeaveConflictsUnresolved() {
        return this.leaveConflictsUnresolved;
    }

    public void setEventHandler(ISVNEventHandler dispatcher) {
        this.getOperationsFactory().setEventHandler(dispatcher);
    }

    public void setPathListHandler(ISVNPathListHandler handler) {
        this.pathListHandler = handler;
    }

    public ISVNPathListHandler getPathListHandler() {
        return this.pathListHandler;
    }

    public void setDebugLog(ISVNDebugLog log) {
        if (log == null) {
            log = SVNDebugLog.getDefaultLog();
        }
        this.debugLog = log;
    }

    public ISVNDebugLog getDebugLog() {
        return this.debugLog;
    }

    public SVNURL getReposRoot(File path, SVNURL url, SVNRevision pegRevision, SVNAdminArea adminArea, SVNWCAccess access) throws SVNException {
        SVNBasicDelegate delegate = new SVNBasicDelegate(this.getOperationsFactory().getAuthenticationManager(), this.getOperationsFactory().getOptions());
        return delegate.getReposRoot(path, url, pegRevision, adminArea, access);
    }

    public SVNURL getReposRoot(File path, SVNURL url, SVNRevision pegRevision) throws SVNException {
        SvnGetInfo info = this.getOperationsFactory().createGetInfo();
        if (path != null) {
            info.setSingleTarget(SvnTarget.fromFile(path, pegRevision));
        } else {
            info.setSingleTarget(SvnTarget.fromURL(url, pegRevision));
        }
        info.setDepth(SVNDepth.EMPTY);
        SvnInfo i = (SvnInfo)info.run();
        return i != null ? i.getRepositoryRootUrl() : null;
    }

    public void setEventPathPrefix(String prefix) {
    }

    public SvnOperationFactory getOperationsFactory() {
        return this.operationFactory;
    }
}

