/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.core.wc2;

import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.SVNNodeKind;
import afu.org.tmatesoft.svn.core.SVNURL;
import afu.org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import afu.org.tmatesoft.svn.core.internal.wc2.ISvnCommitRunner;
import afu.org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import afu.org.tmatesoft.svn.core.wc.SVNCommitItem;
import afu.org.tmatesoft.svn.core.wc.SVNCommitPacket;
import afu.org.tmatesoft.svn.core.wc2.SvnCommitItem;
import afu.org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class SvnCommitPacket {
    private Map<SVNURL, Collection<SvnCommitItem>> items;
    private Map<String, SvnCommitItem> itemsByPath;
    private Object lockingContext;
    private ISvnCommitRunner runner;
    private Map<SVNURL, String> lockTokens;
    private Set<String> skippedPaths;
    private AtomicInteger sharedIndex;

    public SvnCommitPacket() {
        this.items = new HashMap<SVNURL, Collection<SvnCommitItem>>();
        this.itemsByPath = new HashMap<String, SvnCommitItem>();
        this.lockTokens = new HashMap<SVNURL, String>();
        this.skippedPaths = new HashSet<String>();
    }

    private SvnCommitPacket(Map<SVNURL, Collection<SvnCommitItem>> items, Map<String, SvnCommitItem> itemsByPath, Object lockingContext, Map<SVNURL, String> lockTokens, ISvnCommitRunner runner, Set<String> skippedPaths) {
        this.items = items;
        this.itemsByPath = itemsByPath;
        this.lockingContext = lockingContext;
        this.lockTokens = lockTokens;
        this.runner = runner;
        this.skippedPaths = skippedPaths;
    }

    public boolean hasItem(File path) {
        return this.itemsByPath.containsKey(SVNFileUtil.getFilePath(path));
    }

    public SvnCommitItem getItem(File path) {
        return this.itemsByPath.get(SVNFileUtil.getFilePath(path));
    }

    public Collection<SVNURL> getRepositoryRoots() {
        return Collections.unmodifiableCollection(this.items.keySet());
    }

    public Collection<SvnCommitItem> getItems(SVNURL url) {
        return Collections.unmodifiableCollection(this.items.get(url));
    }

    public void addItem(SvnCommitItem item, SVNURL repositoryRoot) {
        if (!this.items.containsKey(repositoryRoot)) {
            this.items.put(repositoryRoot, new HashSet());
        }
        this.items.get(repositoryRoot).add(item);
        this.itemsByPath.put(item.getPath() != null ? SVNFileUtil.getFilePath(item.getPath()) : null, item);
    }

    public SvnCommitItem addItem(File path, SVNNodeKind kind, SVNURL repositoryRoot, String repositoryPath, long revision, String copyFromPath, long copyFromRevision, File movedFromAbsPath, int flags) throws SVNException {
        SvnCommitItem item = new SvnCommitItem();
        item.setPath(path);
        item.setKind(kind);
        item.setUrl(repositoryRoot.appendPath(repositoryPath, false));
        item.setRevision(revision);
        if (copyFromPath != null) {
            item.setCopyFromUrl(repositoryRoot.appendPath(copyFromPath, false));
            item.setCopyFromRevision(copyFromRevision);
        } else {
            item.setCopyFromRevision(-1L);
        }
        item.setMovedFromAbsPath(movedFromAbsPath);
        item.setFlags(flags);
        this.addItem(item, repositoryRoot);
        return item;
    }

    public SvnCommitItem addItem(File path, SVNURL rootUrl, SVNNodeKind kind, SVNURL url, long revision, SVNURL copyFromUrl, long copyFromRevision, int flags) throws SVNException {
        SvnCommitItem item = new SvnCommitItem();
        item.setPath(path);
        item.setKind(kind);
        item.setUrl(url);
        item.setRevision(revision);
        if (copyFromUrl != null) {
            item.setCopyFromUrl(copyFromUrl);
            item.setCopyFromRevision(copyFromRevision);
        } else {
            item.setCopyFromRevision(-1L);
        }
        item.setFlags(flags);
        if (!this.items.containsKey(rootUrl)) {
            this.items.put(rootUrl, new HashSet());
        }
        this.items.get(rootUrl).add(item);
        this.itemsByPath.put(SVNFileUtil.getFilePath(path), item);
        return item;
    }

    public void setLockingContext(ISvnCommitRunner commitRunner, Object context) {
        this.lockingContext = context;
        this.runner = commitRunner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws SVNException {
        try {
            if (this.runner != null) {
                this.runner.disposeCommitPacket(this.lockingContext, this.isLastPacket());
            }
        }
        finally {
            if (this.sharedIndex != null) {
                this.sharedIndex.decrementAndGet();
            }
            if (this.items != null) {
                this.items.clear();
            }
            if (this.itemsByPath != null) {
                this.itemsByPath.clear();
            }
            this.runner = null;
            this.lockingContext = null;
        }
    }

    public void setLockTokens(Map<SVNURL, String> lockTokens) {
        this.lockTokens = lockTokens;
    }

    public Map<SVNURL, String> getLockTokens() {
        return this.lockTokens;
    }

    public boolean isEmpty() {
        for (SVNURL rootUrl : this.getRepositoryRoots()) {
            if (this.isEmpty(rootUrl)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty(SVNURL repositoryRootUrl) {
        for (SvnCommitItem item : this.getItems(repositoryRootUrl)) {
            if (item.getFlags() == 32) continue;
            return false;
        }
        return true;
    }

    public Object getLockingContext() {
        return this.lockingContext;
    }

    public ISvnCommitRunner getRunner() {
        return this.runner;
    }

    public void setItemSkipped(File file, boolean skipped) {
        SvnCommitItem commitItem;
        String path = SVNFileUtil.getFilePath(file);
        if (skipped) {
            this.skippedPaths.add(path);
        } else {
            this.skippedPaths.remove(path);
        }
        if (this.lockingContext != null && this.lockingContext instanceof SVNCommitPacket && !(this.lockingContext instanceof SvnCodec.SVNCommitPacketWrapper) && (commitItem = this.itemsByPath.get(path)) != null) {
            SVNCommitItem[] oldItems;
            SVNCommitPacket oldPacket = (SVNCommitPacket)this.lockingContext;
            for (SVNCommitItem oldItem : oldItems = oldPacket.getCommitItems()) {
                if (!SVNFileUtil.getFilePath(oldItem.getFile()).equals(path)) continue;
                oldPacket.setCommitItemSkipped(oldItem, true);
                break;
            }
        }
    }

    public boolean isItemSkipped(File file) {
        return this.skippedPaths.contains(SVNFileUtil.getFilePath(file));
    }

    public SvnCommitPacket removeSkippedItems() {
        HashMap<String, SvnCommitItem> filteredItemsByPath = new HashMap<String, SvnCommitItem>();
        HashMap<SVNURL, Collection<SvnCommitItem>> filteredItems = new HashMap<SVNURL, Collection<SvnCommitItem>>();
        HashMap<SVNURL, String> filteredLockTokens = new HashMap<SVNURL, String>(this.lockTokens);
        Object filteredLockingContext = this.lockingContext;
        for (Map.Entry<String, SvnCommitItem> entry : this.itemsByPath.entrySet()) {
            String path = entry.getKey();
            SvnCommitItem commitItem = entry.getValue();
            if (this.skippedPaths.contains(path)) continue;
            filteredItemsByPath.put(path, commitItem);
        }
        for (Map.Entry<Object, Object> entry : this.items.entrySet()) {
            SVNURL url = (SVNURL)entry.getKey();
            Collection commitItems = (Collection)entry.getValue();
            ArrayList<SvnCommitItem> filteredCommitItems = new ArrayList<SvnCommitItem>();
            for (SvnCommitItem commitItem : commitItems) {
                String path = SVNFileUtil.getFilePath(commitItem.getPath());
                if (!this.skippedPaths.contains(path)) {
                    filteredCommitItems.add(commitItem);
                    continue;
                }
                this.lockTokens.remove(commitItem.getUrl());
            }
            if (filteredCommitItems.size() <= 0) continue;
            filteredItems.put(url, filteredCommitItems);
        }
        SvnCommitPacket result = new SvnCommitPacket(filteredItems, filteredItemsByPath, filteredLockingContext, filteredLockTokens, this.runner, this.skippedPaths);
        result.sharedIndex = this.sharedIndex;
        return result;
    }

    SvnCommitPacket[] split(boolean combinePackets) throws SVNException {
        HashMap<String, SvnCommitPacket> splitPackets = new HashMap<String, SvnCommitPacket>();
        AtomicInteger sharedIndex = new AtomicInteger(0);
        for (SVNURL root : this.getRepositoryRoots()) {
            Collection<SvnCommitItem> items = this.getItems(root);
            for (SvnCommitItem item : items) {
                if (this.isItemSkipped(item.getPath())) continue;
                String key = this.getItemKey(item, root, combinePackets);
                if (!splitPackets.containsKey(key)) {
                    SvnCommitPacket newPacket = new SvnCommitPacket();
                    newPacket.runner = this.runner;
                    newPacket.sharedIndex = sharedIndex;
                    newPacket.setLockTokens(this.getLockTokens());
                    sharedIndex.incrementAndGet();
                    splitPackets.put(key, newPacket);
                }
                ((SvnCommitPacket)splitPackets.get(key)).addItem(item, root);
            }
        }
        for (SvnCommitPacket splitPacket : splitPackets.values()) {
            splitPacket.lockingContext = this.lockingContext;
        }
        return splitPackets.values().toArray(new SvnCommitPacket[splitPackets.size()]);
    }

    private String getItemKey(SvnCommitItem item, SVNURL rootURL, boolean combinePackets) throws SVNException {
        if (combinePackets) {
            return rootURL.toString();
        }
        File wcRoot = SvnOperationFactory.getWorkingCopyRoot(item.getKind() == SVNNodeKind.FILE ? item.getPath().getParentFile() : item.getPath(), true);
        return rootURL.toString() + ":" + wcRoot.getAbsolutePath();
    }

    public boolean isLastPacket() {
        return this.sharedIndex == null || this.sharedIndex.get() == 1;
    }
}

