/*
 * Decompiled with CFR 0.152.
 */
package annotations.el;

import annotations.el.AElement;
import annotations.el.AMethod;
import annotations.el.ATypeElement;
import annotations.el.ElementVisitor;
import annotations.el.RelativeLocation;
import annotations.util.coll.VivifyingMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class AExpression
extends AElement {
    public final VivifyingMap<RelativeLocation, ATypeElement> typecasts = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<RelativeLocation, ATypeElement> instanceofs = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<RelativeLocation, ATypeElement> news = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<RelativeLocation, ATypeElement> calls = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<RelativeLocation, ATypeElement> refs = ATypeElement.newVivifyingLHMap_ATE();
    public final VivifyingMap<RelativeLocation, AMethod> funs = new VivifyingMap<RelativeLocation, AMethod>(new LinkedHashMap()){

        @Override
        public AMethod createValueFor(RelativeLocation k) {
            return new AMethod("" + k);
        }

        @Override
        public boolean subPrune(AMethod v) {
            return v.prune();
        }
    };
    protected Object id;

    AExpression(Object id) {
        super(id);
        this.id = id;
    }

    AExpression(AExpression expr) {
        super(expr);
        this.copyMapContents(expr.typecasts, this.typecasts);
        this.copyMapContents(expr.instanceofs, this.instanceofs);
        this.copyMapContents(expr.news, this.news);
        this.copyMapContents(expr.calls, this.calls);
        this.copyMapContents(expr.refs, this.refs);
        this.copyMapContents(expr.funs, this.funs);
        this.id = expr.id;
    }

    @Override
    public AExpression clone() {
        return new AExpression(this);
    }

    @Override
    public boolean equals(AElement o) {
        return o instanceof AExpression && ((AExpression)o).equalsExpression(this);
    }

    protected boolean equalsExpression(AExpression o) {
        return super.equals(o) && this.typecasts.equals(o.typecasts) && this.instanceofs.equals(o.instanceofs) && this.news.equals(o.news) && this.refs.equals(o.refs) && this.calls.equals(o.calls) && this.funs.equals(o.funs);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.typecasts.hashCode() + this.instanceofs.hashCode() + this.news.hashCode() + this.refs.hashCode() + this.calls.hashCode() + this.funs.hashCode();
    }

    @Override
    public boolean prune() {
        return super.prune() & this.typecasts.prune() & this.instanceofs.prune() & this.news.prune() & this.refs.prune() & this.calls.prune() & this.funs.prune();
    }

    @Override
    public String toString() {
        boolean isOffset;
        AElement ae;
        RelativeLocation loc;
        StringBuilder sb = new StringBuilder();
        TreeMap<RelativeLocation, ATypeElement> map = new TreeMap<RelativeLocation, ATypeElement>();
        RelativeLocation prev = null;
        for (Map.Entry em : this.typecasts.entrySet()) {
            sb.append("typecast: ");
            loc = (RelativeLocation)em.getKey();
            sb.append(loc);
            sb.append(": ");
            ae = (AElement)em.getValue();
            sb.append(ae.toString());
            sb.append(' ');
        }
        for (Map.Entry em : this.instanceofs.entrySet()) {
            sb.append("instanceof: ");
            loc = (RelativeLocation)em.getKey();
            sb.append(loc);
            sb.append(": ");
            ae = (AElement)em.getValue();
            sb.append(ae.toString());
            sb.append(' ');
        }
        for (Map.Entry em : this.news.entrySet()) {
            sb.append("new ");
            loc = (RelativeLocation)em.getKey();
            sb.append(loc);
            sb.append(": ");
            ae = (AElement)em.getValue();
            sb.append(ae.toString());
            sb.append(' ');
        }
        map.putAll(this.refs);
        for (Map.Entry em : map.entrySet()) {
            loc = (RelativeLocation)em.getKey();
            ae = (AElement)em.getValue();
            boolean bl = isOffset = loc.index < 0;
            if (prev == null || (isOffset ? loc.offset == prev.offset : loc.index == prev.index)) {
                sb.append("reference ");
                sb.append(isOffset ? "*" + loc.offset : "#" + loc.index);
                sb.append(": ");
                sb.append(ae.toString());
            }
            if (loc.type_index >= 0) {
                sb.append("typearg " + loc);
                sb.append(": ");
                sb.append(ae.toString());
                sb.append(' ');
            }
            prev = loc;
        }
        prev = null;
        map.clear();
        map.putAll(this.calls);
        for (Map.Entry em : map.entrySet()) {
            loc = (RelativeLocation)em.getKey();
            ae = (AElement)em.getValue();
            boolean bl = isOffset = loc.index < 0;
            if (prev == null || (isOffset ? loc.offset == prev.offset : loc.index == prev.index)) {
                sb.append("call ");
                sb.append(isOffset ? "*" + loc.offset : "#" + loc.index);
                sb.append(": ");
            }
            if (loc.type_index >= 0) {
                sb.append("typearg " + loc);
                sb.append(": ");
                sb.append(ae.toString());
                sb.append(' ');
            }
            prev = loc;
        }
        prev = null;
        map.clear();
        for (Map.Entry em : this.funs.entrySet()) {
            sb.append("lambda ");
            loc = (RelativeLocation)em.getKey();
            sb.append(loc);
            sb.append(": ");
            ae = (AElement)em.getValue();
            sb.append(ae.toString());
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public <R, T> R accept(ElementVisitor<R, T> v, T t) {
        return v.visitExpression(this, t);
    }
}

