/*
 * Decompiled with CFR 0.152.
 */
package annotations.util;

import annotations.el.ABlock;
import annotations.el.AClass;
import annotations.el.ADeclaration;
import annotations.el.AElement;
import annotations.el.AExpression;
import annotations.el.AField;
import annotations.el.AMethod;
import annotations.el.AScene;
import annotations.el.ATypeElement;
import annotations.el.ATypeElementWithType;
import annotations.el.AnnotationDef;
import annotations.el.ElementVisitor;
import annotations.util.coll.VivifyingMap;
import com.sun.tools.javac.util.Pair;
import java.util.Map;
import java.util.Set;

class DiffVisitor
implements ElementVisitor<Void, Pair<AElement, AElement>> {
    DiffVisitor() {
    }

    public static AScene diff(AScene s1, AScene s2) {
        AScene difference = new AScene();
        new DiffVisitor().visitScene(s1, s2, difference);
        difference.prune();
        return difference;
    }

    public void visitScene(AScene minuend, AScene subtrahend, AScene difference) {
        this.visitElements(minuend.packages, subtrahend.packages, difference.packages);
        DiffVisitor.diff(minuend.imports, subtrahend.imports, difference.imports);
        this.visitElements(minuend.classes, subtrahend.classes, difference.classes);
    }

    @Override
    public Void visitAnnotationDef(AnnotationDef minuend, Pair<AElement, AElement> arg) {
        throw new IllegalStateException("BUG: DiffVisitor.visitAnnotationDef invoked");
    }

    @Override
    public Void visitBlock(ABlock minuend, Pair<AElement, AElement> arg) {
        ABlock subtrahend = (ABlock)arg.fst;
        ABlock difference = (ABlock)arg.snd;
        this.visitElements(minuend.locals, subtrahend.locals, difference.locals);
        return this.visitExpression((AExpression)minuend, arg);
    }

    @Override
    public Void visitClass(AClass minuend, Pair<AElement, AElement> arg) {
        AClass subtrahend = (AClass)arg.fst;
        AClass difference = (AClass)arg.snd;
        this.visitElements(minuend.bounds, subtrahend.bounds, difference.bounds);
        this.visitElements(minuend.extendsImplements, subtrahend.extendsImplements, difference.extendsImplements);
        this.visitElements(minuend.methods, subtrahend.methods, difference.methods);
        this.visitElements(minuend.staticInits, subtrahend.staticInits, difference.staticInits);
        this.visitElements(minuend.instanceInits, subtrahend.instanceInits, difference.instanceInits);
        this.visitElements(minuend.fields, subtrahend.fields, difference.fields);
        this.visitElements(minuend.fieldInits, subtrahend.fieldInits, difference.fieldInits);
        return this.visitDeclaration((ADeclaration)minuend, arg);
    }

    @Override
    public Void visitDeclaration(ADeclaration minuend, Pair<AElement, AElement> arg) {
        ADeclaration subtrahend = (ADeclaration)arg.fst;
        ADeclaration difference = (ADeclaration)arg.snd;
        this.visitElements(minuend.insertAnnotations, subtrahend.insertAnnotations, difference.insertAnnotations);
        this.visitElements(minuend.insertTypecasts, subtrahend.insertTypecasts, difference.insertTypecasts);
        return this.visitElement((AElement)minuend, arg);
    }

    @Override
    public Void visitExpression(AExpression minuend, Pair<AElement, AElement> arg) {
        AExpression subtrahend = (AExpression)arg.fst;
        AExpression difference = (AExpression)arg.snd;
        this.visitElements(minuend.typecasts, subtrahend.typecasts, difference.typecasts);
        this.visitElements(minuend.instanceofs, subtrahend.instanceofs, difference.instanceofs);
        this.visitElements(minuend.news, subtrahend.news, difference.news);
        this.visitElements(minuend.calls, subtrahend.calls, difference.calls);
        this.visitElements(minuend.refs, subtrahend.refs, difference.refs);
        this.visitElements(minuend.funs, subtrahend.funs, difference.funs);
        return this.visitElement((AElement)minuend, arg);
    }

    @Override
    public Void visitField(AField minuend, Pair<AElement, AElement> arg) {
        return this.visitDeclaration((ADeclaration)minuend, arg);
    }

    @Override
    public Void visitMethod(AMethod minuend, Pair<AElement, AElement> arg) {
        AMethod subtrahend = (AMethod)arg.fst;
        AMethod difference = (AMethod)arg.snd;
        this.visitElements(minuend.bounds, subtrahend.bounds, difference.bounds);
        this.visitElements(minuend.parameters, subtrahend.parameters, difference.parameters);
        this.visitElements(minuend.throwsException, subtrahend.throwsException, difference.throwsException);
        this.visitElements(minuend.parameters, subtrahend.parameters, difference.parameters);
        this.visitBlock(minuend.body, this.elemPair(subtrahend.body, difference.body));
        if (minuend.returnType != null) {
            minuend.returnType.accept(this, this.elemPair(subtrahend.returnType, difference.returnType));
        }
        if (minuend.receiver != null) {
            minuend.receiver.accept(this, this.elemPair(subtrahend.receiver, difference.receiver));
        }
        return this.visitDeclaration((ADeclaration)minuend, arg);
    }

    @Override
    public Void visitTypeElement(ATypeElement minuend, Pair<AElement, AElement> arg) {
        ATypeElement subtrahend = (ATypeElement)arg.fst;
        ATypeElement difference = (ATypeElement)arg.snd;
        this.visitElements(minuend.innerTypes, subtrahend.innerTypes, difference.innerTypes);
        return this.visitElement((AElement)minuend, arg);
    }

    @Override
    public Void visitTypeElementWithType(ATypeElementWithType minuend, Pair<AElement, AElement> arg) {
        return this.visitTypeElement((ATypeElement)minuend, arg);
    }

    @Override
    public Void visitElement(AElement minuend, Pair<AElement, AElement> arg) {
        AElement subtrahend = (AElement)arg.fst;
        AElement difference = (AElement)arg.snd;
        DiffVisitor.diff(minuend.tlAnnotationsHere, subtrahend.tlAnnotationsHere, difference.tlAnnotationsHere);
        if (minuend.type != null) {
            ATypeElement stype = subtrahend.type;
            ATypeElement dtype = difference.type;
            minuend.type.accept(this, this.elemPair(stype, dtype));
        }
        return null;
    }

    private <K, V extends AElement> void visitElements(VivifyingMap<K, V> minuend, VivifyingMap<K, V> subtrahend, VivifyingMap<K, V> difference) {
        if (minuend != null) {
            for (Map.Entry e : minuend.entrySet()) {
                Object key = e.getKey();
                AElement mval = (AElement)e.getValue();
                AElement sval = (AElement)subtrahend.get(key);
                if (sval == null) {
                    difference.put(key, mval);
                    continue;
                }
                mval.accept(this, this.elemPair(sval, (AElement)difference.vivify(key)));
            }
        }
    }

    private static <T> void diff(Set<T> minuend, Set<T> subtrahend, Set<T> difference) {
        if (minuend != null) {
            for (T t : minuend) {
                if (subtrahend.contains(t)) continue;
                difference.add(t);
            }
        }
    }

    private static <K, V> void diff(Map<K, Set<V>> minuend, Map<K, Set<V>> subtrahend, Map<K, Set<V>> difference) {
        if (minuend != null) {
            for (K key : minuend.keySet()) {
                Set<V> mval = minuend.get(key);
                Set<V> sval = subtrahend.get(key);
                if (sval == null) {
                    difference.put(key, mval);
                    continue;
                }
                if (sval.equals(mval)) continue;
                try {
                    Set set = (Set)sval.getClass().newInstance();
                    DiffVisitor.diff(mval, sval, set);
                    if (set.isEmpty()) continue;
                    difference.put(key, set);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }

    private Pair<AElement, AElement> elemPair(AElement stype, AElement dtype) {
        return Pair.of(stype, dtype);
    }
}

