/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.nullness;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.checkerframework.checker.initialization.InitializationTransfer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.KeyForAnnotatedTypeFactory;
import org.checkerframework.checker.nullness.KeyForSubchecker;
import org.checkerframework.checker.nullness.NullnessAnalysis;
import org.checkerframework.checker.nullness.NullnessStore;
import org.checkerframework.checker.nullness.NullnessValue;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.NonRaw;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.cfg.node.ArrayAccessNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.InstanceOfNode;
import org.checkerframework.dataflow.cfg.node.MethodAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NullLiteralNode;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.dataflow.cfg.node.ThrowNode;
import org.checkerframework.framework.flow.CFAbstractStore;
import org.checkerframework.framework.qual.PolyAll;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class NullnessTransfer
extends InitializationTransfer<NullnessValue, NullnessTransfer, NullnessStore> {
    protected final NullnessAnalysis analysis;
    protected final AnnotationMirror NONNULL;
    protected final AnnotationMirror NULLABLE;
    protected final KeyForAnnotatedTypeFactory keyForTypeFactory;

    public NullnessTransfer(NullnessAnalysis analysis) {
        super(analysis);
        this.analysis = analysis;
        this.keyForTypeFactory = (KeyForAnnotatedTypeFactory)((BaseTypeChecker)analysis.getTypeFactory().getContext().getChecker()).getTypeFactoryOfSubchecker(KeyForSubchecker.class);
        this.NONNULL = AnnotationUtils.fromClass(analysis.getTypeFactory().getElementUtils(), NonNull.class);
        this.NULLABLE = AnnotationUtils.fromClass(analysis.getTypeFactory().getElementUtils(), Nullable.class);
    }

    protected void makeNonNull(NullnessStore store, Node node) {
        FlowExpressions.Receiver internalRepr = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), node);
        store.insertValue(internalRepr, this.NONNULL);
    }

    protected void makeNonNull(TransferResult<NullnessValue, NullnessStore> result, Node node) {
        if (result.containsTwoStores()) {
            this.makeNonNull(result.getThenStore(), node);
            this.makeNonNull(result.getElseStore(), node);
        } else {
            this.makeNonNull(result.getRegularStore(), node);
        }
    }

    @Override
    protected NullnessValue finishValue(NullnessValue value, NullnessStore store) {
        if ((value = super.finishValue(value, store)) != null) {
            value.isPolyNullNull = store.isPolyNullNull();
        }
        return value;
    }

    @Override
    protected TransferResult<NullnessValue, NullnessStore> strengthenAnnotationOfEqualTo(TransferResult<NullnessValue, NullnessStore> res, Node firstNode, Node secondNode, NullnessValue firstValue, NullnessValue secondValue, boolean notEqualTo) {
        res = super.strengthenAnnotationOfEqualTo(res, firstNode, secondNode, firstValue, secondValue, notEqualTo);
        if (firstNode instanceof NullLiteralNode) {
            NullnessStore thenStore = res.getThenStore();
            NullnessStore elseStore = res.getElseStore();
            List<Node> secondParts = this.splitAssignments(secondNode);
            for (Node secondPart : secondParts) {
                FlowExpressions.Receiver secondInternal = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), secondPart);
                if (!CFAbstractStore.canInsertReceiver(secondInternal)) continue;
                thenStore = thenStore == null ? res.getThenStore() : thenStore;
                NullnessStore nullnessStore = elseStore = elseStore == null ? res.getElseStore() : elseStore;
                if (notEqualTo) {
                    thenStore.insertValue(secondInternal, this.NONNULL);
                    continue;
                }
                elseStore.insertValue(secondInternal, this.NONNULL);
            }
            if (secondValue != null && (secondValue.getType().hasAnnotation(PolyNull.class) || secondValue.getType().hasAnnotation(PolyAll.class))) {
                thenStore = thenStore == null ? res.getThenStore() : thenStore;
                elseStore = elseStore == null ? res.getElseStore() : elseStore;
                thenStore.setPolyNullNull(true);
            }
            if (thenStore != null) {
                return new ConditionalTransferResult<NullnessValue, NullnessStore>(res.getResultValue(), thenStore, elseStore);
            }
        }
        return res;
    }

    @Override
    public TransferResult<NullnessValue, NullnessStore> visitArrayAccess(ArrayAccessNode n, TransferInput<NullnessValue, NullnessStore> p) {
        TransferResult<NullnessValue, NullnessStore> result = super.visitArrayAccess(n, p);
        this.makeNonNull(result, n.getArray());
        return result;
    }

    @Override
    public TransferResult<NullnessValue, NullnessStore> visitInstanceOf(InstanceOfNode n, TransferInput<NullnessValue, NullnessStore> p) {
        TransferResult result = (TransferResult)super.visitInstanceOf(n, p);
        NullnessStore thenStore = (NullnessStore)result.getThenStore();
        NullnessStore elseStore = (NullnessStore)result.getElseStore();
        this.makeNonNull(thenStore, n.getOperand());
        return new ConditionalTransferResult<NullnessValue, NullnessStore>((NullnessValue)result.getResultValue(), thenStore, elseStore);
    }

    @Override
    public TransferResult<NullnessValue, NullnessStore> visitMethodAccess(MethodAccessNode n, TransferInput<NullnessValue, NullnessStore> p) {
        TransferResult result = (TransferResult)super.visitMethodAccess(n, p);
        this.makeNonNull(result, n.getReceiver());
        return result;
    }

    @Override
    public TransferResult<NullnessValue, NullnessStore> visitFieldAccess(FieldAccessNode n, TransferInput<NullnessValue, NullnessStore> p) {
        TransferResult<NullnessValue, NullnessStore> result = super.visitFieldAccess(n, p);
        this.makeNonNull(result, n.getReceiver());
        return result;
    }

    @Override
    public TransferResult<NullnessValue, NullnessStore> visitThrow(ThrowNode n, TransferInput<NullnessValue, NullnessStore> p) {
        TransferResult result = (TransferResult)super.visitThrow(n, p);
        this.makeNonNull(result, n.getExpression());
        return result;
    }

    @Override
    public TransferResult<NullnessValue, NullnessStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<NullnessValue, NullnessStore> in) {
        TransferResult<NullnessValue, NullnessStore> result = super.visitMethodInvocation(n, in);
        this.makeNonNull(result, n.getTarget().getReceiver());
        MethodInvocationTree tree = n.getTree();
        ExecutableElement method = TreeUtils.elementFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType methodType = this.analysis.getTypeFactory().getAnnotatedType(method);
        List<AnnotatedTypeMirror> methodParams = methodType.getParameterTypes();
        List<? extends ExpressionTree> methodArgs = tree.getArguments();
        for (int i = 0; i < methodParams.size() && i < methodArgs.size(); ++i) {
            if (!methodParams.get(i).hasAnnotation(this.NONNULL)) continue;
            this.makeNonNull(result, n.getArgument(i));
        }
        String methodName = n.getTarget().getMethod().toString();
        if (methodName.startsWith("get(")) {
            Types types = this.analysis.getTypes();
            TypeMirror mapInterfaceTypeMirror = types.erasure(TypesUtils.typeFromClass(types, this.analysis.getEnv().getElementUtils(), Map.class));
            TypeMirror receiverType = types.erasure(n.getTarget().getReceiver().getType());
            if (types.isSubtype(receiverType, mapInterfaceTypeMirror)) {
                Node receiver = n.getTarget().getReceiver();
                FlowExpressions.Receiver internalReceiver = FlowExpressions.internalReprOf(this.analysis.getTypeFactory(), receiver);
                String mapName = internalReceiver.toString();
                AnnotationMirror keyForMapName = this.keyForTypeFactory.createKeyForAnnotationMirrorWithValue(mapName);
                AnnotatedTypeMirror type = this.keyForTypeFactory.getAnnotatedType(methodArgs.get(0));
                if (type != null && this.keyForTypeFactory.keyForValuesSubtypeCheck(keyForMapName, type, tree, n)) {
                    this.makeNonNull(result, (Node)n);
                    NullnessValue oldResultValue = result.getResultValue();
                    NullnessValue refinedResultValue = (NullnessValue)this.analysis.createSingleAnnotationValue(this.NONNULL, oldResultValue.getType().getUnderlyingType());
                    NullnessValue newResultValue = refinedResultValue.mostSpecific(oldResultValue, null);
                    result.setResultValue(newResultValue);
                }
            }
        }
        return result;
    }

    @Override
    public TransferResult<NullnessValue, NullnessStore> visitReturn(ReturnNode n, TransferInput<NullnessValue, NullnessStore> in) {
        NullnessValue value = this.createDummyValue();
        if (in.containsTwoStores()) {
            NullnessStore thenStore = in.getThenStore();
            NullnessStore elseStore = in.getElseStore();
            return new ConditionalTransferResult<NullnessValue, NullnessStore>(this.finishValue(value, thenStore, elseStore), thenStore, elseStore);
        }
        NullnessStore info = in.getRegularStore();
        return new RegularTransferResult<NullnessValue, NullnessStore>(this.finishValue(value, info), info);
    }

    private NullnessValue createDummyValue() {
        PrimitiveType dummy = this.analysis.getEnv().getTypeUtils().getPrimitiveType(TypeKind.BOOLEAN);
        AnnotatedTypeMirror annotatedDummy = AnnotatedTypeMirror.createType(dummy, this.analysis.getTypeFactory(), false);
        annotatedDummy.addAnnotation(NonNull.class);
        annotatedDummy.addAnnotation(NonRaw.class);
        annotatedDummy.addAnnotation(Initialized.class);
        NullnessValue value = new NullnessValue(this.analysis, annotatedDummy);
        return value;
    }
}

