/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import java.util.Collection;
import java.util.Collections;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.util.HashCodeUtils;
import org.checkerframework.javacutil.InternalUtils;

public class ConditionalNotNode
extends Node {
    protected UnaryTree tree;
    protected Node operand;

    public ConditionalNotNode(UnaryTree tree, Node operand) {
        super(InternalUtils.typeOf(tree));
        assert (tree.getKind().equals((Object)Tree.Kind.LOGICAL_COMPLEMENT));
        this.tree = tree;
        this.operand = operand;
    }

    public Node getOperand() {
        return this.operand;
    }

    @Override
    public UnaryTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitConditionalNot(this, p);
    }

    public String toString() {
        return "(!" + this.getOperand() + ")";
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ConditionalNotNode)) {
            return false;
        }
        ConditionalNotNode other = (ConditionalNotNode)obj;
        return this.getOperand().equals(other.getOperand());
    }

    public int hashCode() {
        return HashCodeUtils.hash((Object)this.getOperand());
    }

    @Override
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.getOperand());
    }
}

