/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.type;

import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.type.AnnotatedTypeCopier;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeFormatter;
import org.checkerframework.framework.type.AnnotatedTypeParameterBounds;
import org.checkerframework.framework.type.BoundsInitializer;
import org.checkerframework.framework.type.EqualityAtmComparer;
import org.checkerframework.framework.type.HashcodeAtmVisitor;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.type.SupertypeFinder;
import org.checkerframework.framework.type.visitor.AnnotatedTypeVisitor;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.ErrorReporter;

public abstract class AnnotatedTypeMirror {
    protected static final EqualityAtmComparer equalityComparer = new EqualityAtmComparer();
    protected static final HashcodeAtmVisitor hashcodeVisitor = new HashcodeAtmVisitor();
    protected final AnnotatedTypeFactory atypeFactory;
    protected final TypeMirror actualType;
    protected final AnnotatedTypeFormatter formatter;
    private final Set<AnnotationMirror> annotations = AnnotationUtils.createAnnotationSet();

    public static AnnotatedTypeMirror createType(TypeMirror type, AnnotatedTypeFactory atypeFactory, boolean isDeclaration) {
        AnnotatedTypeMirror result;
        if (type == null) {
            ErrorReporter.errorAbort("AnnotatedTypeMirror.createType: input type must not be null!");
            return null;
        }
        switch (type.getKind()) {
            case ARRAY: {
                result = new AnnotatedArrayType((ArrayType)type, atypeFactory);
                break;
            }
            case DECLARED: {
                result = new AnnotatedDeclaredType((DeclaredType)type, atypeFactory, isDeclaration);
                break;
            }
            case ERROR: {
                ErrorReporter.errorAbort("AnnotatedTypeMirror.createType: input should type-check already! Found error type: " + type);
                return null;
            }
            case EXECUTABLE: {
                result = new AnnotatedExecutableType((ExecutableType)type, atypeFactory);
                break;
            }
            case VOID: 
            case PACKAGE: 
            case NONE: {
                result = new AnnotatedNoType((NoType)type, atypeFactory);
                break;
            }
            case NULL: {
                result = new AnnotatedNullType((NullType)type, atypeFactory);
                break;
            }
            case TYPEVAR: {
                result = new AnnotatedTypeVariable((TypeVariable)type, atypeFactory, isDeclaration);
                break;
            }
            case WILDCARD: {
                result = new AnnotatedWildcardType((WildcardType)type, atypeFactory);
                break;
            }
            case INTERSECTION: {
                result = new AnnotatedIntersectionType((IntersectionType)type, atypeFactory);
                break;
            }
            case UNION: {
                result = new AnnotatedUnionType((UnionType)type, atypeFactory);
                break;
            }
            default: {
                if (type.getKind().isPrimitive()) {
                    result = new AnnotatedPrimitiveType((PrimitiveType)type, atypeFactory);
                    break;
                }
                ErrorReporter.errorAbort("AnnotatedTypeMirror.createType: unidentified type " + type + " (" + (Object)((Object)type.getKind()) + ")");
                return null;
            }
        }
        return result;
    }

    private AnnotatedTypeMirror(TypeMirror type, AnnotatedTypeFactory atypeFactory) {
        this.actualType = type;
        assert (atypeFactory != null);
        this.atypeFactory = atypeFactory;
        this.formatter = atypeFactory.typeFormatter;
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof AnnotatedTypeMirror)) {
            return false;
        }
        return (Boolean)equalityComparer.visit(this, (AnnotatedTypeMirror)o, null);
    }

    @Pure
    public final int hashCode() {
        return (Integer)hashcodeVisitor.visit(this);
    }

    public abstract <R, P> R accept(AnnotatedTypeVisitor<R, P> var1, P var2);

    public TypeKind getKind() {
        return this.actualType.getKind();
    }

    public TypeMirror getUnderlyingType() {
        return this.actualType;
    }

    public boolean isDeclaration() {
        return false;
    }

    public AnnotatedTypeMirror asUse() {
        return this;
    }

    public boolean isAnnotatedInHierarchy(AnnotationMirror p) {
        return this.getAnnotationInHierarchy(p) != null;
    }

    public AnnotationMirror getAnnotationInHierarchy(AnnotationMirror p) {
        QualifierHierarchy qualHier;
        AnnotationMirror anno;
        AnnotationMirror aliased = p;
        if (!this.atypeFactory.isSupportedQualifier(aliased)) {
            aliased = this.atypeFactory.aliasedAnnotation(p);
        }
        if (this.atypeFactory.isSupportedQualifier(aliased) && (anno = (qualHier = this.atypeFactory.getQualifierHierarchy()).findCorrespondingAnnotation(aliased, this.annotations)) != null) {
            return anno;
        }
        return null;
    }

    public AnnotationMirror getEffectiveAnnotationInHierarchy(AnnotationMirror p) {
        QualifierHierarchy qualHier;
        AnnotationMirror anno;
        AnnotationMirror aliased = p;
        if (!this.atypeFactory.isSupportedQualifier(aliased)) {
            aliased = this.atypeFactory.aliasedAnnotation(p);
        }
        if (this.atypeFactory.isSupportedQualifier(aliased) && (anno = (qualHier = this.atypeFactory.getQualifierHierarchy()).findCorrespondingAnnotation(aliased, this.getEffectiveAnnotations())) != null) {
            return anno;
        }
        return null;
    }

    public final Set<AnnotationMirror> getAnnotations() {
        return Collections.unmodifiableSet(this.annotations);
    }

    protected final Set<AnnotationMirror> getAnnotationsField() {
        return this.annotations;
    }

    public Set<AnnotationMirror> getEffectiveAnnotations() {
        Set<AnnotationMirror> effectiveAnnotations = this.getErased().getAnnotations();
        return effectiveAnnotations;
    }

    public AnnotationMirror getAnnotation(Name annotationName) {
        assert (annotationName != null) : "Null annotationName in getAnnotation";
        return this.getAnnotation(annotationName.toString().intern());
    }

    public AnnotationMirror getAnnotation(@Interned String annotationStr) {
        assert (annotationStr != null) : "Null annotationName in getAnnotation";
        for (AnnotationMirror anno : this.getAnnotations()) {
            if (!AnnotationUtils.areSameByName(anno, annotationStr)) continue;
            return anno;
        }
        return null;
    }

    public AnnotationMirror getAnnotation(Class<? extends Annotation> annoClass) {
        for (AnnotationMirror annoMirror : this.getAnnotations()) {
            if (!AnnotationUtils.areSameByClass(annoMirror, annoClass)) continue;
            return annoMirror;
        }
        return null;
    }

    public Set<AnnotationMirror> getExplicitAnnotations() {
        Set<AnnotationMirror> explicitAnnotations = AnnotationUtils.createAnnotationSet();
        List<? extends AnnotationMirror> typeAnnotations = this.getUnderlyingType().getAnnotationMirrors();
        Set<? extends AnnotationMirror> validAnnotations = this.atypeFactory.getQualifierHierarchy().getTypeQualifiers();
        for (AnnotationMirror annotationMirror : typeAnnotations) {
            for (AnnotationMirror annotationMirror2 : validAnnotations) {
                if (!AnnotationUtils.areSameIgnoringValues(annotationMirror, annotationMirror2)) continue;
                explicitAnnotations.add(annotationMirror);
            }
        }
        return explicitAnnotations;
    }

    public boolean hasAnnotation(AnnotationMirror a) {
        return AnnotationUtils.containsSame(this.getAnnotations(), a);
    }

    public boolean hasAnnotation(Name a) {
        return this.getAnnotation(a) != null;
    }

    public boolean hasAnnotation(Class<? extends Annotation> a) {
        return this.getAnnotation(a) != null;
    }

    public AnnotationMirror getEffectiveAnnotation(Class<? extends Annotation> annoClass) {
        for (AnnotationMirror annoMirror : this.getEffectiveAnnotations()) {
            if (!AnnotationUtils.areSameByClass(annoMirror, annoClass)) continue;
            return annoMirror;
        }
        return null;
    }

    public boolean hasEffectiveAnnotation(Class<? extends Annotation> a) {
        return this.getEffectiveAnnotation(a) != null;
    }

    public boolean hasEffectiveAnnotation(AnnotationMirror a) {
        return AnnotationUtils.containsSame(this.getEffectiveAnnotations(), a);
    }

    public boolean hasExplicitAnnotation(AnnotationMirror a) {
        return AnnotationUtils.containsSame(this.getExplicitAnnotations(), a);
    }

    public boolean hasAnnotationRelaxed(AnnotationMirror a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getAnnotations(), a);
    }

    public boolean hasEffectiveAnnotationRelaxed(AnnotationMirror a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getEffectiveAnnotations(), a);
    }

    public boolean hasExplicitAnnotationRelaxed(AnnotationMirror a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getExplicitAnnotations(), a);
    }

    public boolean hasExplicitAnnotation(Class<? extends Annotation> a) {
        return AnnotationUtils.containsSameIgnoringValues(this.getExplicitAnnotations(), this.getAnnotation(a));
    }

    public void addAnnotation(AnnotationMirror a) {
        if (a == null) {
            ErrorReporter.errorAbort("AnnotatedTypeMirror.addAnnotation: null is not a valid annotation.");
        }
        if (this.atypeFactory.isSupportedQualifier(a)) {
            this.annotations.add(a);
        } else {
            AnnotationMirror aliased = this.atypeFactory.aliasedAnnotation(a);
            if (this.atypeFactory.isSupportedQualifier(aliased)) {
                this.addAnnotation(aliased);
            }
        }
    }

    public void replaceAnnotation(AnnotationMirror a) {
        this.removeAnnotationInHierarchy(a);
        this.addAnnotation(a);
    }

    public void addAnnotation(Class<? extends Annotation> a) {
        AnnotationMirror anno = AnnotationUtils.fromClass(this.atypeFactory.elements, a);
        this.addAnnotation(anno);
    }

    public void addAnnotations(Iterable<? extends AnnotationMirror> annotations) {
        for (AnnotationMirror annotationMirror : annotations) {
            this.addAnnotation(annotationMirror);
        }
    }

    public void addMissingAnnotations(Iterable<? extends AnnotationMirror> annotations) {
        for (AnnotationMirror annotationMirror : annotations) {
            if (this.isAnnotatedInHierarchy(annotationMirror)) continue;
            this.addAnnotation(annotationMirror);
        }
    }

    public void replaceAnnotations(Iterable<? extends AnnotationMirror> replAnnos) {
        for (AnnotationMirror annotationMirror : replAnnos) {
            this.removeAnnotationInHierarchy(annotationMirror);
            this.addAnnotation(annotationMirror);
        }
    }

    public boolean removeAnnotation(AnnotationMirror a) {
        AnnotationMirror anno = this.getAnnotation(AnnotationUtils.annotationName(a));
        if (anno != null) {
            return this.annotations.remove(anno);
        }
        return false;
    }

    public boolean removeAnnotation(Class<? extends Annotation> a) {
        AnnotationMirror anno = AnnotationUtils.fromClass(this.atypeFactory.elements, a);
        if (anno == null || !this.atypeFactory.isSupportedQualifier(anno)) {
            ErrorReporter.errorAbort("AnnotatedTypeMirror.removeAnnotation called with un-supported class: " + a);
        }
        return this.removeAnnotation(anno);
    }

    public boolean removeAnnotationInHierarchy(AnnotationMirror a) {
        AnnotationMirror prev = this.getAnnotationInHierarchy(a);
        if (prev != null) {
            return this.removeAnnotation(prev);
        }
        return false;
    }

    public boolean removeNonTopAnnotationInHierarchy(AnnotationMirror a) {
        AnnotationMirror prev = this.getAnnotationInHierarchy(a);
        QualifierHierarchy qualHier = this.atypeFactory.getQualifierHierarchy();
        if (prev != null && !prev.equals(qualHier.getTopAnnotation(a))) {
            return this.removeAnnotation(prev);
        }
        return false;
    }

    public boolean removeAnnotations(Iterable<? extends AnnotationMirror> annotations) {
        boolean changed = false;
        for (AnnotationMirror annotationMirror : annotations) {
            changed |= this.removeAnnotation(annotationMirror);
        }
        return changed;
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    @SideEffectFree
    public final String toString() {
        return this.formatter.format(this);
    }

    @SideEffectFree
    public final String toString(boolean verbose) {
        return this.formatter.format(this, verbose);
    }

    public AnnotatedTypeMirror getErased() {
        return this.deepCopy();
    }

    public abstract AnnotatedTypeMirror deepCopy(boolean var1);

    public abstract AnnotatedTypeMirror deepCopy();

    public abstract AnnotatedTypeMirror shallowCopy(boolean var1);

    public abstract AnnotatedTypeMirror shallowCopy();

    protected static AnnotatedDeclaredType createTypeOfObject(AnnotatedTypeFactory atypeFactory) {
        AnnotatedDeclaredType objectType = atypeFactory.fromElement(atypeFactory.elements.getTypeElement(Object.class.getCanonicalName()));
        objectType.declaration = false;
        return objectType;
    }

    public List<? extends AnnotatedTypeMirror> directSuperTypes() {
        return SupertypeFinder.directSuperTypes(this);
    }

    public static class AnnotatedUnionType
    extends AnnotatedTypeMirror {
        protected List<AnnotatedDeclaredType> alternatives;

        private AnnotatedUnionType(UnionType type, AnnotatedTypeFactory atypeFactory) {
            super(type, atypeFactory);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitUnion(this, p);
        }

        @Override
        public AnnotatedUnionType deepCopy(boolean copyAnnotations) {
            return (AnnotatedUnionType)new AnnotatedTypeCopier(copyAnnotations).visit(this);
        }

        @Override
        public AnnotatedUnionType deepCopy() {
            return this.deepCopy(true);
        }

        @Override
        public AnnotatedUnionType shallowCopy(boolean copyAnnotations) {
            AnnotatedUnionType type = new AnnotatedUnionType((UnionType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type.addAnnotations(this.getAnnotationsField());
            }
            type.alternatives = this.alternatives;
            return type;
        }

        @Override
        public AnnotatedUnionType shallowCopy() {
            return this.shallowCopy(true);
        }

        public List<AnnotatedDeclaredType> getAlternatives() {
            if (this.alternatives == null) {
                List<? extends TypeMirror> ualts = ((UnionType)this.actualType).getAlternatives();
                ArrayList<AnnotatedDeclaredType> res = new ArrayList<AnnotatedDeclaredType>(ualts.size());
                for (TypeMirror typeMirror : ualts) {
                    res.add((AnnotatedDeclaredType)AnnotatedUnionType.createType(typeMirror, this.atypeFactory, false));
                }
                this.alternatives = Collections.unmodifiableList(res);
            }
            return this.alternatives;
        }
    }

    public static class AnnotatedIntersectionType
    extends AnnotatedTypeMirror {
        protected List<AnnotatedDeclaredType> supertypes;

        private AnnotatedIntersectionType(IntersectionType type, AnnotatedTypeFactory atypeFactory) {
            super(type, atypeFactory);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitIntersection(this, p);
        }

        @Override
        public AnnotatedIntersectionType deepCopy(boolean copyAnnotations) {
            return (AnnotatedIntersectionType)new AnnotatedTypeCopier(copyAnnotations).visit(this);
        }

        @Override
        public AnnotatedIntersectionType deepCopy() {
            return this.deepCopy(true);
        }

        @Override
        public AnnotatedIntersectionType shallowCopy(boolean copyAnnotations) {
            AnnotatedIntersectionType type = new AnnotatedIntersectionType((IntersectionType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type.addAnnotations(this.getAnnotationsField());
            }
            type.supertypes = this.supertypes;
            return type;
        }

        @Override
        public AnnotatedIntersectionType shallowCopy() {
            return this.shallowCopy(true);
        }

        public List<AnnotatedDeclaredType> directSuperTypes() {
            if (this.supertypes == null) {
                List<? extends TypeMirror> ubounds = ((IntersectionType)this.actualType).getBounds();
                ArrayList<AnnotatedDeclaredType> res = new ArrayList<AnnotatedDeclaredType>(ubounds.size());
                for (TypeMirror typeMirror : ubounds) {
                    res.add((AnnotatedDeclaredType)AnnotatedIntersectionType.createType(typeMirror, this.atypeFactory, false));
                }
                this.supertypes = Collections.unmodifiableList(res);
            }
            return this.supertypes;
        }

        public List<AnnotatedDeclaredType> directSuperTypesField() {
            return this.supertypes;
        }

        void setDirectSuperTypes(List<AnnotatedDeclaredType> supertypes) {
            this.supertypes = new ArrayList<AnnotatedDeclaredType>(supertypes);
        }
    }

    public static class AnnotatedWildcardType
    extends AnnotatedTypeMirror {
        private AnnotatedTypeMirror superBound;
        private AnnotatedTypeMirror extendsBound;
        private boolean typeArgHack = false;

        private AnnotatedWildcardType(WildcardType type, AnnotatedTypeFactory factory) {
            super(type, factory);
        }

        @Override
        public void addAnnotation(AnnotationMirror a) {
            super.addAnnotation(a);
            this.fixupBoundAnnotations();
        }

        void setSuperBound(AnnotatedTypeMirror type) {
            if (type != null) {
                type = type.asUse();
            }
            this.superBound = type;
            if (this.superBound != null) {
                this.fixupBoundAnnotations();
            }
        }

        public AnnotatedTypeMirror getSuperBoundField() {
            return this.superBound;
        }

        public AnnotatedTypeMirror getSuperBound() {
            if (this.superBound == null) {
                BoundsInitializer.initializeSuperBound(this);
                this.fixupBoundAnnotations();
            }
            return this.superBound;
        }

        void setExtendsBound(AnnotatedTypeMirror type) {
            if (type != null) {
                type = type.asUse();
            }
            this.extendsBound = type;
            if (this.extendsBound != null) {
                this.fixupBoundAnnotations();
            }
        }

        public AnnotatedTypeMirror getExtendsBoundField() {
            return this.extendsBound;
        }

        public AnnotatedTypeMirror getExtendsBound() {
            if (this.extendsBound == null) {
                BoundsInitializer.initializeExtendsBound(this);
                this.fixupBoundAnnotations();
            }
            return this.extendsBound;
        }

        private void fixupBoundAnnotations() {
            if (!this.getAnnotationsField().isEmpty()) {
                if (this.superBound != null) {
                    this.superBound.replaceAnnotations(this.getAnnotationsField());
                }
                if (this.extendsBound != null) {
                    this.extendsBound.replaceAnnotations(this.getAnnotationsField());
                }
            }
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitWildcard(this, p);
        }

        @Override
        public WildcardType getUnderlyingType() {
            return (WildcardType)this.actualType;
        }

        @Override
        public AnnotatedWildcardType deepCopy(boolean copyAnnotations) {
            return (AnnotatedWildcardType)new AnnotatedTypeCopier(copyAnnotations).visit(this);
        }

        @Override
        public AnnotatedWildcardType deepCopy() {
            return this.deepCopy(true);
        }

        @Override
        public AnnotatedWildcardType shallowCopy(boolean copyAnnotations) {
            AnnotatedWildcardType type = new AnnotatedWildcardType((WildcardType)this.actualType, this.atypeFactory);
            type.setExtendsBound(this.getExtendsBound().shallowCopy());
            type.setSuperBound(this.getSuperBound().shallowCopy());
            if (copyAnnotations) {
                type.addAnnotations(this.getAnnotationsField());
            }
            type.typeArgHack = this.typeArgHack;
            return type;
        }

        @Override
        public AnnotatedWildcardType shallowCopy() {
            return this.shallowCopy(true);
        }

        @Override
        public AnnotatedTypeMirror getErased() {
            return this.getExtendsBound().getErased();
        }

        void setTypeArgHack() {
            this.typeArgHack = true;
        }

        boolean isTypeArgHack() {
            return this.typeArgHack;
        }
    }

    public static class AnnotatedPrimitiveType
    extends AnnotatedTypeMirror {
        private AnnotatedPrimitiveType(PrimitiveType type, AnnotatedTypeFactory factory) {
            super(type, factory);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitPrimitive(this, p);
        }

        @Override
        public PrimitiveType getUnderlyingType() {
            return (PrimitiveType)this.actualType;
        }

        @Override
        public AnnotatedPrimitiveType deepCopy(boolean copyAnnotations) {
            return (AnnotatedPrimitiveType)new AnnotatedTypeCopier(copyAnnotations).visit(this);
        }

        @Override
        public AnnotatedPrimitiveType deepCopy() {
            return this.deepCopy(true);
        }

        @Override
        public AnnotatedPrimitiveType shallowCopy(boolean copyAnnotations) {
            AnnotatedPrimitiveType type = new AnnotatedPrimitiveType((PrimitiveType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type.addAnnotations(this.getAnnotationsField());
            }
            return type;
        }

        @Override
        public AnnotatedPrimitiveType shallowCopy() {
            return this.shallowCopy(true);
        }
    }

    public static class AnnotatedNullType
    extends AnnotatedTypeMirror {
        private AnnotatedNullType(NullType type, AnnotatedTypeFactory factory) {
            super(type, factory);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitNull(this, p);
        }

        @Override
        public NullType getUnderlyingType() {
            return (NullType)this.actualType;
        }

        @Override
        public AnnotatedNullType deepCopy(boolean copyAnnotations) {
            return (AnnotatedNullType)new AnnotatedTypeCopier(copyAnnotations).visit(this);
        }

        @Override
        public AnnotatedNullType deepCopy() {
            return this.deepCopy(true);
        }

        @Override
        public AnnotatedNullType shallowCopy(boolean copyAnnotations) {
            AnnotatedNullType type = new AnnotatedNullType((NullType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type.addAnnotations(this.getAnnotationsField());
            }
            return type;
        }

        @Override
        public AnnotatedNullType shallowCopy() {
            return this.shallowCopy(true);
        }
    }

    public static class AnnotatedNoType
    extends AnnotatedTypeMirror {
        private AnnotatedNoType(NoType type, AnnotatedTypeFactory factory) {
            super(type, factory);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitNoType(this, p);
        }

        @Override
        public NoType getUnderlyingType() {
            return (NoType)this.actualType;
        }

        @Override
        public AnnotatedNoType deepCopy(boolean copyAnnotations) {
            return (AnnotatedNoType)new AnnotatedTypeCopier(copyAnnotations).visit(this);
        }

        @Override
        public AnnotatedNoType deepCopy() {
            return this.deepCopy(true);
        }

        @Override
        public AnnotatedNoType shallowCopy(boolean copyAnnotations) {
            AnnotatedNoType type = new AnnotatedNoType((NoType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type.addAnnotations(this.getAnnotationsField());
            }
            return type;
        }

        @Override
        public AnnotatedNoType shallowCopy() {
            return this.shallowCopy(true);
        }
    }

    public static class AnnotatedTypeVariable
    extends AnnotatedTypeMirror {
        private AnnotatedTypeMirror lowerBound;
        private AnnotatedTypeMirror upperBound;
        private boolean declaration;
        private boolean inUpperBounds = false;

        private AnnotatedTypeVariable(TypeVariable type, AnnotatedTypeFactory atypeFactory, boolean declaration) {
            super(type, atypeFactory);
            this.declaration = declaration;
        }

        @Override
        public boolean isDeclaration() {
            return this.declaration;
        }

        @Override
        public void addAnnotation(AnnotationMirror a) {
            super.addAnnotation(a);
            this.fixupBoundAnnotations();
        }

        public void setDeclaration(boolean declaration) {
            this.declaration = declaration;
        }

        @Override
        public AnnotatedTypeVariable asUse() {
            if (!this.isDeclaration()) {
                return this;
            }
            AnnotatedTypeVariable result = this.shallowCopy();
            result.declaration = false;
            return result;
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitTypeVariable(this, p);
        }

        @Override
        public TypeVariable getUnderlyingType() {
            return (TypeVariable)this.actualType;
        }

        void setLowerBound(AnnotatedTypeMirror type) {
            if (type != null) {
                type = type.asUse();
            }
            this.lowerBound = type;
        }

        void setLowerBoundField(AnnotatedTypeMirror type) {
            this.lowerBound = type;
            if (this.lowerBound != null) {
                this.fixupBoundAnnotations();
            }
        }

        public AnnotatedTypeMirror getLowerBoundField() {
            return this.lowerBound;
        }

        public AnnotatedTypeMirror getLowerBound() {
            if (this.lowerBound == null) {
                BoundsInitializer.initializeBounds(this);
                this.fixupBoundAnnotations();
            }
            return this.lowerBound;
        }

        private void fixupBoundAnnotations() {
            if (!this.getAnnotationsField().isEmpty()) {
                if (this.upperBound != null) {
                    this.replaceUpperBoundAnnotations();
                }
                if (this.lowerBound != null) {
                    this.lowerBound.replaceAnnotations(this.getAnnotationsField());
                }
            }
        }

        private void replaceUpperBoundAnnotations() {
            if (this.upperBound.getKind() == TypeKind.INTERSECTION) {
                List<AnnotatedDeclaredType> bounds = ((AnnotatedIntersectionType)this.upperBound).directSuperTypes();
                for (AnnotatedDeclaredType bound : bounds) {
                    bound.replaceAnnotations(this.getAnnotationsField());
                }
            } else {
                this.upperBound.replaceAnnotations(this.getAnnotationsField());
            }
        }

        void setUpperBound(AnnotatedTypeMirror type) {
            if (type.isDeclaration()) {
                ErrorReporter.errorAbort("Upper bounds should never contain declarations.\ntype=" + type);
            }
            this.upperBound = type;
        }

        void setUpperBoundField(AnnotatedTypeMirror type) {
            this.upperBound = type;
            if (this.upperBound != null) {
                this.fixupBoundAnnotations();
            }
        }

        public AnnotatedTypeMirror getUpperBoundField() {
            return this.upperBound;
        }

        public AnnotatedTypeMirror getUpperBound() {
            if (this.upperBound == null) {
                BoundsInitializer.initializeBounds(this);
                this.fixupBoundAnnotations();
            }
            return this.upperBound;
        }

        public AnnotatedTypeParameterBounds getBounds() {
            return new AnnotatedTypeParameterBounds(this.getUpperBound(), this.getLowerBound());
        }

        public AnnotatedTypeParameterBounds getBoundFields() {
            return new AnnotatedTypeParameterBounds(this.getUpperBoundField(), this.getLowerBoundField());
        }

        @Override
        public AnnotatedTypeVariable deepCopy(boolean copyAnnotations) {
            return (AnnotatedTypeVariable)new AnnotatedTypeCopier(copyAnnotations).visit(this);
        }

        @Override
        public AnnotatedTypeVariable deepCopy() {
            return this.deepCopy(true);
        }

        @Override
        public AnnotatedTypeVariable shallowCopy(boolean copyAnnotations) {
            AnnotatedTypeVariable type = new AnnotatedTypeVariable((TypeVariable)this.actualType, this.atypeFactory, this.declaration);
            if (copyAnnotations) {
                type.addAnnotations(this.getAnnotationsField());
            }
            if (!this.inUpperBounds) {
                this.inUpperBounds = true;
                type.inUpperBounds = true;
                type.setUpperBound(this.getUpperBound().shallowCopy());
                this.inUpperBounds = false;
                type.inUpperBounds = false;
            }
            type.setLowerBound(this.getLowerBound().shallowCopy());
            return type;
        }

        @Override
        public AnnotatedTypeVariable shallowCopy() {
            return this.shallowCopy(true);
        }

        @Override
        public AnnotatedTypeMirror getErased() {
            return this.getUpperBound().getErased();
        }
    }

    public static class AnnotatedArrayType
    extends AnnotatedTypeMirror {
        private AnnotatedTypeMirror componentType;

        private AnnotatedArrayType(ArrayType type, AnnotatedTypeFactory factory) {
            super(type, factory);
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitArray(this, p);
        }

        @Override
        public ArrayType getUnderlyingType() {
            return (ArrayType)this.actualType;
        }

        public void setComponentType(AnnotatedTypeMirror type) {
            this.componentType = type;
        }

        public AnnotatedTypeMirror getComponentType() {
            if (this.componentType == null) {
                this.setComponentType(AnnotatedArrayType.createType(((ArrayType)this.actualType).getComponentType(), this.atypeFactory, false));
            }
            return this.componentType;
        }

        @Override
        public AnnotatedArrayType deepCopy(boolean copyAnnotations) {
            return (AnnotatedArrayType)new AnnotatedTypeCopier(copyAnnotations).visit(this);
        }

        @Override
        public AnnotatedArrayType deepCopy() {
            return this.deepCopy(true);
        }

        @Override
        public AnnotatedArrayType shallowCopy(boolean copyAnnotations) {
            AnnotatedArrayType type = new AnnotatedArrayType((ArrayType)this.actualType, this.atypeFactory);
            if (copyAnnotations) {
                type.addAnnotations(this.getAnnotationsField());
            }
            type.setComponentType(this.getComponentType());
            return type;
        }

        @Override
        public AnnotatedArrayType shallowCopy() {
            return this.shallowCopy(true);
        }

        @Override
        public AnnotatedArrayType getErased() {
            AnnotatedArrayType at = this.shallowCopy();
            AnnotatedTypeMirror ct = at.getComponentType().getErased();
            at.setComponentType(ct);
            return at;
        }
    }

    public static class AnnotatedExecutableType
    extends AnnotatedTypeMirror {
        private ExecutableElement element;
        protected final List<AnnotatedTypeMirror> paramTypes = new ArrayList<AnnotatedTypeMirror>();
        protected AnnotatedDeclaredType receiverType;
        protected AnnotatedTypeMirror returnType;
        protected final List<AnnotatedTypeMirror> throwsTypes = new ArrayList<AnnotatedTypeMirror>();
        protected final List<AnnotatedTypeVariable> typeVarTypes = new ArrayList<AnnotatedTypeVariable>();

        private AnnotatedExecutableType(ExecutableType type, AnnotatedTypeFactory factory) {
            super(type, factory);
        }

        public boolean isVarArgs() {
            return this.element.isVarArgs();
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }

        @Override
        public ExecutableType getUnderlyingType() {
            return (ExecutableType)this.actualType;
        }

        void setParameterTypes(List<? extends AnnotatedTypeMirror> params) {
            this.paramTypes.clear();
            this.paramTypes.addAll(params);
        }

        public List<AnnotatedTypeMirror> getParameterTypes() {
            if (this.paramTypes.isEmpty() && !((ExecutableType)this.actualType).getParameterTypes().isEmpty()) {
                for (TypeMirror typeMirror : ((ExecutableType)this.actualType).getParameterTypes()) {
                    this.paramTypes.add(AnnotatedExecutableType.createType(typeMirror, this.atypeFactory, false));
                }
            }
            return Collections.unmodifiableList(this.paramTypes);
        }

        void setReturnType(AnnotatedTypeMirror returnType) {
            this.returnType = returnType;
        }

        public AnnotatedTypeMirror getReturnType() {
            if (this.returnType == null && this.element != null && ((ExecutableType)this.actualType).getReturnType() != null) {
                TypeMirror aret = ((ExecutableType)this.actualType).getReturnType();
                if (((Symbol.MethodSymbol)this.element).isConstructor()) {
                    aret = this.element.getEnclosingElement().asType();
                }
                this.returnType = AnnotatedExecutableType.createType(aret, this.atypeFactory, false);
            }
            return this.returnType;
        }

        void setReceiverType(AnnotatedDeclaredType receiverType) {
            this.receiverType = receiverType;
        }

        public @Nullable AnnotatedDeclaredType getReceiverType() {
            if (!(this.receiverType != null || ElementUtils.isStatic(this.getElement()) || this.getElement().getKind() == ElementKind.CONSTRUCTOR && this.getElement().getEnclosingElement().getSimpleName().toString().equals("Array") && this.getElement().getEnclosingElement().getEnclosingElement().asType().getKind() == TypeKind.NONE || this.getElement().getKind() == ElementKind.CONSTRUCTOR && this.getElement().getEnclosingElement().getEnclosingElement().getKind() == ElementKind.PACKAGE)) {
                TypeElement encl = ElementUtils.enclosingClass(this.getElement());
                if (this.getElement().getKind() == ElementKind.CONSTRUCTOR) {
                    encl = ElementUtils.enclosingClass(encl.getEnclosingElement());
                }
                AnnotatedTypeMirror type = AnnotatedExecutableType.createType(encl.asType(), this.atypeFactory, false);
                assert (type instanceof AnnotatedDeclaredType);
                this.receiverType = (AnnotatedDeclaredType)type;
            }
            return this.receiverType;
        }

        void setThrownTypes(List<? extends AnnotatedTypeMirror> thrownTypes) {
            this.throwsTypes.clear();
            this.throwsTypes.addAll(thrownTypes);
        }

        public List<AnnotatedTypeMirror> getThrownTypes() {
            if (this.throwsTypes.isEmpty() && !((ExecutableType)this.actualType).getThrownTypes().isEmpty()) {
                for (TypeMirror typeMirror : ((ExecutableType)this.actualType).getThrownTypes()) {
                    this.throwsTypes.add(AnnotatedExecutableType.createType(typeMirror, this.atypeFactory, false));
                }
            }
            return Collections.unmodifiableList(this.throwsTypes);
        }

        void setTypeVariables(List<AnnotatedTypeVariable> types) {
            this.typeVarTypes.clear();
            this.typeVarTypes.addAll(types);
        }

        public List<AnnotatedTypeVariable> getTypeVariables() {
            if (this.typeVarTypes.isEmpty() && !((ExecutableType)this.actualType).getTypeVariables().isEmpty()) {
                for (TypeMirror typeMirror : ((ExecutableType)this.actualType).getTypeVariables()) {
                    this.typeVarTypes.add((AnnotatedTypeVariable)AnnotatedExecutableType.createType(typeMirror, this.atypeFactory, true));
                }
            }
            return Collections.unmodifiableList(this.typeVarTypes);
        }

        @Override
        public AnnotatedExecutableType deepCopy(boolean copyAnnotations) {
            return (AnnotatedExecutableType)new AnnotatedTypeCopier(copyAnnotations).visit(this);
        }

        @Override
        public AnnotatedExecutableType deepCopy() {
            return this.deepCopy(true);
        }

        @Override
        public AnnotatedExecutableType shallowCopy(boolean copyAnnotations) {
            AnnotatedExecutableType type = new AnnotatedExecutableType(this.getUnderlyingType(), this.atypeFactory);
            type.setElement(this.getElement());
            type.setParameterTypes(this.getParameterTypes());
            type.setReceiverType(this.getReceiverType());
            type.setReturnType(this.getReturnType());
            type.setThrownTypes(this.getThrownTypes());
            type.setTypeVariables(this.getTypeVariables());
            return type;
        }

        @Override
        public AnnotatedExecutableType shallowCopy() {
            return this.shallowCopy(true);
        }

        public @NonNull ExecutableElement getElement() {
            return this.element;
        }

        public void setElement(@NonNull ExecutableElement elem) {
            this.element = elem;
        }

        @Override
        public AnnotatedExecutableType getErased() {
            AnnotatedExecutableType type = new AnnotatedExecutableType((ExecutableType)this.atypeFactory.types.erasure(this.getUnderlyingType()), this.atypeFactory);
            type.setElement(this.getElement());
            type.setParameterTypes(this.erasureList(this.getParameterTypes()));
            if (this.getReceiverType() != null) {
                type.setReceiverType(this.getReceiverType().getErased());
            } else {
                type.setReceiverType(null);
            }
            type.setReturnType(this.getReturnType().getErased());
            type.setThrownTypes(this.erasureList(this.getThrownTypes()));
            return type;
        }

        private List<AnnotatedTypeMirror> erasureList(Iterable<? extends AnnotatedTypeMirror> lst) {
            ArrayList<AnnotatedTypeMirror> erased = new ArrayList<AnnotatedTypeMirror>();
            for (AnnotatedTypeMirror annotatedTypeMirror : lst) {
                erased.add(annotatedTypeMirror.getErased());
            }
            return erased;
        }
    }

    public static class AnnotatedDeclaredType
    extends AnnotatedTypeMirror {
        protected List<AnnotatedTypeMirror> typeArgs;
        private boolean wasRaw;
        protected AnnotatedDeclaredType enclosingType;
        protected List<AnnotatedDeclaredType> supertypes = null;
        private boolean declaration;

        private AnnotatedDeclaredType(DeclaredType type, AnnotatedTypeFactory atypeFactory, boolean declaration) {
            super(type, atypeFactory);
            TypeElement typeelem = (TypeElement)type.asElement();
            DeclaredType declty = (DeclaredType)typeelem.asType();
            this.wasRaw = !declty.getTypeArguments().isEmpty() && type.getTypeArguments().isEmpty();
            TypeMirror encl = type.getEnclosingType();
            if (encl.getKind() == TypeKind.DECLARED) {
                this.enclosingType = (AnnotatedDeclaredType)AnnotatedDeclaredType.createType(encl, atypeFactory, true);
            } else if (encl.getKind() != TypeKind.NONE) {
                ErrorReporter.errorAbort("AnnotatedDeclaredType: unsupported enclosing type: " + type.getEnclosingType() + " (" + (Object)((Object)encl.getKind()) + ")");
            }
            this.declaration = declaration;
        }

        @Override
        public boolean isDeclaration() {
            return this.declaration;
        }

        @Override
        public AnnotatedDeclaredType deepCopy(boolean copyAnnotations) {
            return (AnnotatedDeclaredType)new AnnotatedTypeCopier(copyAnnotations).visit(this);
        }

        @Override
        public AnnotatedDeclaredType deepCopy() {
            return this.deepCopy(true);
        }

        @Override
        public AnnotatedDeclaredType asUse() {
            if (!this.isDeclaration()) {
                return this;
            }
            AnnotatedDeclaredType result = this.shallowCopy(true);
            result.declaration = false;
            ArrayList<AnnotatedTypeMirror> newArgs = new ArrayList<AnnotatedTypeMirror>();
            block4: for (AnnotatedTypeMirror arg : result.getTypeArguments()) {
                switch (arg.getKind()) {
                    case TYPEVAR: {
                        AnnotatedTypeVariable paramTypevar = (AnnotatedTypeVariable)arg;
                        newArgs.add(paramTypevar.asUse());
                        continue block4;
                    }
                    case WILDCARD: {
                        AnnotatedWildcardType paramWildcard = (AnnotatedWildcardType)arg;
                        newArgs.add(paramWildcard.asUse());
                        continue block4;
                    }
                }
                newArgs.add(arg);
            }
            result.setTypeArguments(newArgs);
            return result;
        }

        @Override
        public <R, P> R accept(AnnotatedTypeVisitor<R, P> v, P p) {
            return v.visitDeclared(this, p);
        }

        public void setTypeArguments(List<? extends AnnotatedTypeMirror> ts) {
            if (ts == null || ts.isEmpty()) {
                this.typeArgs = Collections.emptyList();
            } else if (this.isDeclaration()) {
                this.typeArgs = Collections.unmodifiableList(ts);
            } else {
                ArrayList<AnnotatedTypeMirror> uses = new ArrayList<AnnotatedTypeMirror>();
                for (AnnotatedTypeMirror annotatedTypeMirror : ts) {
                    uses.add(annotatedTypeMirror.asUse());
                }
                this.typeArgs = Collections.unmodifiableList(uses);
            }
        }

        public List<AnnotatedTypeMirror> getTypeArguments() {
            if (this.typeArgs == null) {
                this.typeArgs = new ArrayList<AnnotatedTypeMirror>();
                if (!((DeclaredType)this.actualType).getTypeArguments().isEmpty()) {
                    for (TypeMirror typeMirror : ((DeclaredType)this.actualType).getTypeArguments()) {
                        this.typeArgs.add(AnnotatedDeclaredType.createType(typeMirror, this.atypeFactory, this.declaration));
                    }
                }
                this.typeArgs = Collections.unmodifiableList(this.typeArgs);
            }
            return this.typeArgs;
        }

        public boolean wasRaw() {
            return this.wasRaw;
        }

        protected void setWasRaw() {
            this.wasRaw = true;
        }

        @Override
        public DeclaredType getUnderlyingType() {
            return (DeclaredType)this.actualType;
        }

        public List<AnnotatedDeclaredType> directSuperTypes() {
            if (this.supertypes == null) {
                this.supertypes = Collections.unmodifiableList(SupertypeFinder.directSuperTypes(this));
            }
            return this.supertypes;
        }

        public List<AnnotatedDeclaredType> directSuperTypesField() {
            return this.supertypes;
        }

        @Override
        public AnnotatedDeclaredType shallowCopy() {
            return this.shallowCopy(true);
        }

        @Override
        public AnnotatedDeclaredType shallowCopy(boolean copyAnnotations) {
            AnnotatedDeclaredType type = new AnnotatedDeclaredType(this.getUnderlyingType(), this.atypeFactory, this.declaration);
            if (copyAnnotations) {
                type.addAnnotations(this.getAnnotationsField());
            }
            type.setEnclosingType(this.getEnclosingType());
            type.setTypeArguments(this.getTypeArguments());
            return type;
        }

        @Override
        public AnnotatedDeclaredType getErased() {
            if (!this.getTypeArguments().isEmpty()) {
                AnnotatedDeclaredType rType = (AnnotatedDeclaredType)AnnotatedTypeMirror.createType(this.atypeFactory.types.erasure(this.actualType), this.atypeFactory, this.declaration);
                rType.addAnnotations(this.getAnnotations());
                rType.setTypeArguments(Collections.emptyList());
                return rType.getErased();
            }
            if (this.getEnclosingType() != null && this.getEnclosingType().getKind() != TypeKind.NONE) {
                AnnotatedDeclaredType rType = this.shallowCopy();
                AnnotatedDeclaredType et = this.getEnclosingType();
                rType.setEnclosingType(et.getErased());
                return rType;
            }
            return this.deepCopy();
        }

        void setEnclosingType(AnnotatedDeclaredType enclosingType) {
            this.enclosingType = enclosingType;
        }

        public AnnotatedDeclaredType getEnclosingType() {
            return this.enclosingType;
        }
    }
}

