/*
 * Decompiled with CFR 0.152.
 */
package afu.com.jcraft.jsch.agentproxy;

import afu.com.jcraft.jsch.agentproxy.AgentProxyException;
import afu.com.jcraft.jsch.agentproxy.Connector;
import afu.com.jcraft.jsch.agentproxy.USocketFactory;
import afu.com.jcraft.jsch.agentproxy.connector.PageantConnector;
import afu.com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import afu.com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import afu.com.jcraft.jsch.agentproxy.usocket.NCUSocketFactory;
import java.util.ArrayList;

public abstract class ConnectorFactory {
    protected String connectors = "pageant,ssh-agent";
    protected String usocketFactories = "nc,jna";

    public void setPreferredConnectors(String connectors) {
        this.connectors = connectors;
    }

    public String getPreferredConnectors() {
        return this.connectors;
    }

    public void setPreferredUSocketFactories(String usocketFactories) {
        this.usocketFactories = usocketFactories;
    }

    public String getPreferredUSocketFactories() {
        return this.usocketFactories;
    }

    public Connector createConnector() throws AgentProxyException {
        ArrayList<String> trials = new ArrayList<String>();
        String[] _connectors = this.connectors.split(",");
        for (int i = 0; i < _connectors.length; ++i) {
            if (_connectors[i].trim().equals("pageant")) {
                if (!PageantConnector.isConnectorAvailable()) continue;
                try {
                    return new PageantConnector();
                }
                catch (AgentProxyException e) {
                    trials.add("pageant");
                    continue;
                }
            }
            if (!_connectors[i].trim().equals("ssh-agent") || !SSHAgentConnector.isConnectorAvailable()) continue;
            String[] _usocketFactories = this.usocketFactories.split(",");
            for (int j = 0; j < _usocketFactories.length; ++j) {
                USocketFactory usf;
                if (_usocketFactories[j].trim().equals("nc")) {
                    try {
                        usf = new NCUSocketFactory();
                        return new SSHAgentConnector(usf);
                    }
                    catch (AgentProxyException e) {
                        trials.add("ssh-agent:nc");
                        continue;
                    }
                }
                if (!_usocketFactories[j].trim().equals("jna")) continue;
                try {
                    usf = new JNAUSocketFactory();
                    return new SSHAgentConnector(usf);
                }
                catch (AgentProxyException e) {
                    trials.add("ssh-agent:jna");
                }
            }
        }
        String message = "connector is not available: ";
        String foo = "";
        for (int i = 0; i < trials.size(); ++i) {
            message = message + foo + (String)trials.get(i);
            foo = ",";
        }
        throw new AgentProxyException(message);
    }

    public static ConnectorFactory getDefault() {
        return new Default();
    }

    static class Default
    extends ConnectorFactory {
        Default() {
            String osName = System.getProperty("os.name");
            if (osName != null && !osName.startsWith("Windows")) {
                this.setPreferredConnectors("ssh-agent");
            }
        }
    }
}

