/*
 * Decompiled with CFR 0.152.
 */
package afu.com.jcraft.jsch.agentproxy.usocket;

import afu.com.jcraft.jsch.agentproxy.AgentProxyException;
import afu.com.jcraft.jsch.agentproxy.USocketFactory;
import afu.com.sun.jna.Library;
import afu.com.sun.jna.Native;
import afu.com.sun.jna.Pointer;
import afu.com.sun.jna.Structure;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class JNAUSocketFactory
implements USocketFactory {
    public USocketFactory.Socket open(String path) throws IOException {
        int sock = CLibrary.INSTANCE.socket(1, 1, 0);
        if (sock < 0) {
            throw new IOException("failed to allocate usocket");
        }
        int foo = CLibrary.INSTANCE.fcntl(sock, 2, 8);
        if (foo < 0) {
            CLibrary.INSTANCE.close(sock);
            throw new IOException("failed to fctrl usocket: " + foo);
        }
        SockAddr sockaddr = new SockAddr();
        sockaddr.sun_family = 1;
        sockaddr.sun_path = new byte[108];
        System.arraycopy(path.getBytes(), 0, sockaddr.sun_path, 0, path.length());
        sockaddr.write();
        foo = CLibrary.INSTANCE.connect(sock, sockaddr.getPointer(), sockaddr.size());
        if (foo < 0) {
            throw new IOException("failed to fctrl usocket: " + foo);
        }
        return new MySocket(sock);
    }

    public class MySocket
    extends USocketFactory.Socket {
        private int sock;

        public int readFull(byte[] buf, int s2, int len) throws IOException {
            int i;
            byte[] _buf = buf;
            int _s = s2;
            for (int _len = len; _len > 0; _len -= i) {
                if (_s != 0) {
                    _buf = new byte[_len];
                }
                if ((i = CLibrary.INSTANCE.read(this.sock, _buf, _len)) <= 0) {
                    return -1;
                }
                if (_s != 0) {
                    System.arraycopy(_buf, 0, buf, _s, i);
                }
                _s += i;
            }
            return len;
        }

        public void write(byte[] buf, int s2, int len) throws IOException {
            byte[] _buf = buf;
            int _len = len;
            if (s2 != 0) {
                _buf = new byte[len];
                System.arraycopy(buf, s2, _buf, 0, len);
            }
            CLibrary.INSTANCE.write(this.sock, _buf, len);
        }

        MySocket(int sock) throws IOException {
            this.sock = sock;
        }

        public void close() throws IOException {
            CLibrary.INSTANCE.close(this.sock);
        }
    }

    public static class SockAddr
    extends Structure {
        public short sun_family;
        public byte[] sun_path;

        protected List getFieldOrder() {
            return Arrays.asList("sun_family", "sun_path");
        }
    }

    public static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary("c", CLibrary.class);

        public int socket(int var1, int var2, int var3);

        public int fcntl(int var1, int var2, Object ... var3);

        public int connect(int var1, Pointer var2, int var3);

        public int close(int var1);

        public int read(int var1, byte[] var2, int var3);

        public int write(int var1, byte[] var2, int var3);
    }
}

