/*
 * Decompiled with CFR 0.152.
 */
package afu.de.regnis.q.sequence.media;

import afu.de.regnis.q.sequence.core.QSequenceCancelledException;
import afu.de.regnis.q.sequence.core.QSequenceCanceller;
import afu.de.regnis.q.sequence.core.QSequenceException;
import afu.de.regnis.q.sequence.media.QSequenceCachableMedia;
import afu.de.regnis.q.sequence.media.QSequenceCachableMediaLeftGetter;
import afu.de.regnis.q.sequence.media.QSequenceCachableMediaRightGetter;
import afu.de.regnis.q.sequence.media.QSequenceCachingMediaSymbolMap;
import afu.de.regnis.q.sequence.media.QSequenceIntMedia;

public class QSequenceCachingMedia
extends QSequenceIntMedia {
    private final QSequenceCachingMediaSymbolMap symbolMap;
    private final int[] leftSymbols;
    private final int[] rightSymbols;

    public QSequenceCachingMedia(QSequenceCachableMedia media, QSequenceCanceller canceller) throws QSequenceException {
        super(canceller);
        this.symbolMap = new QSequenceCachingMediaSymbolMap(media.getLeftLength() + media.getRightLength());
        this.leftSymbols = this.symbolMap.createSymbols(media, new QSequenceCachableMediaLeftGetter());
        this.rightSymbols = this.symbolMap.createSymbols(media, new QSequenceCachableMediaRightGetter());
    }

    public int getLeftLength() {
        return this.leftSymbols.length;
    }

    public int getRightLength() {
        return this.rightSymbols.length;
    }

    public boolean equals(int leftIndex, int rightIndex) throws QSequenceCancelledException {
        this.checkCancelled();
        return this.leftSymbols[leftIndex] == this.rightSymbols[rightIndex];
    }

    public int getSymbolCount() {
        return this.symbolMap.getSymbolCount();
    }

    public int[] getLeftSymbols() {
        return this.leftSymbols;
    }

    public int[] getRightSymbols() {
        return this.rightSymbols;
    }
}

