/*
 * Decompiled with CFR 0.152.
 */
package afu.net.fortuna.ical4j.model.component;

import afu.net.fortuna.ical4j.model.Date;
import afu.net.fortuna.ical4j.model.PropertyList;
import afu.net.fortuna.ical4j.model.ValidationException;
import afu.net.fortuna.ical4j.model.Validator;
import afu.net.fortuna.ical4j.model.component.CalendarComponent;
import afu.net.fortuna.ical4j.model.property.Clazz;
import afu.net.fortuna.ical4j.model.property.Created;
import afu.net.fortuna.ical4j.model.property.Description;
import afu.net.fortuna.ical4j.model.property.DtStamp;
import afu.net.fortuna.ical4j.model.property.DtStart;
import afu.net.fortuna.ical4j.model.property.LastModified;
import afu.net.fortuna.ical4j.model.property.Method;
import afu.net.fortuna.ical4j.model.property.Organizer;
import afu.net.fortuna.ical4j.model.property.RecurrenceId;
import afu.net.fortuna.ical4j.model.property.Sequence;
import afu.net.fortuna.ical4j.model.property.Status;
import afu.net.fortuna.ical4j.model.property.Summary;
import afu.net.fortuna.ical4j.model.property.Uid;
import afu.net.fortuna.ical4j.model.property.Url;
import afu.net.fortuna.ical4j.util.CompatibilityHints;
import afu.net.fortuna.ical4j.util.PropertyValidator;
import java.util.HashMap;
import java.util.Map;

public class VJournal
extends CalendarComponent {
    private static final long serialVersionUID = -7635140949183238830L;
    private final Map methodValidators = new HashMap();

    public VJournal() {
        super("VJOURNAL");
        this.methodValidators.put(Method.ADD, new AddValidator());
        this.methodValidators.put(Method.CANCEL, new CancelValidator());
        this.methodValidators.put(Method.PUBLISH, new PublishValidator());
        this.getProperties().add(new DtStamp());
    }

    public VJournal(PropertyList properties) {
        super("VJOURNAL", properties);
        this.methodValidators.put(Method.ADD, new AddValidator());
        this.methodValidators.put(Method.CANCEL, new CancelValidator());
        this.methodValidators.put(Method.PUBLISH, new PublishValidator());
    }

    public VJournal(Date start, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new Summary(summary));
    }

    public final void validate(boolean recurse) throws ValidationException {
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
            PropertyValidator.getInstance().assertOne("UID", this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        }
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        Status status = (Status)this.getProperty("STATUS");
        if (!(status == null || Status.VJOURNAL_DRAFT.getValue().equals(status.getValue()) || Status.VJOURNAL_FINAL.getValue().equals(status.getValue()) || Status.VJOURNAL_CANCELLED.getValue().equals(status.getValue()))) {
            throw new ValidationException("Status property [" + status.toString() + "] may not occur in VJOURNAL");
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    protected Validator getValidator(Method method) {
        return (Validator)this.methodValidators.get(method);
    }

    public final Clazz getClassification() {
        return (Clazz)this.getProperty("CLASS");
    }

    public final Created getCreated() {
        return (Created)this.getProperty("CREATED");
    }

    public final Description getDescription() {
        return (Description)this.getProperty("DESCRIPTION");
    }

    public final DtStart getStartDate() {
        return (DtStart)this.getProperty("DTSTART");
    }

    public final LastModified getLastModified() {
        return (LastModified)this.getProperty("LAST-MODIFIED");
    }

    public final Organizer getOrganizer() {
        return (Organizer)this.getProperty("ORGANIZER");
    }

    public final DtStamp getDateStamp() {
        return (DtStamp)this.getProperty("DTSTAMP");
    }

    public final Sequence getSequence() {
        return (Sequence)this.getProperty("SEQUENCE");
    }

    public final Status getStatus() {
        return (Status)this.getProperty("STATUS");
    }

    public final Summary getSummary() {
        return (Summary)this.getProperty("SUMMARY");
    }

    public final Url getUrl() {
        return (Url)this.getProperty("URL");
    }

    public final RecurrenceId getRecurrenceId() {
        return (RecurrenceId)this.getProperty("RECURRENCE-ID");
    }

    public final Uid getUid() {
        return (Uid)this.getProperty("UID");
    }

    private class AddValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private AddValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("DESCRIPTION", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTART", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOne("SEQUENCE", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SUMMARY", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertNone("ATTENDEE", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertNone("RECURRENCE-ID", VJournal.this.getProperties());
        }
    }

    private class CancelValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private CancelValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("DTSTAMP", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOne("SEQUENCE", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("DTSTART", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SUMMARY", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertNone("REQUEST-STATUS", VJournal.this.getProperties());
        }
    }

    private class PublishValidator
    implements Validator {
        private static final long serialVersionUID = 1L;

        private PublishValidator() {
        }

        public void validate() throws ValidationException {
            PropertyValidator.getInstance().assertOne("DESCRIPTION", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTART", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOne("ORGANIZER", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOne("UID", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CLASS", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("CREATED", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("STATUS", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("SUMMARY", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertOneOrLess("URL", VJournal.this.getProperties());
            PropertyValidator.getInstance().assertNone("ATTENDEE", VJournal.this.getProperties());
        }
    }
}

