/*
 * Decompiled with CFR 0.152.
 */
package afu.nu.xom.converters;

import afu.nu.xom.Attribute;
import afu.nu.xom.Comment;
import afu.nu.xom.DocType;
import afu.nu.xom.Document;
import afu.nu.xom.Element;
import afu.nu.xom.Node;
import afu.nu.xom.NodeFactory;
import afu.nu.xom.Nodes;
import afu.nu.xom.ParentNode;
import afu.nu.xom.ProcessingInstruction;
import afu.nu.xom.Text;
import afu.nu.xom.XMLException;
import afu.org.w3c.dom.Attr;
import afu.org.w3c.dom.DOMImplementation;
import afu.org.w3c.dom.DocumentFragment;
import afu.org.w3c.dom.DocumentType;
import afu.org.w3c.dom.NamedNodeMap;
import afu.org.w3c.dom.NodeList;

public class DOMConverter {
    private static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";

    private DOMConverter() {
    }

    public static Document convert(afu.org.w3c.dom.Document document) {
        return DOMConverter.convert(document, new NodeFactory());
    }

    public static Document convert(afu.org.w3c.dom.Document document, NodeFactory nodeFactory) {
        afu.org.w3c.dom.Element element = document.getDocumentElement();
        Element element2 = nodeFactory.makeRootElement(element.getTagName(), element.getNamespaceURI());
        Document document2 = nodeFactory.startMakingDocument();
        document2.setRootElement(element2);
        Nodes nodes = DOMConverter.convert(element, nodeFactory);
        boolean bl = true;
        int n = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (bl) {
                if (node instanceof Element) {
                    document2.setRootElement((Element)node);
                    bl = false;
                    continue;
                }
                document2.insertChild(node, n++);
                continue;
            }
            document2.appendChild(node);
        }
        afu.org.w3c.dom.Node node = document.getFirstChild();
        int n2 = 0;
        while (node.getNodeType() != 1) {
            Nodes nodes2 = DOMConverter.convert(node, nodeFactory);
            for (int i = 0; i < nodes2.size(); ++i) {
                document2.insertChild(nodes2.get(i), n2++);
            }
            node = node.getNextSibling();
        }
        for (node = node.getNextSibling(); node != null; node = node.getNextSibling()) {
            Nodes nodes3 = DOMConverter.convert(node, nodeFactory);
            for (int i = 0; i < nodes3.size(); ++i) {
                document2.appendChild(nodes3.get(i));
            }
        }
        return document2;
    }

    public static Nodes convert(DocumentFragment documentFragment) {
        return DOMConverter.convert(documentFragment, new NodeFactory());
    }

    public static Nodes convert(DocumentFragment documentFragment, NodeFactory nodeFactory) {
        Nodes nodes = new Nodes();
        NodeList nodeList = documentFragment.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Nodes nodes2 = DOMConverter.convert(nodeList.item(i), nodeFactory);
            DOMConverter.appendNodes(nodes, nodes2);
        }
        return nodes;
    }

    private static void appendNodes(Nodes nodes, Nodes nodes2) {
        for (int i = 0; i < nodes2.size(); ++i) {
            nodes.append(nodes2.get(i));
        }
    }

    private static Nodes convert(afu.org.w3c.dom.Node node, NodeFactory nodeFactory) {
        short s2 = node.getNodeType();
        switch (s2) {
            case 1: {
                return DOMConverter.convert((afu.org.w3c.dom.Element)node, nodeFactory);
            }
            case 8: {
                return DOMConverter.convert((afu.org.w3c.dom.Comment)node, nodeFactory);
            }
            case 10: {
                return DOMConverter.convert((DocumentType)node, nodeFactory);
            }
            case 3: {
                return DOMConverter.convert((afu.org.w3c.dom.Text)node, nodeFactory);
            }
            case 4: {
                return DOMConverter.convert((afu.org.w3c.dom.Text)node, nodeFactory);
            }
            case 7: {
                return DOMConverter.convert((afu.org.w3c.dom.ProcessingInstruction)node, nodeFactory);
            }
        }
        throw new XMLException("Unexpected DOM node type: " + s2);
    }

    public static Comment convert(afu.org.w3c.dom.Comment comment) {
        return new Comment(comment.getNodeValue());
    }

    private static Nodes convert(afu.org.w3c.dom.Comment comment, NodeFactory nodeFactory) {
        return nodeFactory.makeComment(comment.getNodeValue());
    }

    public static Text convert(afu.org.w3c.dom.Text text) {
        return new Text(text.getNodeValue());
    }

    private static Nodes convert(afu.org.w3c.dom.Text text, NodeFactory nodeFactory) {
        return nodeFactory.makeText(text.getNodeValue());
    }

    public static Attribute convert(Attr attr) {
        String string = attr.getName();
        String string2 = attr.getNamespaceURI();
        if (string2 == null) {
            string2 = "";
        }
        return new Attribute(string, string2, attr.getNodeValue());
    }

    public static ProcessingInstruction convert(afu.org.w3c.dom.ProcessingInstruction processingInstruction) {
        return new ProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getNodeValue());
    }

    private static Nodes convert(afu.org.w3c.dom.ProcessingInstruction processingInstruction, NodeFactory nodeFactory) {
        return nodeFactory.makeProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getNodeValue());
    }

    public static DocType convert(DocumentType documentType) {
        DocType docType = new DocType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        docType.setInternalDTDSubset(documentType.getInternalSubset());
        return docType;
    }

    private static Nodes convert(DocumentType documentType, NodeFactory nodeFactory) {
        Nodes nodes = nodeFactory.makeDocType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!(node instanceof DocType)) continue;
            ((DocType)node).setInternalDTDSubset(documentType.getInternalSubset());
            break;
        }
        return nodes;
    }

    public static Element convert(afu.org.w3c.dom.Element element) {
        return (Element)DOMConverter.convert(element, new NodeFactory()).get(0);
    }

    /*
     * Unable to fully structure code
     */
    private static Nodes convert(afu.org.w3c.dom.Element var0, NodeFactory var1_1) {
        var2_2 = var0;
        var3_3 = DOMConverter.makeElement(var0, var1_1);
        if (var3_3 == null) {
            var4_4 = new Nodes();
            var5_6 = var0.getChildNodes();
            for (var6_8 = 0; var6_8 < var5_6.getLength(); ++var6_8) {
                var7_10 = DOMConverter.convert(var5_6.item(var6_8), var1_1);
                for (var8_12 = 0; var8_12 < var7_10.size(); ++var8_12) {
                    var4_4.append(var7_10.get(var8_12));
                }
            }
            return var4_4;
        }
        var4_5 = var3_3;
        var5_7 = false;
        block2: while (true) {
            if (var2_2.hasChildNodes() && !var5_7) {
                var2_2 = var2_2.getFirstChild();
                var5_7 = false;
            } else {
                if (var2_2 == var0) break;
                if (var2_2.getNextSibling() != null) {
                    var2_2 = var2_2.getNextSibling();
                    var5_7 = false;
                } else {
                    var2_2 = var2_2.getParentNode();
                    var5_7 = true;
                    if (var4_5.getParent() == null) continue;
                    var4_5 = var4_5.getParent();
                    continue;
                }
            }
            var6_9 = var2_2.getNodeType();
            if (var6_9 == 1) {
                var7_11 = DOMConverter.makeElement(var2_2, var1_1);
                if (var7_11 == null) continue;
                var4_5.appendChild((Node)var7_11);
                if (!var2_2.hasChildNodes()) continue;
                var4_5 = var7_11;
                continue;
            }
            var7_11 = DOMConverter.convert((afu.org.w3c.dom.Node)var2_2, var1_1);
            var8_13 = 0;
            while (true) {
                if (var8_13 < var7_11.size()) ** break;
                continue block2;
                var4_5.appendChild(var7_11.get(var8_13));
                ++var8_13;
            }
            break;
        }
        return var1_1.finishMakingElement(var3_3);
    }

    private static Element makeElement(afu.org.w3c.dom.Element element, NodeFactory nodeFactory) {
        String string = element.getNamespaceURI();
        String string2 = element.getTagName();
        Element element2 = element.getParentNode() == null || element.getParentNode().getNodeType() == 9 ? nodeFactory.makeRootElement(string2, string) : nodeFactory.startMakingElement(string2, string);
        if (element2 == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Object object;
            Attr attr = (Attr)namedNodeMap.item(i);
            String string3 = attr.getName();
            String string4 = attr.getNamespaceURI();
            String string5 = attr.getValue();
            if (string4 == null) {
                string4 = "";
            }
            if (string4.equals(XMLNS_NAMESPACE)) {
                String string6;
                if (string3.equals("xmlns") || string5.equals(string6 = element2.getNamespaceURI((String)(object = string3.substring(string3.indexOf(58) + 1))))) continue;
                element2.addNamespaceDeclaration((String)object, string5);
                continue;
            }
            object = nodeFactory.makeAttribute(string3, string4, string5, Attribute.Type.UNDECLARED);
            for (int j = 0; j < ((Nodes)object).size(); ++j) {
                Node node = ((Nodes)object).get(j);
                if (node instanceof Attribute) {
                    element2.addAttribute((Attribute)node);
                    continue;
                }
                element2.appendChild(node);
            }
        }
        return element2;
    }

    public static afu.org.w3c.dom.Document convert(Document document, DOMImplementation dOMImplementation) {
        Element element = document.getRootElement();
        String string = element.getQualifiedName();
        String string2 = element.getNamespaceURI();
        DocType docType = document.getDocType();
        DocumentType documentType = null;
        if (docType != null) {
            documentType = dOMImplementation.createDocumentType(string, docType.getPublicID(), docType.getSystemID());
        }
        afu.org.w3c.dom.Document document2 = dOMImplementation.createDocument(string2, string, documentType);
        afu.org.w3c.dom.Element element2 = document2.getDocumentElement();
        boolean bl = true;
        for (int i = 0; i < document.getChildCount(); ++i) {
            Node node = document.getChild(i);
            if (node instanceof DocType) continue;
            if (node instanceof Element) {
                DOMConverter.convert((Element)node, document2);
                bl = false;
                continue;
            }
            afu.org.w3c.dom.Node node2 = DOMConverter.convert(node, document2);
            if (bl) {
                document2.insertBefore(node2, (afu.org.w3c.dom.Node)element2);
                continue;
            }
            document2.appendChild(node2);
        }
        return document2;
    }

    private static afu.org.w3c.dom.Node convert(Node node, afu.org.w3c.dom.Document document) {
        if (node instanceof Text) {
            return DOMConverter.convert((Text)node, document);
        }
        if (node instanceof Comment) {
            return DOMConverter.convert((Comment)node, document);
        }
        if (node instanceof ProcessingInstruction) {
            return DOMConverter.convert((ProcessingInstruction)node, document);
        }
        throw new XMLException("Unexpected node type: " + node.getClass().getName());
    }

    private static afu.org.w3c.dom.Comment convert(Comment comment, afu.org.w3c.dom.Document document) {
        return document.createComment(comment.getValue());
    }

    private static afu.org.w3c.dom.Text convert(Text text, afu.org.w3c.dom.Document document) {
        return document.createTextNode(text.getValue());
    }

    private static afu.org.w3c.dom.ProcessingInstruction convert(ProcessingInstruction processingInstruction, afu.org.w3c.dom.Document document) {
        return document.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getValue());
    }

    private static afu.org.w3c.dom.Element convert(Element element, afu.org.w3c.dom.Document document) {
        afu.org.w3c.dom.Element element2;
        afu.org.w3c.dom.Element element3 = element2 = DOMConverter.makeElement(element, document);
        Node node = element;
        int n = 0;
        int[] nArray = new int[10];
        int n2 = 0;
        nArray[0] = 0;
        boolean bl = false;
        while (true) {
            afu.org.w3c.dom.Node node2;
            ParentNode parentNode;
            if (!bl && node.getChildCount() > 0) {
                node = node.getChild(0);
                n = 0;
                nArray = DOMConverter.grow(nArray, ++n2);
                nArray[n2] = 0;
            } else {
                bl = false;
                parentNode = node.getParent();
                node2 = element3.getParentNode();
                if (node2.getNodeType() == 1 && node instanceof Element) {
                    element3 = node2;
                }
                if (parentNode.getChildCount() - 1 == n) {
                    ParentNode parentNode2;
                    node = parentNode;
                    --n2;
                    if (node == element || (parentNode2 = node.getParent()) == null) break;
                    n = nArray[n2];
                    bl = true;
                    continue;
                }
                nArray[n2] = ++n;
                node = parentNode.getChild(n);
            }
            if (node instanceof Element) {
                parentNode = node;
                node2 = DOMConverter.makeElement((Element)parentNode, document);
                element3.appendChild(node2);
                element3 = node2;
                continue;
            }
            parentNode = DOMConverter.convert(node, document);
            element3.appendChild((afu.org.w3c.dom.Node)parentNode);
        }
        return element2;
    }

    private static int[] grow(int[] nArray, int n) {
        if (n < nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length * 2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private static afu.org.w3c.dom.Element makeElement(Element element, afu.org.w3c.dom.Document document) {
        Object object;
        String string;
        int n;
        String string2 = element.getNamespaceURI();
        afu.org.w3c.dom.Element element2 = element.getParent() instanceof Document ? document.getDocumentElement() : (string2.equals("") ? document.createElement(element.getQualifiedName()) : document.createElementNS(string2, element.getQualifiedName()));
        int n2 = element.getAttributeCount();
        for (n = 0; n < n2; ++n) {
            Attribute attribute = element.getAttribute(n);
            string = attribute.getNamespaceURI();
            if (string.equals("")) {
                object = document.createAttribute(attribute.getLocalName());
                element2.setAttributeNode((Attr)object);
            } else {
                object = document.createAttributeNS(string, attribute.getQualifiedName());
                element2.setAttributeNodeNS((Attr)object);
            }
            object.setValue(attribute.getValue());
        }
        n = element.getNamespaceDeclarationCount();
        for (int i = 0; i < n; ++i) {
            Element element3;
            string = element.getNamespacePrefix(i);
            object = element.getNamespaceURI(string);
            ParentNode parentNode = element.getParent();
            if (!(parentNode instanceof Element) ? ((String)object).equals("") : ((String)object).equals((element3 = (Element)parentNode).getNamespaceURI(string))) continue;
            if ("".equals(string)) {
                element3 = document.createAttributeNS(XMLNS_NAMESPACE, "xmlns");
                element2.setAttributeNodeNS((Attr)element3);
                element3.setValue((String)object);
                continue;
            }
            element3 = document.createAttributeNS(XMLNS_NAMESPACE, "xmlns:" + string);
            element2.setAttributeNodeNS((Attr)element3);
            element3.setValue((String)object);
        }
        return element2;
    }
}

