/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ElementValue;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataOutputStream;
import java.io.IOException;

public class ArrayElementValue
extends ElementValue {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValue @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] evalues;

    @Override
    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < this.evalues.length; ++i) {
            sb.append(this.evalues[i]);
            if (i + 1 >= this.evalues.length) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public ArrayElementValue(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValue @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] datums, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cpool) {
        super(type, cpool);
        if (type != 91) {
            throw new RuntimeException("Only element values of type array can be built with this ctor - type specified: " + type);
        }
        this.evalues = datums;
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream dos) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        dos.writeByte(super.getType());
        dos.writeShort(this.evalues.length);
        for (ElementValue evalue : this.evalues) {
            evalue.dump(dos);
        }
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String stringifyValue() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.evalues.length; ++i) {
            sb.append(this.evalues[i].stringifyValue());
            if (i + 1 >= this.evalues.length) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ElementValue @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getElementValuesArray() {
        return this.evalues;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getElementValuesArraySize() {
        return this.evalues.length;
    }
}

