/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.Const;
import afu.org.apache.commons.bcel6.classfile.AnnotationDefault;
import afu.org.apache.commons.bcel6.classfile.AttributeReader;
import afu.org.apache.commons.bcel6.classfile.BootstrapMethods;
import afu.org.apache.commons.bcel6.classfile.ClassFormatException;
import afu.org.apache.commons.bcel6.classfile.Code;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.ConstantValue;
import afu.org.apache.commons.bcel6.classfile.Deprecated;
import afu.org.apache.commons.bcel6.classfile.EnclosingMethod;
import afu.org.apache.commons.bcel6.classfile.ExceptionTable;
import afu.org.apache.commons.bcel6.classfile.InnerClasses;
import afu.org.apache.commons.bcel6.classfile.LineNumberTable;
import afu.org.apache.commons.bcel6.classfile.LocalVariableTable;
import afu.org.apache.commons.bcel6.classfile.LocalVariableTypeTable;
import afu.org.apache.commons.bcel6.classfile.MethodParameters;
import afu.org.apache.commons.bcel6.classfile.Node;
import afu.org.apache.commons.bcel6.classfile.PMGClass;
import afu.org.apache.commons.bcel6.classfile.RuntimeInvisibleAnnotations;
import afu.org.apache.commons.bcel6.classfile.RuntimeInvisibleParameterAnnotations;
import afu.org.apache.commons.bcel6.classfile.RuntimeVisibleAnnotations;
import afu.org.apache.commons.bcel6.classfile.RuntimeVisibleParameterAnnotations;
import afu.org.apache.commons.bcel6.classfile.Signature;
import afu.org.apache.commons.bcel6.classfile.SourceFile;
import afu.org.apache.commons.bcel6.classfile.StackMap;
import afu.org.apache.commons.bcel6.classfile.Synthetic;
import afu.org.apache.commons.bcel6.classfile.Unknown;
import afu.org.apache.commons.bcel6.classfile.UnknownAttributeReader;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class Attribute
implements Cloneable,
Node {
    @java.lang.Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index;
    @java.lang.Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length;
    @java.lang.Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte tag;
    @java.lang.Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool;
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object> readers = new HashMap<String, Object>();

    protected Attribute(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte tag, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        this.tag = tag;
        this.name_index = name_index;
        this.length = length;
        this.constant_pool = constant_pool;
    }

    @Override
    public abstract void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor var1);

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeShort(this.name_index);
        file.writeInt(this.length);
    }

    @java.lang.Deprecated
    public static void addAttributeReader(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AttributeReader r) {
        readers.put(name, r);
    }

    public static void addAttributeReader(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString UnknownAttributeReader r) {
        readers.put(name, r);
    }

    public static void removeAttributeReader(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name) {
        readers.remove(name);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute readAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInputStream file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFormatException {
        return Attribute.readAttribute((DataInput)file, constant_pool);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute readAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassFormatException {
        int tag = -1;
        int name_index = file.readUnsignedShort();
        ConstantUtf8 c = (ConstantUtf8)constant_pool.getConstant(name_index, (byte)1);
        String name = c.getBytes();
        int length = file.readInt();
        for (int i = 0; i < 22; i = (int)((byte)(i + 1))) {
            if (!name.equals(Const.getAttributeName(i))) continue;
            tag = i;
            break;
        }
        switch (tag) {
            case -1: {
                Object r = readers.get(name);
                if (r instanceof UnknownAttributeReader) {
                    return ((UnknownAttributeReader)r).createAttribute(name_index, length, file, constant_pool);
                }
                return new Unknown(name_index, length, file, constant_pool);
            }
            case 1: {
                return new ConstantValue(name_index, length, file, constant_pool);
            }
            case 0: {
                return new SourceFile(name_index, length, file, constant_pool);
            }
            case 2: {
                return new Code(name_index, length, file, constant_pool);
            }
            case 3: {
                return new ExceptionTable(name_index, length, file, constant_pool);
            }
            case 4: {
                return new LineNumberTable(name_index, length, file, constant_pool);
            }
            case 5: {
                return new LocalVariableTable(name_index, length, file, constant_pool);
            }
            case 6: {
                return new InnerClasses(name_index, length, file, constant_pool);
            }
            case 7: {
                return new Synthetic(name_index, length, file, constant_pool);
            }
            case 8: {
                return new Deprecated(name_index, length, file, constant_pool);
            }
            case 9: {
                return new PMGClass(name_index, length, file, constant_pool);
            }
            case 10: {
                return new Signature(name_index, length, file, constant_pool);
            }
            case 11: {
                return new StackMap(name_index, length, file, constant_pool);
            }
            case 12: {
                return new RuntimeVisibleAnnotations(name_index, length, file, constant_pool);
            }
            case 13: {
                return new RuntimeInvisibleAnnotations(name_index, length, file, constant_pool);
            }
            case 14: {
                return new RuntimeVisibleParameterAnnotations(name_index, length, file, constant_pool);
            }
            case 15: {
                return new RuntimeInvisibleParameterAnnotations(name_index, length, file, constant_pool);
            }
            case 16: {
                return new AnnotationDefault(name_index, length, file, constant_pool);
            }
            case 17: {
                return new LocalVariableTypeTable(name_index, length, file, constant_pool);
            }
            case 18: {
                return new EnclosingMethod(name_index, length, file, constant_pool);
            }
            case 19: {
                return new StackMap(name_index, length, file, constant_pool);
            }
            case 20: {
                return new BootstrapMethods(name_index, length, file, constant_pool);
            }
            case 21: {
                return new MethodParameters(name_index, length, file, constant_pool);
            }
        }
        throw new IllegalStateException("Unrecognized attribute type tag parsed: " + tag);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getName() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        return c.getBytes();
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getLength() {
        return this.length;
    }

    public final void setLength(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length) {
        this.length = length;
    }

    public final void setNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index) {
        this.name_index = name_index;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getNameIndex() {
        return this.name_index;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte getTag() {
        return this.tag;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object clone() {
        Attribute attr = null;
        try {
            attr = (Attribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
        return attr;
    }

    public abstract @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool var1);

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return Const.getAttributeName(this.tag);
    }
}

