/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.CodeException;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.LineNumberTable;
import afu.org.apache.commons.bcel6.classfile.LocalVariableTable;
import afu.org.apache.commons.bcel6.classfile.Node;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Code
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_stack;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_locals;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] code;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CodeException @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] exception_table;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] attributes;

    public Code(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Code c) {
        this(c.getNameIndex(), c.getLength(), c.getMaxStack(), c.getMaxLocals(), c.getCode(), c.getExceptionTable(), c.getAttributes(), c.getConstantPool());
    }

    Code(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput file, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(name_index, length, file.readUnsignedShort(), file.readUnsignedShort(), null, null, null, constant_pool);
        int code_length = file.readInt();
        this.code = new byte[code_length];
        file.readFully(this.code);
        int exception_table_length = file.readUnsignedShort();
        this.exception_table = new CodeException[exception_table_length];
        for (int i = 0; i < exception_table_length; ++i) {
            this.exception_table[i] = new CodeException(file);
        }
        int attributes_count = file.readUnsignedShort();
        this.attributes = new Attribute[attributes_count];
        for (int i = 0; i < attributes_count; ++i) {
            this.attributes[i] = Attribute.readAttribute(file, constant_pool);
        }
        super.setLength(length);
    }

    public Code(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_stack, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_locals, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] code, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CodeException @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] exception_table, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] attributes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        super((byte)2, name_index, length, constant_pool);
        this.max_stack = max_stack;
        this.max_locals = max_locals;
        this.code = code != null ? code : new byte[]{};
        this.exception_table = exception_table != null ? exception_table : new CodeException[]{};
        this.attributes = attributes != null ? attributes : new Attribute[]{};
        super.setLength(this.calculateLength());
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitCode(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        super.dump(file);
        file.writeShort(this.max_stack);
        file.writeShort(this.max_locals);
        file.writeInt(this.code.length);
        file.write(this.code, 0, this.code.length);
        file.writeShort(this.exception_table.length);
        for (CodeException codeException : this.exception_table) {
            codeException.dump(file);
        }
        file.writeShort(this.attributes.length);
        for (Node node : this.attributes) {
            ((Attribute)node).dump(file);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getAttributes() {
        return this.attributes;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LineNumberTable getLineNumberTable() {
        for (Attribute attribute : this.attributes) {
            if (!(attribute instanceof LineNumberTable)) continue;
            return (LineNumberTable)attribute;
        }
        return null;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariableTable getLocalVariableTable() {
        for (Attribute attribute : this.attributes) {
            if (!(attribute instanceof LocalVariableTable)) continue;
            return (LocalVariableTable)attribute;
        }
        return null;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getCode() {
        return this.code;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CodeException @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getExceptionTable() {
        return this.exception_table;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getMaxLocals() {
        return this.max_locals;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getMaxStack() {
        return this.max_stack;
    }

    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getInternalLength() {
        return 8 + this.code.length + 2 + 8 * (this.exception_table == null ? 0 : this.exception_table.length) + 2;
    }

    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int calculateLength() {
        int len = 0;
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                len += attribute.getLength() + 6;
            }
        }
        return len + this.getInternalLength();
    }

    public final void setAttributes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] attributes) {
        this.attributes = attributes != null ? attributes : new Attribute[]{};
        super.setLength(this.calculateLength());
    }

    public final void setCode(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] code) {
        this.code = code != null ? code : new byte[]{};
        super.setLength(this.calculateLength());
    }

    public final void setExceptionTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CodeException @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] exception_table) {
        this.exception_table = exception_table != null ? exception_table : new CodeException[]{};
        super.setLength(this.calculateLength());
    }

    public final void setMaxLocals(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_locals) {
        this.max_locals = max_locals;
    }

    public final void setMaxStack(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_stack) {
        this.max_stack = max_stack;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean verbose) {
        StringBuilder buf = new StringBuilder(100);
        buf.append("Code(max_stack = ").append(this.max_stack).append(", max_locals = ").append(this.max_locals).append(", code_length = ").append(this.code.length).append(")\n").append(Utility.codeToString(this.code, super.getConstantPool(), 0, -1, verbose));
        if (this.exception_table.length > 0) {
            buf.append("\nException handler(s) = \n").append("From\tTo\tHandler\tType\n");
            for (Node node : this.exception_table) {
                buf.append(((CodeException)node).toString(super.getConstantPool(), verbose)).append("\n");
            }
        }
        if (this.attributes.length > 0) {
            buf.append("\nAttribute(s) = ");
            for (Node node : this.attributes) {
                buf.append("\n").append(node);
            }
        }
        return buf.toString();
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return this.toString(true);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool _constant_pool) {
        int i;
        Code c = (Code)this.clone();
        if (this.code != null) {
            c.code = new byte[this.code.length];
            System.arraycopy(this.code, 0, c.code, 0, this.code.length);
        }
        c.setConstantPool(_constant_pool);
        c.exception_table = new CodeException[this.exception_table.length];
        for (i = 0; i < this.exception_table.length; ++i) {
            c.exception_table[i] = this.exception_table[i].copy();
        }
        c.attributes = new Attribute[this.attributes.length];
        for (i = 0; i < this.attributes.length; ++i) {
            c.attributes[i] = this.attributes[i].copy(_constant_pool);
        }
        return c;
    }
}

