/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.AnnotationDefault;
import afu.org.apache.commons.bcel6.classfile.AnnotationEntry;
import afu.org.apache.commons.bcel6.classfile.Annotations;
import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.BootstrapMethods;
import afu.org.apache.commons.bcel6.classfile.Code;
import afu.org.apache.commons.bcel6.classfile.CodeException;
import afu.org.apache.commons.bcel6.classfile.Constant;
import afu.org.apache.commons.bcel6.classfile.ConstantClass;
import afu.org.apache.commons.bcel6.classfile.ConstantDouble;
import afu.org.apache.commons.bcel6.classfile.ConstantFieldref;
import afu.org.apache.commons.bcel6.classfile.ConstantFloat;
import afu.org.apache.commons.bcel6.classfile.ConstantInteger;
import afu.org.apache.commons.bcel6.classfile.ConstantInterfaceMethodref;
import afu.org.apache.commons.bcel6.classfile.ConstantInvokeDynamic;
import afu.org.apache.commons.bcel6.classfile.ConstantLong;
import afu.org.apache.commons.bcel6.classfile.ConstantMethodHandle;
import afu.org.apache.commons.bcel6.classfile.ConstantMethodType;
import afu.org.apache.commons.bcel6.classfile.ConstantMethodref;
import afu.org.apache.commons.bcel6.classfile.ConstantNameAndType;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantString;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.ConstantValue;
import afu.org.apache.commons.bcel6.classfile.Deprecated;
import afu.org.apache.commons.bcel6.classfile.EnclosingMethod;
import afu.org.apache.commons.bcel6.classfile.ExceptionTable;
import afu.org.apache.commons.bcel6.classfile.Field;
import afu.org.apache.commons.bcel6.classfile.InnerClass;
import afu.org.apache.commons.bcel6.classfile.InnerClasses;
import afu.org.apache.commons.bcel6.classfile.JavaClass;
import afu.org.apache.commons.bcel6.classfile.LineNumber;
import afu.org.apache.commons.bcel6.classfile.LineNumberTable;
import afu.org.apache.commons.bcel6.classfile.LocalVariable;
import afu.org.apache.commons.bcel6.classfile.LocalVariableTable;
import afu.org.apache.commons.bcel6.classfile.LocalVariableTypeTable;
import afu.org.apache.commons.bcel6.classfile.Method;
import afu.org.apache.commons.bcel6.classfile.MethodParameters;
import afu.org.apache.commons.bcel6.classfile.ParameterAnnotationEntry;
import afu.org.apache.commons.bcel6.classfile.ParameterAnnotations;
import afu.org.apache.commons.bcel6.classfile.Signature;
import afu.org.apache.commons.bcel6.classfile.SourceFile;
import afu.org.apache.commons.bcel6.classfile.StackMap;
import afu.org.apache.commons.bcel6.classfile.StackMapEntry;
import afu.org.apache.commons.bcel6.classfile.Synthetic;
import afu.org.apache.commons.bcel6.classfile.Unknown;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.util.Stack;

public class DescendingVisitor
implements Visitor {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass clazz;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor visitor;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Stack<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object> stack = new Stack();

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object predecessor() {
        return this.predecessor(0);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object predecessor(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int level) {
        int size = this.stack.size();
        if (size < 2 || level < 0) {
            return null;
        }
        return this.stack.elementAt(size - (level + 2));
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object current() {
        return this.stack.peek();
    }

    public DescendingVisitor(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass clazz, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor visitor) {
        this.clazz = clazz;
        this.visitor = visitor;
    }

    public void visit() {
        this.clazz.accept(this);
    }

    @Override
    public void visitJavaClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass _clazz) {
        Attribute[] attributes;
        Method[] methods;
        Field[] fields;
        this.stack.push(_clazz);
        _clazz.accept(this.visitor);
        for (Field field : fields = _clazz.getFields()) {
            field.accept(this);
        }
        for (Method method : methods = _clazz.getMethods()) {
            method.accept(this);
        }
        for (Attribute attribute : attributes = _clazz.getAttributes()) {
            attribute.accept(this);
        }
        _clazz.getConstantPool().accept(this);
        this.stack.pop();
    }

    @Override
    public void visitAnnotation(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Annotations annotation) {
        AnnotationEntry[] entries;
        this.stack.push(annotation);
        annotation.accept(this.visitor);
        for (AnnotationEntry entrie : entries = annotation.getAnnotationEntries()) {
            entrie.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitAnnotationEntry(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntry annotationEntry) {
        this.stack.push(annotationEntry);
        annotationEntry.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitField(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Field field) {
        Attribute[] attributes;
        this.stack.push(field);
        field.accept(this.visitor);
        for (Attribute attribute : attributes = field.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitConstantValue(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantValue cv) {
        this.stack.push(cv);
        cv.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Method method) {
        Attribute[] attributes;
        this.stack.push(method);
        method.accept(this.visitor);
        for (Attribute attribute : attributes = method.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitExceptionTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ExceptionTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Code code) {
        Attribute[] attributes;
        CodeException[] table;
        this.stack.push(code);
        code.accept(this.visitor);
        for (CodeException element : table = code.getExceptionTable()) {
            element.accept(this);
        }
        for (Attribute attribute : attributes = code.getAttributes()) {
            attribute.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitCodeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CodeException ce) {
        this.stack.push(ce);
        ce.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLineNumberTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LineNumberTable table) {
        LineNumber[] numbers;
        this.stack.push(table);
        table.accept(this.visitor);
        for (LineNumber number : numbers = table.getLineNumberTable()) {
            number.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitLineNumber(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LineNumber number) {
        this.stack.push(number);
        number.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariableTable table) {
        LocalVariable[] vars;
        this.stack.push(table);
        table.accept(this.visitor);
        for (LocalVariable var : vars = table.getLocalVariableTable()) {
            var.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitStackMap(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StackMap table) {
        StackMapEntry[] vars;
        this.stack.push(table);
        table.accept(this.visitor);
        for (StackMapEntry var : vars = table.getStackMap()) {
            var.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitStackMapEntry(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StackMapEntry var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cp) {
        this.stack.push(cp);
        cp.accept(this.visitor);
        Constant[] constants = cp.getConstantPool();
        for (int i = 1; i < constants.length; ++i) {
            if (constants[i] == null) continue;
            constants[i].accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitConstantClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantClass constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantDouble(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantDouble constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFieldref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantFieldref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFloat(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantFloat constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInteger(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantInteger constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInterfaceMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantInterfaceMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInvokeDynamic(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantInvokeDynamic constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantLong(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantLong constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodref(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantNameAndType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantNameAndType constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantString constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantUtf8(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantUtf8 constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitInnerClasses(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InnerClasses ic) {
        InnerClass[] ics;
        this.stack.push(ic);
        ic.accept(this.visitor);
        for (InnerClass ic2 : ics = ic.getInnerClasses()) {
            ic2.accept(this);
        }
        this.stack.pop();
    }

    @Override
    public void visitInnerClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InnerClass inner) {
        this.stack.push(inner);
        inner.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitBootstrapMethods(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BootstrapMethods bm) {
        this.stack.push(bm);
        bm.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitDeprecated(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Deprecated attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Signature attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSourceFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SourceFile attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSynthetic(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Synthetic attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitUnknown(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Unknown attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitAnnotationDefault(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationDefault obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitEnclosingMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString EnclosingMethod obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTypeTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariableTypeTable obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotation(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ParameterAnnotations obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethodParameters(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MethodParameters obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantMethodType obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodHandle(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantMethodHandle obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotationEntry(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ParameterAnnotationEntry obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }
}

