/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.Node;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class InnerClass
implements Cloneable,
Node {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int inner_class_index;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int outer_class_index;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int inner_name_index;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int inner_access_flags;

    public InnerClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InnerClass c) {
        this(c.getInnerClassIndex(), c.getOuterClassIndex(), c.getInnerNameIndex(), c.getInnerAccessFlags());
    }

    InnerClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort(), file.readUnsignedShort());
    }

    public InnerClass(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int inner_class_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int outer_class_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int inner_name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int inner_access_flags) {
        this.inner_class_index = inner_class_index;
        this.outer_class_index = outer_class_index;
        this.inner_name_index = inner_name_index;
        this.inner_access_flags = inner_access_flags;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitInnerClass(this);
    }

    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeShort(this.inner_class_index);
        file.writeShort(this.outer_class_index);
        file.writeShort(this.inner_name_index);
        file.writeShort(this.inner_access_flags);
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getInnerAccessFlags() {
        return this.inner_access_flags;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getInnerClassIndex() {
        return this.inner_class_index;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getInnerNameIndex() {
        return this.inner_name_index;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getOuterClassIndex() {
        return this.outer_class_index;
    }

    public final void setInnerAccessFlags(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int inner_access_flags) {
        this.inner_access_flags = inner_access_flags;
    }

    public final void setInnerClassIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int inner_class_index) {
        this.inner_class_index = inner_class_index;
    }

    public final void setInnerNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int inner_name_index) {
        this.inner_name_index = inner_name_index;
    }

    public final void setOuterClassIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int outer_class_index) {
        this.outer_class_index = outer_class_index;
    }

    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return "InnerClass(" + this.inner_class_index + ", " + this.outer_class_index + ", " + this.inner_name_index + ", " + this.inner_access_flags + ")";
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        String outer_class_name;
        String inner_class_name = constant_pool.getConstantString(this.inner_class_index, (byte)7);
        inner_class_name = Utility.compactClassName(inner_class_name);
        if (this.outer_class_index != 0) {
            outer_class_name = constant_pool.getConstantString(this.outer_class_index, (byte)7);
            outer_class_name = " of class " + Utility.compactClassName(outer_class_name);
        } else {
            outer_class_name = "";
        }
        String inner_name = this.inner_name_index != 0 ? ((ConstantUtf8)constant_pool.getConstant(this.inner_name_index, (byte)1)).getBytes() : "(anonymous)";
        String access = Utility.accessToString(this.inner_access_flags, true);
        access = access.equals("") ? "" : access + " ";
        return "  " + access + inner_name + "=class " + inner_class_name + outer_class_name;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InnerClass copy() {
        try {
            return (InnerClass)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

