/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.AccessFlags;
import afu.org.apache.commons.bcel6.classfile.AnnotationEntry;
import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.Field;
import afu.org.apache.commons.bcel6.classfile.InnerClass;
import afu.org.apache.commons.bcel6.classfile.InnerClasses;
import afu.org.apache.commons.bcel6.classfile.Method;
import afu.org.apache.commons.bcel6.classfile.Node;
import afu.org.apache.commons.bcel6.classfile.SourceFile;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.util.BCELComparator;
import afu.org.apache.commons.bcel6.util.ClassQueue;
import afu.org.apache.commons.bcel6.util.Repository;
import afu.org.apache.commons.bcel6.util.SyntheticRepository;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.Pure;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class JavaClass
extends AccessFlags
implements Cloneable,
Node,
Comparable<JavaClass> {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String file_name;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String package_name;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String source_file_name = "<Unknown>";
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int class_name_index;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int superclass_name_index;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String class_name;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String superclass_name;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int major;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int minor;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] interfaces;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] interface_names;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Field @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] fields;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] methods;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] attributes;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] annotations;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte source = 1;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isAnonymous = false;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isNested = false;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean computedNestedTypeStatus = false;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte HEAP = 1;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte FILE = 2;
    public static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte ZIP = 3;
    private static final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean debug = Boolean.getBoolean("JavaClass.debug");
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BCELComparator _cmp = new BCELComparator(){

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o1, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o2) {
            JavaClass THIS = (JavaClass)o1;
            JavaClass THAT = (JavaClass)o2;
            return THIS.getClassName().equals(THAT.getClassName());
        }

        @Override
        public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object o) {
            JavaClass THIS = (JavaClass)o;
            return THIS.getClassName().hashCode();
        }
    };
    private transient @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Repository repository = SyntheticRepository.getInstance();

    public JavaClass(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int class_name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int superclass_name_index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String file_name, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int major, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int minor, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int access_flags, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] interfaces, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Field @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] fields, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] methods, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] attributes, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte source) {
        super(access_flags);
        if (interfaces == null) {
            interfaces = new int[]{};
        }
        if (attributes == null) {
            attributes = new Attribute[]{};
        }
        if (fields == null) {
            fields = new Field[]{};
        }
        if (methods == null) {
            methods = new Method[]{};
        }
        this.class_name_index = class_name_index;
        this.superclass_name_index = superclass_name_index;
        this.file_name = file_name;
        this.major = major;
        this.minor = minor;
        this.constant_pool = constant_pool;
        this.interfaces = interfaces;
        this.fields = fields;
        this.methods = methods;
        this.attributes = attributes;
        this.source = source;
        for (Attribute attribute : attributes) {
            if (!(attribute instanceof SourceFile)) continue;
            this.source_file_name = ((SourceFile)attribute).getSourceFileName();
            break;
        }
        this.class_name = constant_pool.getConstantString(class_name_index, (byte)7);
        this.class_name = Utility.compactClassName(this.class_name, false);
        int index = this.class_name.lastIndexOf(46);
        this.package_name = index < 0 ? "" : this.class_name.substring(0, index);
        if (superclass_name_index > 0) {
            this.superclass_name = constant_pool.getConstantString(superclass_name_index, (byte)7);
            this.superclass_name = Utility.compactClassName(this.superclass_name, false);
        } else {
            this.superclass_name = "java.lang.Object";
        }
        this.interface_names = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            String str = constant_pool.getConstantString(interfaces[i], (byte)7);
            this.interface_names[i] = Utility.compactClassName(str, false);
        }
    }

    public JavaClass(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int class_name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int superclass_name_index, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String file_name, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int major, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int minor, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int access_flags, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] interfaces, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Field @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] fields, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] methods, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] attributes) {
        this(class_name_index, superclass_name_index, file_name, major, minor, access_flags, constant_pool, interfaces, fields, methods, attributes, 1);
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitJavaClass(this);
    }

    static void Debug(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String str) {
        if (debug) {
            System.out.println(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString File file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        File dir;
        String parent = file.getParent();
        if (parent != null && !(dir = new File(parent)).mkdirs() && !dir.isDirectory()) {
            throw new IOException("Could not create the directory " + dir);
        }
        try (FilterOutputStream dos = null;){
            dos = new DataOutputStream(new FileOutputStream(file));
            this.dump((DataOutputStream)dos);
        }
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String _file_name) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this.dump(new File(_file_name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getBytes() {
        ByteArrayOutputStream s2 = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(s2);
        try {
            this.dump(ds);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ds.close();
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return s2.toByteArray();
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString OutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this.dump(new DataOutputStream(file));
    }

    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        file.writeInt(-889275714);
        file.writeShort(this.minor);
        file.writeShort(this.major);
        this.constant_pool.dump(file);
        file.writeShort(super.getAccessFlags());
        file.writeShort(this.class_name_index);
        file.writeShort(this.superclass_name_index);
        file.writeShort(this.interfaces.length);
        for (int interface1 : this.interfaces) {
            file.writeShort(interface1);
        }
        file.writeShort(this.fields.length);
        for (Field field : this.fields) {
            field.dump(file);
        }
        file.writeShort(this.methods.length);
        for (Method method : this.methods) {
            method.dump(file);
        }
        if (this.attributes != null) {
            file.writeShort(this.attributes.length);
            for (Attribute attribute : this.attributes) {
                attribute.dump(file);
            }
        } else {
            file.writeShort(0);
        }
        file.flush();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getAttributes() {
        return this.attributes;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AnnotationEntry @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getAnnotationEntries() {
        if (this.annotations == null) {
            this.annotations = AnnotationEntry.createAnnotationEntries(this.getAttributes());
        }
        return this.annotations;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getClassName() {
        return this.class_name;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getPackageName() {
        return this.package_name;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getClassNameIndex() {
        return this.class_name_index;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Field @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getFields() {
        return this.fields;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getFileName() {
        return this.file_name;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getInterfaceNames() {
        return this.interface_names;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getInterfaceIndices() {
        return this.interfaces;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getMajor() {
        return this.major;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getMethods() {
        return this.methods;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Method getMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString java.lang.reflect.Method m3) {
        for (Method method : this.methods) {
            if (!m3.getName().equals(method.getName()) || m3.getModifiers() != method.getModifiers() || !Type.getSignature(m3).equals(method.getSignature())) continue;
            return method;
        }
        return null;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getMinor() {
        return this.minor;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getSourceFileName() {
        return this.source_file_name;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getSuperclassName() {
        return this.superclass_name;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public void setAttributes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] attributes) {
        this.attributes = attributes;
    }

    public void setClassName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String class_name) {
        this.class_name = class_name;
    }

    public void setClassNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int class_name_index) {
        this.class_name_index = class_name_index;
    }

    public void setConstantPool(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        this.constant_pool = constant_pool;
    }

    public void setFields(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Field @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] fields) {
        this.fields = fields;
    }

    public void setFileName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String file_name) {
        this.file_name = file_name;
    }

    public void setInterfaceNames(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] interface_names) {
        this.interface_names = interface_names;
    }

    public void setInterfaces(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] interfaces) {
        this.interfaces = interfaces;
    }

    public void setMajor(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int major) {
        this.major = major;
    }

    public void setMethods(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Method @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] methods) {
        this.methods = methods;
    }

    public void setMinor(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int minor) {
        this.minor = minor;
    }

    public void setSourceFileName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String source_file_name) {
        this.source_file_name = source_file_name;
    }

    public void setSuperclassName(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String superclass_name) {
        this.superclass_name = superclass_name;
    }

    public void setSuperclassNameIndex(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int superclass_name_index) {
        this.superclass_name_index = superclass_name_index;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        AnnotationEntry[] annotations;
        String access = Utility.accessToString(super.getAccessFlags(), true);
        access = access.equals("") ? "" : access + " ";
        StringBuilder buf = new StringBuilder(128);
        buf.append(access).append(Utility.classOrInterface(super.getAccessFlags())).append(" ").append(this.class_name).append(" extends ").append(Utility.compactClassName(this.superclass_name, false)).append('\n');
        int size = this.interfaces.length;
        if (size > 0) {
            buf.append("implements\t\t");
            for (int i = 0; i < size; ++i) {
                buf.append(this.interface_names[i]);
                if (i >= size - 1) continue;
                buf.append(", ");
            }
            buf.append('\n');
        }
        buf.append("filename\t\t").append(this.file_name).append('\n');
        buf.append("compiled from\t\t").append(this.source_file_name).append('\n');
        buf.append("compiler version\t").append(this.major).append(".").append(this.minor).append('\n');
        buf.append("access flags\t\t").append(super.getAccessFlags()).append('\n');
        buf.append("constant pool\t\t").append(this.constant_pool.getLength()).append(" entries\n");
        buf.append("ACC_SUPER flag\t\t").append(this.isSuper()).append("\n");
        if (this.attributes.length > 0) {
            buf.append("\nAttribute(s):\n");
            for (Attribute attribute : this.attributes) {
                buf.append(JavaClass.indent(attribute));
            }
        }
        if ((annotations = this.getAnnotationEntries()) != null && annotations.length > 0) {
            buf.append("\nAnnotation(s):\n");
            for (AnnotationEntry annotation : annotations) {
                buf.append(JavaClass.indent(annotation));
            }
        }
        if (this.fields.length > 0) {
            buf.append("\n").append(this.fields.length).append(" fields:\n");
            for (Field field : this.fields) {
                buf.append("\t").append(field).append('\n');
            }
        }
        if (this.methods.length > 0) {
            buf.append("\n").append(this.methods.length).append(" methods:\n");
            for (Method method : this.methods) {
                buf.append("\t").append(method).append('\n');
            }
        }
        return buf.toString();
    }

    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String indent(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object obj) {
        StringTokenizer tok = new StringTokenizer(obj.toString(), "\n");
        StringBuilder buf = new StringBuilder();
        while (tok.hasMoreTokens()) {
            buf.append("\t").append(tok.nextToken()).append("\n");
        }
        return buf.toString();
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass copy() {
        JavaClass c = null;
        try {
            int i;
            c = (JavaClass)this.clone();
            c.constant_pool = this.constant_pool.copy();
            c.interfaces = (int[])this.interfaces.clone();
            c.interface_names = (String[])this.interface_names.clone();
            c.fields = new Field[this.fields.length];
            for (i = 0; i < this.fields.length; ++i) {
                c.fields[i] = this.fields[i].copy(c.constant_pool);
            }
            c.methods = new Method[this.methods.length];
            for (i = 0; i < this.methods.length; ++i) {
                c.methods[i] = this.methods[i].copy(c.constant_pool);
            }
            c.attributes = new Attribute[this.attributes.length];
            for (i = 0; i < this.attributes.length; ++i) {
                c.attributes[i] = this.attributes[i].copy(c.constant_pool);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return c;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isSuper() {
        return (super.getAccessFlags() & 0x20) != 0;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isClass() {
        return (super.getAccessFlags() & 0x200) == 0;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isAnonymous() {
        this.computeNestedTypeStatus();
        return this.isAnonymous;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean isNested() {
        this.computeNestedTypeStatus();
        return this.isNested;
    }

    private void computeNestedTypeStatus() {
        if (this.computedNestedTypeStatus) {
            return;
        }
        for (Attribute attribute : this.attributes) {
            InnerClass[] innerClasses;
            if (!(attribute instanceof InnerClasses)) continue;
            for (InnerClass innerClasse : innerClasses = ((InnerClasses)attribute).getInnerClasses()) {
                boolean innerClassAttributeRefersToMe = false;
                String inner_class_name = this.constant_pool.getConstantString(innerClasse.getInnerClassIndex(), (byte)7);
                if ((inner_class_name = Utility.compactClassName(inner_class_name)).equals(this.getClassName())) {
                    innerClassAttributeRefersToMe = true;
                }
                if (!innerClassAttributeRefersToMe) continue;
                this.isNested = true;
                if (innerClasse.getInnerNameIndex() != 0) continue;
                this.isAnonymous = true;
            }
        }
        this.computedNestedTypeStatus = true;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte getSource() {
        return this.source;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Repository getRepository() {
        return this.repository;
    }

    public void setRepository(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Repository repository) {
        this.repository = repository;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean instanceOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass super_class) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        JavaClass[] super_classes;
        if (this.equals(super_class)) {
            return true;
        }
        for (JavaClass super_classe : super_classes = this.getSuperClasses()) {
            if (!super_classe.equals(super_class)) continue;
            return true;
        }
        if (super_class.isInterface()) {
            return this.implementationOf(super_class);
        }
        return false;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean implementationOf(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass inter) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        JavaClass[] super_interfaces;
        if (!inter.isInterface()) {
            throw new IllegalArgumentException(inter.getClassName() + " is no interface");
        }
        if (this.equals(inter)) {
            return true;
        }
        for (JavaClass super_interface : super_interfaces = this.getAllInterfaces()) {
            if (!super_interface.equals(inter)) continue;
            return true;
        }
        return false;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass getSuperClass() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        if ("java.lang.Object".equals(this.getClassName())) {
            return null;
        }
        return this.repository.loadClass(this.getSuperclassName());
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getSuperClasses() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        JavaClass clazz = this;
        ArrayList<JavaClass> allSuperClasses = new ArrayList<JavaClass>();
        for (clazz = clazz.getSuperClass(); clazz != null; clazz = clazz.getSuperClass()) {
            allSuperClasses.add(clazz);
        }
        return allSuperClasses.toArray(new JavaClass[allSuperClasses.size()]);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getInterfaces() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        String[] _interfaces = this.getInterfaceNames();
        JavaClass[] classes = new JavaClass[_interfaces.length];
        for (int i = 0; i < _interfaces.length; ++i) {
            classes[i] = this.repository.loadClass(_interfaces[i]);
        }
        return classes;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getAllInterfaces() throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
        ClassQueue queue = new ClassQueue();
        TreeSet<JavaClass> allInterfaces = new TreeSet<JavaClass>();
        queue.enqueue(this);
        while (!queue.empty()) {
            JavaClass clazz = queue.dequeue();
            JavaClass souper = clazz.getSuperClass();
            JavaClass[] _interfaces = clazz.getInterfaces();
            if (clazz.isInterface()) {
                allInterfaces.add(clazz);
            } else if (souper != null) {
                queue.enqueue(souper);
            }
            for (JavaClass _interface : _interfaces) {
                queue.enqueue(_interface);
            }
        }
        return allInterfaces.toArray(new JavaClass[allInterfaces.size()]);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BCELComparator comparator) {
        _cmp = comparator;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object obj) {
        return _cmp.equals(this, obj);
    }

    @Override
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int compareTo(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass obj) {
        return this.getClassName().compareTo(obj.getClassName());
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode() {
        return _cmp.hashCode(this);
    }
}

