/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.LocalVariable;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVariableTable
extends Attribute {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] local_variable_table;

    public LocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariableTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLocalVariableTable(), c.getConstantPool());
    }

    public LocalVariableTable(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] local_variable_table, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        super((byte)5, name_index, length, constant_pool);
        this.local_variable_table = local_variable_table;
    }

    LocalVariableTable(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(name_index, length, (LocalVariable[])null, constant_pool);
        int local_variable_table_length = input.readUnsignedShort();
        this.local_variable_table = new LocalVariable[local_variable_table_length];
        for (int i = 0; i < local_variable_table_length; ++i) {
            this.local_variable_table[i] = new LocalVariable(input, constant_pool);
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitLocalVariableTable(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        super.dump(file);
        file.writeShort(this.local_variable_table.length);
        for (LocalVariable variable : this.local_variable_table) {
            variable.dump(file);
        }
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getLocalVariableTable() {
        return this.local_variable_table;
    }

    @Deprecated
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable getLocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        for (LocalVariable variable : this.local_variable_table) {
            if (variable.getIndex() != index) continue;
            return variable;
        }
        return null;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable getLocalVariable(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int pc) {
        for (LocalVariable variable : this.local_variable_table) {
            if (variable.getIndex() != index) continue;
            int start_pc = variable.getStartPC();
            int end_pc = start_pc + variable.getLength();
            if (pc < start_pc || pc > end_pc) continue;
            return variable;
        }
        return null;
    }

    public final void setLocalVariableTable(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariable @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] local_variable_table) {
        this.local_variable_table = local_variable_table;
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.local_variable_table.length; ++i) {
            buf.append(this.local_variable_table[i]);
            if (i >= this.local_variable_table.length - 1) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool _constant_pool) {
        LocalVariableTable c = (LocalVariableTable)this.clone();
        c.local_variable_table = new LocalVariable[this.local_variable_table.length];
        for (int i = 0; i < this.local_variable_table.length; ++i) {
            c.local_variable_table[i] = this.local_variable_table[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getTableLength() {
        return this.local_variable_table == null ? 0 : this.local_variable_table.length;
    }
}

