/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.classfile;

import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.classfile.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class Unknown
extends Attribute {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] bytes;
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name;
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Unknown> unknown_attributes = new HashMap<String, Unknown>();

    static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Unknown @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getUnknownAttributes() {
        Unknown[] unknowns = new Unknown[unknown_attributes.size()];
        unknown_attributes.values().toArray(unknowns);
        unknown_attributes.clear();
        return unknowns;
    }

    public Unknown(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Unknown c) {
        this(c.getNameIndex(), c.getLength(), c.getBytes(), c.getConstantPool());
    }

    public Unknown(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] bytes, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) {
        super((byte)-1, name_index, length, constant_pool);
        this.bytes = bytes;
        this.name = ((ConstantUtf8)constant_pool.getConstant(name_index, (byte)1)).getBytes();
        unknown_attributes.put(this.name, this);
    }

    Unknown(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int name_index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataInput input, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool constant_pool) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        this(name_index, length, (byte[])null, constant_pool);
        if (length > 0) {
            this.bytes = new byte[length];
            input.readFully(this.bytes);
        }
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitUnknown(this);
    }

    @Override
    public final void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream file) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        super.dump(file);
        if (super.getLength() > 0) {
            file.write(this.bytes, 0, super.getLength());
        }
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getBytes() {
        return this.bytes;
    }

    @Override
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getName() {
        return this.name;
    }

    public final void setBytes(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] bytes) {
        this.bytes = bytes;
    }

    @Override
    @SideEffectFree
    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        String hex;
        if (super.getLength() == 0 || this.bytes == null) {
            return "(Unknown attribute " + this.name + ")";
        }
        if (super.getLength() > 10) {
            byte[] tmp = new byte[10];
            System.arraycopy(this.bytes, 0, tmp, 0, 10);
            hex = Utility.toHexString(tmp) + "... (truncated)";
        } else {
            hex = Utility.toHexString(this.bytes);
        }
        return "(Unknown attribute " + this.name + ": " + hex + ")";
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Attribute copy(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool _constant_pool) {
        Unknown c = (Unknown)this.clone();
        if (this.bytes != null) {
            c.bytes = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, c.bytes, 0, this.bytes.length);
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

