/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.Const;
import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.Pure;

public final class BasicType
extends Type {
    BasicType(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte type) {
        super(type, Const.getShortTypeName(type));
        if (type < 4 || type > 12) {
            throw new ClassGenException("Invalid type: " + type);
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BasicType getType(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte type) {
        switch (type) {
            case 12: {
                return VOID;
            }
            case 4: {
                return BOOLEAN;
            }
            case 8: {
                return BYTE;
            }
            case 9: {
                return SHORT;
            }
            case 5: {
                return CHAR;
            }
            case 10: {
                return INT;
            }
            case 11: {
                return LONG;
            }
            case 7: {
                return DOUBLE;
            }
            case 6: {
                return FLOAT;
            }
        }
        throw new ClassGenException("Invalid type: " + type);
    }

    @Override
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode() {
        return super.getType();
    }

    @Override
    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object _type) {
        return _type instanceof BasicType ? ((BasicType)_type).getType() == this.getType() : false;
    }
}

