/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.classfile.CodeException;
import afu.org.apache.commons.bcel6.generic.BranchInstruction;
import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.InstructionHandle;
import afu.org.apache.commons.bcel6.generic.InstructionTargeter;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;

public final class CodeExceptionGen
implements InstructionTargeter,
Cloneable {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle start_pc;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle end_pc;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle handler_pc;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType catch_type;

    public CodeExceptionGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle start_pc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle end_pc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle handler_pc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType catch_type) {
        this.setStartPC(start_pc);
        this.setEndPC(end_pc);
        this.setHandlerPC(handler_pc);
        this.catch_type = catch_type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CodeException getCodeException(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp) {
        return new CodeException(this.start_pc.getPosition(), this.end_pc.getPosition() + this.end_pc.getInstruction().getLength(), this.handler_pc.getPosition(), this.catch_type == null ? 0 : cp.addClass(this.catch_type));
    }

    public void setStartPC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle start_pc) {
        BranchInstruction.notifyTarget(this.start_pc, start_pc, this);
        this.start_pc = start_pc;
    }

    public void setEndPC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle end_pc) {
        BranchInstruction.notifyTarget(this.end_pc, end_pc, this);
        this.end_pc = end_pc;
    }

    public void setHandlerPC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle handler_pc) {
        BranchInstruction.notifyTarget(this.handler_pc, handler_pc, this);
        this.handler_pc = handler_pc;
    }

    @Override
    public void updateTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle old_ih, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle new_ih) {
        boolean targeted = false;
        if (this.start_pc == old_ih) {
            targeted = true;
            this.setStartPC(new_ih);
        }
        if (this.end_pc == old_ih) {
            targeted = true;
            this.setEndPC(new_ih);
        }
        if (this.handler_pc == old_ih) {
            targeted = true;
            this.setHandlerPC(new_ih);
        }
        if (!targeted) {
            throw new ClassGenException("Not targeting " + old_ih + ", but {" + this.start_pc + ", " + this.end_pc + ", " + this.handler_pc + "}");
        }
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean containsTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle ih) {
        return this.start_pc == ih || this.end_pc == ih || this.handler_pc == ih;
    }

    public void setCatchType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType catch_type) {
        this.catch_type = catch_type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType getCatchType() {
        return this.catch_type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle getStartPC() {
        return this.start_pc;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle getEndPC() {
        return this.end_pc;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle getHandlerPC() {
        return this.handler_pc;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return "CodeExceptionGen(" + this.start_pc + ", " + this.end_pc + ", " + this.handler_pc + ")";
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }
}

