/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.ConstantPushInstruction;
import afu.org.apache.commons.bcel6.generic.Instruction;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.generic.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;

public class FCONST
extends Instruction
implements ConstantPushInstruction {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString float value;

    FCONST() {
    }

    public FCONST(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString float f) {
        super((short)11, (short)1);
        if ((double)f == 0.0) {
            super.setOpcode((short)11);
        } else if ((double)f == 1.0) {
            super.setOpcode((short)12);
        } else if ((double)f == 2.0) {
            super.setOpcode((short)13);
        } else {
            throw new ClassGenException("FCONST can be used only for 0.0, 1.0 and 2.0: " + f);
        }
        this.value = f;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Number getValue() {
        return new Float(this.value);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cp) {
        return Type.FLOAT;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitPushInstruction(this);
        v.visitStackProducer(this);
        v.visitTypedInstruction(this);
        v.visitConstantPushInstruction(this);
        v.visitFCONST(this);
    }
}

