/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.generic.BranchHandle;
import afu.org.apache.commons.bcel6.generic.BranchInstruction;
import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.Instruction;
import afu.org.apache.commons.bcel6.generic.InstructionTargeter;
import afu.org.apache.commons.bcel6.generic.Visitor;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InstructionHandle {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle next;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle prev;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction instruction;
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int i_position = -1;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Set<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionTargeter> targeters;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object> attributes;
    private static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle ih_list = null;

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle getNext() {
        return this.next;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle getPrev() {
        return this.prev;
    }

    public final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction i) {
        if (i == null) {
            throw new ClassGenException("Assigning null to handle");
        }
        if (this.getClass() != BranchHandle.class && i instanceof BranchInstruction) {
            throw new ClassGenException("Assigning branch instruction " + i + " to plain handle");
        }
        if (this.instruction != null) {
            this.instruction.dispose();
        }
        this.instruction = i;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction swapInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction i) {
        Instruction oldInstruction = this.instruction;
        this.instruction = i;
        return oldInstruction;
    }

    protected InstructionHandle(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction i) {
        this.setInstruction(i);
    }

    static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle getInstructionHandle(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction i) {
        if (ih_list == null) {
            return new InstructionHandle(i);
        }
        InstructionHandle ih = ih_list;
        ih_list = ih.next;
        ih.setInstruction(i);
        return ih;
    }

    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int updatePosition(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int offset, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_offset) {
        this.i_position += offset;
        return 0;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getPosition() {
        return this.i_position;
    }

    void setPosition(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int pos) {
        this.i_position = pos;
    }

    protected void addHandle() {
        this.next = ih_list;
        ih_list = this;
    }

    void dispose() {
        this.prev = null;
        this.next = null;
        this.instruction.dispose();
        this.instruction = null;
        this.i_position = -1;
        this.attributes = null;
        this.removeAllTargeters();
        this.addHandle();
    }

    public void removeAllTargeters() {
        if (this.targeters != null) {
            this.targeters.clear();
        }
    }

    public void removeTargeter(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionTargeter t) {
        if (this.targeters != null) {
            this.targeters.remove(t);
        }
    }

    public void addTargeter(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionTargeter t) {
        if (this.targeters == null) {
            this.targeters = new HashSet<InstructionTargeter>();
        }
        this.targeters.add(t);
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean hasTargeters() {
        return this.targeters != null && this.targeters.size() > 0;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionTargeter @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getTargeters() {
        if (!this.hasTargeters()) {
            return new InstructionTargeter[0];
        }
        InstructionTargeter[] t = new InstructionTargeter[this.targeters.size()];
        this.targeters.toArray(t);
        return t;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean verbose) {
        return Utility.format(this.i_position, 4, false, ' ') + ": " + this.instruction.toString(verbose);
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString() {
        return this.toString(true);
    }

    public void addAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object key, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object attr) {
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>(3);
        }
        this.attributes.put(key, attr);
    }

    public void removeAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object key) {
        if (this.attributes != null) {
            this.attributes.remove(key);
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object getAttribute(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object key) {
        if (this.attributes != null) {
            return this.attributes.get(key);
        }
        return null;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Collection<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>(3);
        }
        return this.attributes.values();
    }

    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        this.instruction.accept(v);
    }

    final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle setNext(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle next) {
        this.next = next;
        return next;
    }

    final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle setPrev(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle prev) {
        this.prev = prev;
        return prev;
    }
}

