/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.classfile.LineNumber;
import afu.org.apache.commons.bcel6.generic.BranchInstruction;
import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.InstructionHandle;
import afu.org.apache.commons.bcel6.generic.InstructionTargeter;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;

public class LineNumberGen
implements InstructionTargeter,
Cloneable {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle ih;
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int src_line;

    public LineNumberGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle ih, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int src_line) {
        this.setInstruction(ih);
        this.setSourceLine(src_line);
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean containsTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle ih) {
        return this.ih == ih;
    }

    @Override
    public void updateTarget(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle old_ih, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle new_ih) {
        if (old_ih != this.ih) {
            throw new ClassGenException("Not targeting " + old_ih + ", but " + this.ih + "}");
        }
        this.setInstruction(new_ih);
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LineNumber getLineNumber() {
        return new LineNumber(this.ih.getPosition(), this.src_line);
    }

    public void setInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle ih) {
        if (ih == null) {
            throw new NullPointerException("InstructionHandle may not be null");
        }
        BranchInstruction.notifyTarget(this.ih, ih, this);
        this.ih = ih;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle getInstruction() {
        return this.ih;
    }

    public void setSourceLine(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int src_line) {
        this.src_line = src_line;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getSourceLine() {
        return this.src_line;
    }
}

