/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.ExceptionConst;
import afu.org.apache.commons.bcel6.classfile.ConstantPool;
import afu.org.apache.commons.bcel6.generic.AllocationInstruction;
import afu.org.apache.commons.bcel6.generic.ArrayType;
import afu.org.apache.commons.bcel6.generic.CPInstruction;
import afu.org.apache.commons.bcel6.generic.ClassGenException;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.ExceptionThrower;
import afu.org.apache.commons.bcel6.generic.LoadClass;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.generic.Visitor;
import afu.org.apache.commons.bcel6.util.ByteSequence;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.KeyForBottom;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.Nullable;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.SignatureBottom;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.io.DataOutputStream;
import java.io.IOException;

public class MULTIANEWARRAY
extends CPInstruction
implements LoadClass,
AllocationInstruction,
ExceptionThrower {
    private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short dimensions;

    MULTIANEWARRAY() {
    }

    public MULTIANEWARRAY(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short dimensions) {
        super((short)197, index);
        if (dimensions < 1) {
            throw new ClassGenException("Invalid dimensions value: " + dimensions);
        }
        this.dimensions = dimensions;
        super.setLength(4);
    }

    @Override
    public void dump(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DataOutputStream out) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        out.writeByte(super.getOpcode());
        out.writeShort(super.getIndex());
        out.writeByte(this.dimensions);
    }

    @Override
    protected void initFromFile(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ByteSequence bytes, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean wide) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOException {
        super.initFromFile(bytes, wide);
        this.dimensions = bytes.readByte();
        super.setLength(4);
    }

    public final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString short getDimensions() {
        return this.dimensions;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean verbose) {
        return super.toString(verbose) + " " + super.getIndex() + " " + this.dimensions;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String toString(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPool cp) {
        return super.toString(cp) + " " + this.dimensions;
    }

    @Override
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int consumeStack(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        return this.dimensions;
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Class<@UnknownInterned @Interned @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @UnannotatedString @SignatureBottom ?> @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getExceptions() {
        return ExceptionConst.createExceptions(ExceptionConst.EXCS.EXCS_CLASS_AND_INTERFACE_RESOLUTION, ExceptionConst.ILLEGAL_ACCESS_ERROR, ExceptionConst.NEGATIVE_ARRAY_SIZE_EXCEPTION);
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType getLoadClassType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        Type t = this.getType(cpg);
        if (t instanceof ArrayType) {
            t = ((ArrayType)t).getBasicType();
        }
        return t instanceof ObjectType ? (ObjectType)t : null;
    }

    @Override
    public void accept(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Visitor v) {
        v.visitLoadClass(this);
        v.visitAllocationInstruction(this);
        v.visitExceptionThrower(this);
        v.visitTypedInstruction(this);
        v.visitCPInstruction(this);
        v.visitMULTIANEWARRAY(this);
    }
}

