/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.generic;

import afu.org.apache.commons.bcel6.classfile.ClassFormatException;
import afu.org.apache.commons.bcel6.classfile.Utility;
import afu.org.apache.commons.bcel6.generic.ArrayType;
import afu.org.apache.commons.bcel6.generic.BasicType;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.apache.commons.bcel6.generic.ReferenceType;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.KeyForBottom;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.Nullable;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.BinaryName;
import afu.org.checkerframework.checker.signature.qual.SignatureBottom;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import afu.org.checkerframework.dataflow.qual.Pure;
import afu.org.checkerframework.dataflow.qual.SideEffectFree;
import afu.org.checkerframework.framework.qual.AnnotatedFor;
import java.lang.reflect.Method;
import java.util.ArrayList;

@AnnotatedFor(value={"nullness", "signature"})
public abstract class Type {
    @Deprecated
    protected @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte type;
    @Deprecated
    protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String signature;
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BasicType VOID = new BasicType(12);
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BasicType BOOLEAN = new BasicType(4);
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BasicType INT = new BasicType(10);
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BasicType SHORT = new BasicType(9);
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BasicType BYTE = new BasicType(8);
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BasicType LONG = new BasicType(11);
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BasicType DOUBLE = new BasicType(7);
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BasicType FLOAT = new BasicType(6);
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BasicType CHAR = new BasicType(5);
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType OBJECT = new ObjectType("java.lang.Object");
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType CLASS = new ObjectType("java.lang.Class");
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType STRING = new ObjectType("java.lang.String");
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType STRINGBUFFER = new ObjectType("java.lang.StringBuffer");
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType THROWABLE = new ObjectType("java.lang.Throwable");
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] NO_ARGS = new Type[0];
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ReferenceType NULL = new ReferenceType(){};
    public static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type UNKNOWN = new Type(15, "<unknown object>"){};
    private static final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ThreadLocal<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Integer> consumed_chars = new ThreadLocal<Integer>(){

        @Override
        protected @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Integer initialValue() {
            return 0;
        }
    };

    protected Type(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte t, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String s2) {
        this.type = t;
        this.signature = s2;
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int hashCode() {
        return this.type ^ this.signature.hashCode();
    }

    @Pure
    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean equals(@Nullable @UnknownInterned @UnknownKeyFor @Initialized @UnannotatedString Object o) {
        if (o instanceof Type) {
            Type t = (Type)o;
            return this.type == t.type && this.signature.equals(t.signature);
        }
        return false;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getSignature() {
        return this.signature;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString byte getType() {
        return this.type;
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type normalizeForStackOrLocal() {
        if (this == BOOLEAN || this == BYTE || this == SHORT || this == CHAR) {
            return INT;
        }
        return this;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getSize() {
        switch (this.type) {
            case 7: 
            case 11: {
                return 2;
            }
            case 12: {
                return 0;
            }
        }
        return 1;
    }

    @SideEffectFree
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @BinaryName String toString() {
        return this.equals(NULL) || this.type >= 15 ? this.signature : Utility.signatureToString(this.signature, false);
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getMethodSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type return_type, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] arg_types) {
        StringBuilder buf = new StringBuilder("(");
        if (arg_types != null) {
            for (Type arg_type : arg_types) {
                buf.append(arg_type.getSignature());
            }
        }
        buf.append(')');
        buf.append(return_type.getSignature());
        return buf.toString();
    }

    private static @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int unwrap(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ThreadLocal<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Integer> tl) {
        return tl.get();
    }

    private static void wrap(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ThreadLocal<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Integer> tl, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int value) {
        tl.set(value);
    }

    public static @NonNull @UnknownInterned @UnknownKeyFor @Initialized @UnannotatedString Type getType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String signature) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StringIndexOutOfBoundsException {
        byte type = Utility.typeOfSignature(signature);
        if (type <= 12) {
            Type.wrap(consumed_chars, 1);
            return BasicType.getType(type);
        }
        if (type == 13) {
            int dim = 0;
            while (signature.charAt(++dim) == '[') {
            }
            Type t = Type.getType(signature.substring(dim));
            int _temp = Type.unwrap(consumed_chars) + dim;
            Type.wrap(consumed_chars, _temp);
            return new ArrayType(t, dim);
        }
        String parsedSignature = Utility.signatureToString(signature, false);
        Type.wrap(consumed_chars, parsedSignature.length() + 2);
        return ObjectType.getInstance(parsedSignature.replace('/', '.'));
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getReturnType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String signature) {
        try {
            int index = signature.lastIndexOf(41) + 1;
            return Type.getType(signature.substring(index));
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getArgumentTypes(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String signature) {
        ArrayList<Type> vec = new ArrayList<Type>();
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                vec.add(Type.getType(signature.substring(index)));
                index += Type.unwrap(consumed_chars);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
        Type[] types = new Type[vec.size()];
        vec.toArray(types);
        return types;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type getType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Class<@UnknownInterned @Interned @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @UnannotatedString @SignatureBottom ?> cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Class must not be null");
        }
        if (cl.isArray()) {
            return Type.getType(cl.getName());
        }
        if (cl.isPrimitive()) {
            if (cl == Integer.TYPE) {
                return INT;
            }
            if (cl == Void.TYPE) {
                return VOID;
            }
            if (cl == Double.TYPE) {
                return DOUBLE;
            }
            if (cl == Float.TYPE) {
                return FLOAT;
            }
            if (cl == Boolean.TYPE) {
                return BOOLEAN;
            }
            if (cl == Byte.TYPE) {
                return BYTE;
            }
            if (cl == Short.TYPE) {
                return SHORT;
            }
            if (cl == Byte.TYPE) {
                return BYTE;
            }
            if (cl == Long.TYPE) {
                return LONG;
            }
            if (cl == Character.TYPE) {
                return CHAR;
            }
            throw new IllegalStateException("Ooops, what primitive type is " + cl);
        }
        return ObjectType.getInstance(cl.getName());
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getTypes(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Class<@UnknownInterned @Interned @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized @UnannotatedString @SignatureBottom ?> @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] classes) {
        Type[] ret = new Type[classes.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = Type.getType(classes[i]);
        }
        return ret;
    }

    public static @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Method meth) {
        Class<?>[] params;
        StringBuilder sb = new StringBuilder("(");
        for (Class<?> param : params = meth.getParameterTypes()) {
            sb.append(Type.getType(param).getSignature());
        }
        sb.append(")");
        sb.append(Type.getType(meth.getReturnType()).getSignature());
        return sb.toString();
    }

    static @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int size(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int coded) {
        return coded & 3;
    }

    static @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int consumed(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int coded) {
        return coded >> 2;
    }

    static @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int encode(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int size, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int consumed) {
        return consumed << 2 | size;
    }

    static @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getArgumentTypesSize(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String signature) {
        int res = 0;
        try {
            if (signature.charAt(0) != '(') {
                throw new ClassFormatException("Invalid method signature: " + signature);
            }
            int index = 1;
            while (signature.charAt(index) != ')') {
                int coded = Type.getTypeSize(signature.substring(index));
                res += Type.size(coded);
                index += Type.consumed(coded);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ClassFormatException("Invalid method signature: " + signature, e);
        }
        return res;
    }

    static @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getTypeSize(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String signature) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString StringIndexOutOfBoundsException {
        byte type = Utility.typeOfSignature(signature);
        if (type <= 12) {
            return Type.encode(BasicType.getType(type).getSize(), 1);
        }
        if (type == 13) {
            int dim = 0;
            while (signature.charAt(++dim) == '[') {
            }
            int consumed = Type.consumed(Type.getTypeSize(signature.substring(dim)));
            return Type.encode(1, dim + consumed);
        }
        int index = signature.indexOf(59);
        if (index < 0) {
            throw new ClassFormatException("Invalid signature: " + signature);
        }
        return Type.encode(1, index + 1);
    }

    static @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getReturnTypeSize(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String signature) {
        int index = signature.lastIndexOf(41) + 1;
        return Type.size(Type.getTypeSize(signature.substring(index)));
    }

    void setSignature(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String signature) {
        this.signature = signature;
    }
}

