/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.verifier;

import afu.org.apache.commons.bcel6.verifier.Verifier;
import afu.org.apache.commons.bcel6.verifier.VerifierFactory;
import afu.org.apache.commons.bcel6.verifier.VerifierFactoryObserver;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class VerifierFactoryListModel
implements VerifierFactoryObserver,
ListModel<String> {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString List<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ListDataListener> listeners = new ArrayList<ListDataListener>();
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Set<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String> cache = new TreeSet<String>();

    public VerifierFactoryListModel() {
        VerifierFactory.attach(this);
        this.update(null);
    }

    @Override
    public synchronized void update(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String s2) {
        Verifier[] verifiers = VerifierFactory.getVerifiers();
        int num_of_verifiers = verifiers.length;
        this.cache.clear();
        for (Verifier verifier : verifiers) {
            this.cache.add(verifier.getClassName());
        }
        for (ListDataListener listener : this.listeners) {
            ListDataEvent e = new ListDataEvent(this, 0, 0, num_of_verifiers - 1);
            listener.contentsChanged(e);
        }
    }

    @Override
    public synchronized void addListDataListener(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public synchronized void removeListDataListener(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ListDataListener l) {
        this.listeners.remove(l);
    }

    @Override
    public synchronized @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getSize() {
        return this.cache.size();
    }

    @Override
    public synchronized @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String getElementAt(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int index) {
        return this.cache.toArray(new String[this.cache.size()])[index];
    }
}

