/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.verifier.statics;

import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.verifier.exc.AssertionViolatedException;
import afu.org.apache.commons.bcel6.verifier.exc.LocalVariableInfoInconsistentException;
import afu.org.apache.commons.bcel6.verifier.statics.DOUBLE_Upper;
import afu.org.apache.commons.bcel6.verifier.statics.LONG_Upper;
import afu.org.apache.commons.bcel6.verifier.statics.LocalVariableInfo;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;

public class LocalVariablesInfo {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariableInfo @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] localVariableInfos;

    LocalVariablesInfo(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_locals) {
        this.localVariableInfos = new LocalVariableInfo[max_locals];
        for (int i = 0; i < max_locals; ++i) {
            this.localVariableInfos[i] = new LocalVariableInfo();
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariableInfo getLocalVariableInfo(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int slot) {
        if (slot < 0 || slot >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        return this.localVariableInfos[slot];
    }

    public void add(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int slot, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String name, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int startpc, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int length, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Type t) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariableInfoInconsistentException {
        if (slot < 0 || slot >= this.localVariableInfos.length) {
            throw new AssertionViolatedException("Slot number for local variable information out of range.");
        }
        this.localVariableInfos[slot].add(name, startpc, length, t);
        if (t == Type.LONG) {
            this.localVariableInfos[slot + 1].add(name, startpc, length, LONG_Upper.theInstance());
        }
        if (t == Type.DOUBLE) {
            this.localVariableInfos[slot + 1].add(name, startpc, length, DOUBLE_Upper.theInstance());
        }
    }
}

