/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.verifier.statics;

import afu.org.apache.commons.bcel6.Repository;
import afu.org.apache.commons.bcel6.classfile.AccessFlags;
import afu.org.apache.commons.bcel6.classfile.Attribute;
import afu.org.apache.commons.bcel6.classfile.Code;
import afu.org.apache.commons.bcel6.classfile.CodeException;
import afu.org.apache.commons.bcel6.classfile.Constant;
import afu.org.apache.commons.bcel6.classfile.ConstantClass;
import afu.org.apache.commons.bcel6.classfile.ConstantDouble;
import afu.org.apache.commons.bcel6.classfile.ConstantFieldref;
import afu.org.apache.commons.bcel6.classfile.ConstantFloat;
import afu.org.apache.commons.bcel6.classfile.ConstantInteger;
import afu.org.apache.commons.bcel6.classfile.ConstantInterfaceMethodref;
import afu.org.apache.commons.bcel6.classfile.ConstantLong;
import afu.org.apache.commons.bcel6.classfile.ConstantMethodref;
import afu.org.apache.commons.bcel6.classfile.ConstantNameAndType;
import afu.org.apache.commons.bcel6.classfile.ConstantString;
import afu.org.apache.commons.bcel6.classfile.ConstantUtf8;
import afu.org.apache.commons.bcel6.classfile.Field;
import afu.org.apache.commons.bcel6.classfile.FieldOrMethod;
import afu.org.apache.commons.bcel6.classfile.JavaClass;
import afu.org.apache.commons.bcel6.classfile.LineNumber;
import afu.org.apache.commons.bcel6.classfile.LineNumberTable;
import afu.org.apache.commons.bcel6.classfile.LocalVariable;
import afu.org.apache.commons.bcel6.classfile.LocalVariableTable;
import afu.org.apache.commons.bcel6.classfile.Method;
import afu.org.apache.commons.bcel6.generic.ALOAD;
import afu.org.apache.commons.bcel6.generic.ANEWARRAY;
import afu.org.apache.commons.bcel6.generic.ASTORE;
import afu.org.apache.commons.bcel6.generic.ATHROW;
import afu.org.apache.commons.bcel6.generic.ArrayType;
import afu.org.apache.commons.bcel6.generic.BREAKPOINT;
import afu.org.apache.commons.bcel6.generic.CHECKCAST;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.DLOAD;
import afu.org.apache.commons.bcel6.generic.DSTORE;
import afu.org.apache.commons.bcel6.generic.EmptyVisitor;
import afu.org.apache.commons.bcel6.generic.FLOAD;
import afu.org.apache.commons.bcel6.generic.FSTORE;
import afu.org.apache.commons.bcel6.generic.FieldInstruction;
import afu.org.apache.commons.bcel6.generic.GETSTATIC;
import afu.org.apache.commons.bcel6.generic.GotoInstruction;
import afu.org.apache.commons.bcel6.generic.IINC;
import afu.org.apache.commons.bcel6.generic.ILOAD;
import afu.org.apache.commons.bcel6.generic.IMPDEP1;
import afu.org.apache.commons.bcel6.generic.IMPDEP2;
import afu.org.apache.commons.bcel6.generic.INSTANCEOF;
import afu.org.apache.commons.bcel6.generic.INVOKEDYNAMIC;
import afu.org.apache.commons.bcel6.generic.INVOKEINTERFACE;
import afu.org.apache.commons.bcel6.generic.INVOKESPECIAL;
import afu.org.apache.commons.bcel6.generic.INVOKESTATIC;
import afu.org.apache.commons.bcel6.generic.INVOKEVIRTUAL;
import afu.org.apache.commons.bcel6.generic.ISTORE;
import afu.org.apache.commons.bcel6.generic.Instruction;
import afu.org.apache.commons.bcel6.generic.InstructionHandle;
import afu.org.apache.commons.bcel6.generic.InstructionList;
import afu.org.apache.commons.bcel6.generic.InvokeInstruction;
import afu.org.apache.commons.bcel6.generic.JsrInstruction;
import afu.org.apache.commons.bcel6.generic.LDC;
import afu.org.apache.commons.bcel6.generic.LDC2_W;
import afu.org.apache.commons.bcel6.generic.LLOAD;
import afu.org.apache.commons.bcel6.generic.LOOKUPSWITCH;
import afu.org.apache.commons.bcel6.generic.LSTORE;
import afu.org.apache.commons.bcel6.generic.LoadClass;
import afu.org.apache.commons.bcel6.generic.MULTIANEWARRAY;
import afu.org.apache.commons.bcel6.generic.NEW;
import afu.org.apache.commons.bcel6.generic.NEWARRAY;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.apache.commons.bcel6.generic.PUTSTATIC;
import afu.org.apache.commons.bcel6.generic.RET;
import afu.org.apache.commons.bcel6.generic.ReferenceType;
import afu.org.apache.commons.bcel6.generic.ReturnInstruction;
import afu.org.apache.commons.bcel6.generic.TABLESWITCH;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.verifier.PassVerifier;
import afu.org.apache.commons.bcel6.verifier.VerificationResult;
import afu.org.apache.commons.bcel6.verifier.Verifier;
import afu.org.apache.commons.bcel6.verifier.VerifierFactory;
import afu.org.apache.commons.bcel6.verifier.exc.AssertionViolatedException;
import afu.org.apache.commons.bcel6.verifier.exc.ClassConstraintException;
import afu.org.apache.commons.bcel6.verifier.exc.InvalidMethodException;
import afu.org.apache.commons.bcel6.verifier.exc.StaticCodeConstraintException;
import afu.org.apache.commons.bcel6.verifier.exc.StaticCodeInstructionConstraintException;
import afu.org.apache.commons.bcel6.verifier.exc.StaticCodeInstructionOperandConstraintException;
import afu.org.apache.commons.bcel6.verifier.statics.IntList;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.Interned;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;

public final class Pass3aVerifier
extends PassVerifier {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Verifier myOwner;
    private final @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int method_no;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionList instructionList;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Code code;

    public Pass3aVerifier(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Verifier owner, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int method_no) {
        this.myOwner = owner;
        this.method_no = method_no;
    }

    @Override
    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString VerificationResult do_verify() {
        try {
            if (this.myOwner.doPass2().equals(VerificationResult.VR_OK)) {
                JavaClass jc = Repository.lookupClass(this.myOwner.getClassName());
                Method[] methods = jc.getMethods();
                if (this.method_no >= methods.length) {
                    throw new InvalidMethodException("METHOD DOES NOT EXIST!");
                }
                Method method = methods[this.method_no];
                this.code = method.getCode();
                if (method.isAbstract() || method.isNative()) {
                    return VerificationResult.VR_OK;
                }
                try {
                    this.instructionList = new InstructionList(method.getCode().getCode());
                }
                catch (RuntimeException re) {
                    return new VerificationResult(2, "Bad bytecode in the code array of the Code attribute of method '" + method + "'.");
                }
                this.instructionList.setPositions(true);
                VerificationResult vr = VerificationResult.VR_OK;
                try {
                    this.delayedPass2Checks();
                }
                catch (ClassConstraintException cce) {
                    vr = new VerificationResult(2, cce.getMessage());
                    return vr;
                }
                try {
                    this.pass3StaticInstructionChecks();
                    this.pass3StaticInstructionOperandsChecks();
                }
                catch (StaticCodeConstraintException scce) {
                    vr = new VerificationResult(2, scce.getMessage());
                }
                catch (ClassCastException cce) {
                    vr = new VerificationResult(2, "Class Cast Exception: " + cce.getMessage());
                }
                return vr;
            }
            return VerificationResult.VR_NOTYET;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    private void delayedPass2Checks() {
        CodeException[] exceptionTable;
        int[] instructionPositions = this.instructionList.getInstructionPositions();
        int codeLength = this.code.getCode().length;
        LineNumberTable lnt = this.code.getLineNumberTable();
        if (lnt != null) {
            LineNumber[] lineNumbers = lnt.getLineNumberTable();
            IntList offsets = new IntList();
            LineNumber[] lineNumberArray = lineNumbers;
            int n = lineNumberArray.length;
            block0: for (int i = 0; i < n; ++i) {
                LineNumber lineNumber = lineNumberArray[i];
                for (int instructionPosition : instructionPositions) {
                    int offset = lineNumber.getStartPC();
                    if (instructionPosition != offset) continue;
                    if (offsets.contains(offset)) {
                        this.addMessage("LineNumberTable attribute '" + this.code.getLineNumberTable() + "' refers to the same code offset ('" + offset + "') more than once" + " which is violating the semantics [but is sometimes produced by IBM's 'jikes' compiler].");
                        continue block0;
                    }
                    offsets.add(offset);
                    continue block0;
                }
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LineNumberTable attribute '" + this.code.getLineNumberTable() + "' referring to a code offset ('" + lineNumber.getStartPC() + "') that does not exist.");
            }
        }
        Attribute[] atts = this.code.getAttributes();
        for (Attribute att : atts) {
            LocalVariable[] localVariables;
            if (!(att instanceof LocalVariableTable)) continue;
            LocalVariableTable lvt = (LocalVariableTable)att;
            for (LocalVariable localVariable : localVariables = lvt.getLocalVariableTable()) {
                int startpc = localVariable.getStartPC();
                int length = localVariable.getLength();
                if (!Pass3aVerifier.contains(instructionPositions, startpc)) {
                    throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset ('" + startpc + "') that does not exist.");
                }
                if (Pass3aVerifier.contains(instructionPositions, startpc + length) || startpc + length == codeLength) continue;
                throw new ClassConstraintException("Code attribute '" + this.code + "' has a LocalVariableTable attribute '" + this.code.getLocalVariableTable() + "' referring to a code offset start_pc+length ('" + (startpc + length) + "') that does not exist.");
            }
        }
        for (CodeException element : exceptionTable = this.code.getExceptionTable()) {
            int startpc = element.getStartPC();
            int endpc = element.getEndPC();
            int handlerpc = element.getHandlerPC();
            if (startpc >= endpc) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + element + "' that has its start_pc ('" + startpc + "') not smaller than its end_pc ('" + endpc + "').");
            }
            if (!Pass3aVerifier.contains(instructionPositions, startpc)) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + element + "' that has a non-existant bytecode offset as its start_pc ('" + startpc + "').");
            }
            if (!Pass3aVerifier.contains(instructionPositions, endpc) && endpc != codeLength) {
                throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + element + "' that has a non-existant bytecode offset as its end_pc ('" + startpc + "') [that is also not equal to code_length ('" + codeLength + "')].");
            }
            if (Pass3aVerifier.contains(instructionPositions, handlerpc)) continue;
            throw new ClassConstraintException("Code attribute '" + this.code + "' has an exception_table entry '" + element + "' that has a non-existant bytecode offset as its handler_pc ('" + handlerpc + "').");
        }
    }

    private void pass3StaticInstructionChecks() {
        if (this.code.getCode().length >= 65536) {
            throw new StaticCodeInstructionConstraintException("Code array in code attribute '" + this.code + "' too big: must be smaller than " + 65536 + "65536 bytes.");
        }
        for (InstructionHandle ih = this.instructionList.getStart(); ih != null; ih = ih.getNext()) {
            Instruction i = ih.getInstruction();
            if (i instanceof IMPDEP1) {
                throw new StaticCodeInstructionConstraintException("IMPDEP1 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (i instanceof IMPDEP2) {
                throw new StaticCodeInstructionConstraintException("IMPDEP2 must not be in the code, it is an illegal instruction for _internal_ JVM use!");
            }
            if (!(i instanceof BREAKPOINT)) continue;
            throw new StaticCodeInstructionConstraintException("BREAKPOINT must not be in the code, it is an illegal instruction for _internal_ JVM use!");
        }
        Instruction last = this.instructionList.getEnd().getInstruction();
        if (!(last instanceof ReturnInstruction || last instanceof RET || last instanceof GotoInstruction || last instanceof ATHROW)) {
            throw new StaticCodeInstructionConstraintException("Execution must not fall off the bottom of the code array. This constraint is enforced statically as some existing verifiers do - so it may be a false alarm if the last instruction is not reachable.");
        }
    }

    private void pass3StaticInstructionOperandsChecks() {
        try {
            ConstantPoolGen cpg = new ConstantPoolGen(Repository.lookupClass(this.myOwner.getClassName()).getConstantPool());
            InstOperandConstraintVisitor v = new InstOperandConstraintVisitor(cpg);
            for (InstructionHandle ih = this.instructionList.getStart(); ih != null; ih = ih.getNext()) {
                Instruction i = ih.getInstruction();
                if (i instanceof JsrInstruction) {
                    InstructionHandle target = ((JsrInstruction)i).getTarget();
                    if (target == this.instructionList.getStart()) {
                        throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may have a top-level instruction (such as the very first instruction, which is targeted by instruction '" + ih + "' as its target.");
                    }
                    if (!(target.getInstruction() instanceof ASTORE)) {
                        throw new StaticCodeInstructionOperandConstraintException("Due to JustIce's clear definition of subroutines, no JSR or JSR_W may target anything else than an ASTORE instruction. Instruction '" + ih + "' targets '" + target + "'.");
                    }
                }
                ih.accept(v);
            }
        }
        catch (ClassNotFoundException e) {
            throw new AssertionViolatedException("Missing class: " + e, e);
        }
    }

    private static @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean contains(@Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] ints, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int i) {
        for (int k : ints) {
            if (k != i) continue;
            return true;
        }
        return false;
    }

    public @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int getMethodNo() {
        return this.method_no;
    }

    private class InstOperandConstraintVisitor
    extends EmptyVisitor {
        private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg;

        InstOperandConstraintVisitor(ConstantPoolGen cpg) {
            this.cpg = cpg;
        }

        private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int max_locals() {
            try {
                return Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getCode().getMaxLocals();
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        private void constraintViolated(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction i, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString String message) {
            throw new StaticCodeInstructionOperandConstraintException("Instruction " + i + " constraint violated: " + message);
        }

        private void indexValid(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Instruction i, @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString int idx) {
            if (idx < 0 || idx >= this.cpg.getSize()) {
                this.constraintViolated(i, "Illegal constant pool index '" + idx + "'.");
            }
        }

        @Override
        public void visitLoadClass(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LoadClass o) {
            Verifier v;
            VerificationResult vr;
            ObjectType t = o.getLoadClassType(this.cpg);
            if (t != null && (vr = (v = VerifierFactory.getVerifier(t.getClassName())).doPass1()).getStatus() != 1) {
                this.constraintViolated((Instruction)((Object)o), "Class '" + o.getLoadClassType(this.cpg).getClassName() + "' is referenced, but cannot be loaded: '" + vr + "'.");
            }
        }

        @Override
        public void visitLDC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LDC o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (c instanceof ConstantClass) {
                Pass3aVerifier.this.addMessage("Operand of LDC or LDC_W is CONSTANT_Class '" + c + "' - this is only supported in JDK 1.5 and higher.");
            } else if (!(c instanceof ConstantInteger || c instanceof ConstantFloat || c instanceof ConstantString)) {
                this.constraintViolated(o, "Operand of LDC or LDC_W must be one of CONSTANT_Integer, CONSTANT_Float or CONSTANT_String, but is '" + c + "'.");
            }
        }

        @Override
        public void visitLDC2_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LDC2_W o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantLong) && !(c instanceof ConstantDouble)) {
                this.constraintViolated(o, "Operand of LDC2_W must be CONSTANT_Long or CONSTANT_Double, but is '" + c + "'.");
            }
            try {
                this.indexValid(o, o.getIndex() + 1);
            }
            catch (StaticCodeInstructionOperandConstraintException e) {
                throw new AssertionViolatedException("OOPS: Does not BCEL handle that? LDC2_W operand has a problem.", e);
            }
        }

        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ObjectType getObjectType(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FieldInstruction o) {
            ReferenceType rt = o.getReferenceType(this.cpg);
            if (rt instanceof ObjectType) {
                return (ObjectType)rt;
            }
            this.constraintViolated(o, "expecting ObjectType but got " + rt);
            return null;
        }

        @Override
        public void visitFieldInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FieldInstruction o) {
            try {
                this.indexValid(o, o.getIndex());
                Constant c = this.cpg.getConstant(o.getIndex());
                if (!(c instanceof ConstantFieldref)) {
                    this.constraintViolated(o, "Indexing a constant that's not a CONSTANT_Fieldref but a '" + c + "'.");
                }
                String field_name = o.getFieldName(this.cpg);
                JavaClass jc = Repository.lookupClass(this.getObjectType(o).getClassName());
                Field[] fields = jc.getFields();
                FieldOrMethod f = null;
                for (Field field : fields) {
                    Type o_type;
                    Type f_type;
                    if (!field.getName().equals(field_name) || !(f_type = Type.getType(field.getSignature())).equals(o_type = o.getType(this.cpg))) continue;
                    f = field;
                    break;
                }
                if (f == null) {
                    JavaClass[] superclasses;
                    block3: for (JavaClass superclass : superclasses = jc.getSuperClasses()) {
                        for (Field field : fields = superclass.getFields()) {
                            Type o_type;
                            Type f_type;
                            if (!field.getName().equals(field_name) || !(f_type = Type.getType(field.getSignature())).equals(o_type = o.getType(this.cpg))) continue;
                            f = field;
                            if ((f.getAccessFlags() & 5) != 0) break block3;
                            f = null;
                            break block3;
                        }
                    }
                    if (f == null) {
                        this.constraintViolated(o, "Referenced field '" + field_name + "' does not exist in class '" + jc.getClassName() + "'.");
                    }
                } else {
                    Type.getType(f.getSignature());
                    o.getType(this.cpg);
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        @Override
        public void visitInvokeInstruction(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InvokeInstruction o) {
            Type[] ts;
            Verifier v;
            VerificationResult vr;
            ConstantNameAndType cnat;
            Constant c;
            this.indexValid(o, o.getIndex());
            if (o instanceof INVOKEVIRTUAL || o instanceof INVOKESPECIAL || o instanceof INVOKESTATIC) {
                c = this.cpg.getConstant(o.getIndex());
                if (!(c instanceof ConstantMethodref)) {
                    this.constraintViolated(o, "Indexing a constant that's not a CONSTANT_Methodref but a '" + c + "'.");
                } else {
                    cnat = (ConstantNameAndType)this.cpg.getConstant(((ConstantMethodref)c).getNameAndTypeIndex());
                    ConstantUtf8 cutf8 = (ConstantUtf8)this.cpg.getConstant(cnat.getNameIndex());
                    if (cutf8.getBytes().equals("<init>") && !(o instanceof INVOKESPECIAL)) {
                        this.constraintViolated(o, "Only INVOKESPECIAL is allowed to invoke instance initialization methods.");
                    }
                    if (!cutf8.getBytes().equals("<init>") && cutf8.getBytes().startsWith("<")) {
                        this.constraintViolated(o, "No method with a name beginning with '<' other than the instance initialization methods may be called by the method invocation instructions.");
                    }
                }
            } else {
                String name;
                c = this.cpg.getConstant(o.getIndex());
                if (!(c instanceof ConstantInterfaceMethodref)) {
                    this.constraintViolated(o, "Indexing a constant that's not a CONSTANT_InterfaceMethodref but a '" + c + "'.");
                }
                if ((name = ((ConstantUtf8)this.cpg.getConstant((cnat = (ConstantNameAndType)this.cpg.getConstant(((ConstantInterfaceMethodref)c).getNameAndTypeIndex())).getNameIndex())).getBytes()).equals("<init>")) {
                    this.constraintViolated(o, "Method to invoke must not be '<init>'.");
                }
                if (name.equals("<clinit>")) {
                    this.constraintViolated(o, "Method to invoke must not be '<clinit>'.");
                }
            }
            Type t = o.getReturnType(this.cpg);
            if (t instanceof ArrayType) {
                t = ((ArrayType)t).getBasicType();
            }
            if (t instanceof ObjectType && (vr = (v = VerifierFactory.getVerifier(((ObjectType)t).getClassName())).doPass2()).getStatus() != 1) {
                this.constraintViolated(o, "Return type class/interface could not be verified successfully: '" + vr.getMessage() + "'.");
            }
            for (Type element : ts = o.getArgumentTypes(this.cpg)) {
                Verifier v2;
                VerificationResult vr2;
                t = element;
                if (t instanceof ArrayType) {
                    t = ((ArrayType)t).getBasicType();
                }
                if (!(t instanceof ObjectType) || (vr2 = (v2 = VerifierFactory.getVerifier(((ObjectType)t).getClassName())).doPass2()).getStatus() == 1) continue;
                this.constraintViolated(o, "Argument type class/interface could not be verified successfully: '" + vr2.getMessage() + "'.");
            }
        }

        @Override
        public void visitINSTANCEOF(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INSTANCEOF o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
        }

        @Override
        public void visitCHECKCAST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CHECKCAST o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
        }

        @Override
        public void visitNEW(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString NEW o) {
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            } else {
                ConstantUtf8 cutf8 = (ConstantUtf8)this.cpg.getConstant(((ConstantClass)c).getNameIndex());
                Type t = Type.getType("L" + cutf8.getBytes() + ";");
                if (t instanceof ArrayType) {
                    this.constraintViolated(o, "NEW must not be used to create an array.");
                }
            }
        }

        @Override
        public void visitMULTIANEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MULTIANEWARRAY o) {
            Type t;
            short dimensions2create;
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
            if ((dimensions2create = o.getDimensions()) < 1) {
                this.constraintViolated(o, "Number of dimensions to create must be greater than zero.");
            }
            if ((t = o.getType(this.cpg)) instanceof ArrayType) {
                int dimensions = ((ArrayType)t).getDimensions();
                if (dimensions < dimensions2create) {
                    this.constraintViolated(o, "Not allowed to create array with more dimensions ('" + dimensions2create + "') than the one referenced by the CONSTANT_Class '" + t + "'.");
                }
            } else {
                this.constraintViolated(o, "Expecting a CONSTANT_Class referencing an array type. [Constraint not found in The Java Virtual Machine Specification, Second Edition, 4.8.1]");
            }
        }

        @Override
        public void visitANEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ANEWARRAY o) {
            int dimensions;
            Type t;
            this.indexValid(o, o.getIndex());
            Constant c = this.cpg.getConstant(o.getIndex());
            if (!(c instanceof ConstantClass)) {
                this.constraintViolated(o, "Expecting a CONSTANT_Class operand, but found a '" + c + "'.");
            }
            if ((t = o.getType(this.cpg)) instanceof ArrayType && (dimensions = ((ArrayType)t).getDimensions()) > 255) {
                this.constraintViolated(o, "Not allowed to create an array with more than 255 dimensions; actual: " + dimensions);
            }
        }

        @Override
        public void visitNEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString NEWARRAY o) {
            byte t = o.getTypecode();
            if (t != 4 && t != 5 && t != 6 && t != 7 && t != 8 && t != 9 && t != 10 && t != 11) {
                this.constraintViolated(o, "Illegal type code '+t+' for 'atype' operand.");
            }
        }

        @Override
        public void visitILOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ILOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitFLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FLOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ALOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitISTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ISTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitFSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FSTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ASTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitIINC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IINC o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitRET(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString RET o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative.");
            } else {
                int maxminus1 = this.max_locals() - 1;
                if (idx > maxminus1) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-1 '" + maxminus1 + "'.");
                }
            }
        }

        @Override
        public void visitLLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LLOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative." + " [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitDLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DLOAD o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative." + " [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitLSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LSTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative." + " [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitDSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DSTORE o) {
            int idx = o.getIndex();
            if (idx < 0) {
                this.constraintViolated(o, "Index '" + idx + "' must be non-negative." + " [Constraint by JustIce as an analogon to the single-slot xLOAD/xSTORE instructions; may not happen anyway.]");
            } else {
                int maxminus2 = this.max_locals() - 2;
                if (idx > maxminus2) {
                    this.constraintViolated(o, "Index '" + idx + "' must not be greater than max_locals-2 '" + maxminus2 + "'.");
                }
            }
        }

        @Override
        public void visitLOOKUPSWITCH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LOOKUPSWITCH o) {
            int[] matchs = o.getMatchs();
            int max = Integer.MIN_VALUE;
            for (int i = 0; i < matchs.length; ++i) {
                if (matchs[i] == max && i != 0) {
                    this.constraintViolated(o, "Match '" + matchs[i] + "' occurs more than once.");
                }
                if (matchs[i] < max) {
                    this.constraintViolated(o, "Lookup table must be sorted but isn't.");
                    continue;
                }
                max = matchs[i];
            }
        }

        @Override
        public void visitTABLESWITCH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString TABLESWITCH o) {
        }

        @Override
        public void visitPUTSTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString PUTSTATIC o) {
            try {
                String field_name = o.getFieldName(this.cpg);
                JavaClass jc = Repository.lookupClass(this.getObjectType(o).getClassName());
                Field[] fields = jc.getFields();
                AccessFlags f = null;
                for (Field field : fields) {
                    if (!field.getName().equals(field_name)) continue;
                    f = field;
                    break;
                }
                if (f == null) {
                    throw new AssertionViolatedException("Field '" + field_name + "' not found in " + jc.getClassName());
                }
                if (f.isFinal() && !Pass3aVerifier.this.myOwner.getClassName().equals(this.getObjectType(o).getClassName())) {
                    this.constraintViolated(o, "Referenced field '" + f + "' is final and must therefore be declared in the current class '" + Pass3aVerifier.this.myOwner.getClassName() + "' which is not the case: it is declared in '" + o.getReferenceType(this.cpg) + "'.");
                }
                if (!f.isStatic()) {
                    this.constraintViolated(o, "Referenced field '" + f + "' is not static which it should be.");
                }
                String meth_name = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName()).getMethods()[Pass3aVerifier.this.method_no].getName();
                if (!jc.isClass() && !meth_name.equals("<clinit>")) {
                    this.constraintViolated(o, "Interface field '" + f + "' must be set in a '" + "<clinit>" + "' method.");
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        @Override
        public void visitGETSTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString GETSTATIC o) {
            try {
                String field_name = o.getFieldName(this.cpg);
                JavaClass jc = Repository.lookupClass(this.getObjectType(o).getClassName());
                Field[] fields = jc.getFields();
                AccessFlags f = null;
                for (Field field : fields) {
                    if (!field.getName().equals(field_name)) continue;
                    f = field;
                    break;
                }
                if (f == null) {
                    throw new AssertionViolatedException("Field '" + field_name + "' not found in " + jc.getClassName());
                }
                if (!f.isStatic()) {
                    this.constraintViolated(o, "Referenced field '" + f + "' is not static which it should be.");
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        @Override
        public void visitINVOKEDYNAMIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKEDYNAMIC o) {
            throw new RuntimeException("INVOKEDYNAMIC instruction is not supported at this time");
        }

        @Override
        public void visitINVOKEINTERFACE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKEINTERFACE o) {
            try {
                String classname = o.getClassName(this.cpg);
                JavaClass jc = Repository.lookupClass(classname);
                Method m3 = this.getMethodRecursive(jc, o);
                if (m3 == null) {
                    this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' with expected signature '" + o.getSignature(this.cpg) + "' not found in class '" + jc.getClassName() + "'.");
                }
                if (jc.isClass()) {
                    this.constraintViolated(o, "Referenced class '" + jc.getClassName() + "' is a class, but not an interface as expected.");
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Method getMethodRecursive(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass jc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InvokeInstruction invoke) throws @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ClassNotFoundException {
            Method m3 = this.getMethod(jc, invoke);
            if (m3 != null) {
                return m3;
            }
            for (JavaClass superclass : jc.getSuperClasses()) {
                m3 = this.getMethod(superclass, invoke);
                if (m3 == null) continue;
                return m3;
            }
            for (JavaClass superclass : jc.getInterfaces()) {
                m3 = this.getMethod(superclass, invoke);
                if (m3 == null) continue;
                return m3;
            }
            return null;
        }

        private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Method getMethod(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JavaClass jc, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InvokeInstruction invoke) {
            Method[] ms;
            for (Method element : ms = jc.getMethods()) {
                if (!element.getName().equals(invoke.getMethodName(this.cpg)) || !Type.getReturnType(element.getSignature()).equals(invoke.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(element.getSignature()), invoke.getArgumentTypes(this.cpg))) continue;
                return element;
            }
            return null;
        }

        @Override
        public void visitINVOKESPECIAL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKESPECIAL o) {
            try {
                JavaClass current;
                String classname = o.getClassName(this.cpg);
                JavaClass jc = Repository.lookupClass(classname);
                Method m3 = this.getMethodRecursive(jc, o);
                if (m3 == null) {
                    this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' with expected signature '" + o.getSignature(this.cpg) + "' not found in class '" + jc.getClassName() + "'.");
                }
                if ((current = Repository.lookupClass(Pass3aVerifier.this.myOwner.getClassName())).isSuper() && Repository.instanceOf(current, jc) && !current.equals(jc) && !o.getMethodName(this.cpg).equals("<init>")) {
                    int supidx = -1;
                    Method meth = null;
                    while (supidx != 0) {
                        Method[] meths;
                        supidx = current.getSuperclassNameIndex();
                        current = Repository.lookupClass(current.getSuperclassName());
                        for (Method meth2 : meths = current.getMethods()) {
                            if (!meth2.getName().equals(o.getMethodName(this.cpg)) || !Type.getReturnType(meth2.getSignature()).equals(o.getReturnType(this.cpg)) || !this.objarrayequals(Type.getArgumentTypes(meth2.getSignature()), o.getArgumentTypes(this.cpg))) continue;
                            meth = meth2;
                            break;
                        }
                        if (meth == null) continue;
                        break;
                    }
                    if (meth == null) {
                        this.constraintViolated(o, "ACC_SUPER special lookup procedure not successful: method '" + o.getMethodName(this.cpg) + "' with proper signature not declared in superclass hierarchy.");
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        @Override
        public void visitINVOKESTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKESTATIC o) {
            try {
                String classname = o.getClassName(this.cpg);
                JavaClass jc = Repository.lookupClass(classname);
                Method m3 = this.getMethodRecursive(jc, o);
                if (m3 == null) {
                    this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' with expected signature '" + o.getSignature(this.cpg) + "' not found in class '" + jc.getClassName() + "'.");
                } else if (!m3.isStatic()) {
                    this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' has ACC_STATIC unset.");
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        @Override
        public void visitINVOKEVIRTUAL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKEVIRTUAL o) {
            try {
                String classname = o.getClassName(this.cpg);
                JavaClass jc = Repository.lookupClass(classname);
                Method m3 = this.getMethodRecursive(jc, o);
                if (m3 == null) {
                    this.constraintViolated(o, "Referenced method '" + o.getMethodName(this.cpg) + "' with expected signature '" + o.getSignature(this.cpg) + "' not found in class '" + jc.getClassName() + "'.");
                }
                if (!jc.isClass()) {
                    this.constraintViolated(o, "Referenced class '" + jc.getClassName() + "' is an interface, but not a class as expected.");
                }
            }
            catch (ClassNotFoundException e) {
                throw new AssertionViolatedException("Missing class: " + e, e);
            }
        }

        private @Interned @UnknownKeyFor @NonNull @Initialized @UnannotatedString boolean objarrayequals(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] o, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Object @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] p) {
            if (o.length != p.length) {
                return false;
            }
            for (int i = 0; i < o.length; ++i) {
                if (o[i].equals(p[i])) continue;
                return false;
            }
            return true;
        }
    }
}

