/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.verifier.structurals;

import afu.org.apache.commons.bcel6.generic.CodeExceptionGen;
import afu.org.apache.commons.bcel6.generic.InstructionHandle;
import afu.org.apache.commons.bcel6.generic.MethodGen;
import afu.org.apache.commons.bcel6.verifier.structurals.ExceptionHandler;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExceptionHandlers {
    private final @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Map<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle, @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Set<@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ExceptionHandler>> exceptionhandlers = new HashMap<InstructionHandle, Set<ExceptionHandler>>();

    public ExceptionHandlers(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MethodGen mg) {
        CodeExceptionGen[] cegs;
        for (CodeExceptionGen ceg : cegs = mg.getExceptionHandlers()) {
            ExceptionHandler eh = new ExceptionHandler(ceg.getCatchType(), ceg.getHandlerPC());
            for (InstructionHandle ih = ceg.getStartPC(); ih != ceg.getEndPC().getNext(); ih = ih.getNext()) {
                Set<ExceptionHandler> hs = this.exceptionhandlers.get(ih);
                if (hs == null) {
                    hs = new HashSet<ExceptionHandler>();
                    this.exceptionhandlers.put(ih, hs);
                }
                hs.add(eh);
            }
        }
    }

    public @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ExceptionHandler @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString [] getExceptionHandlers(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString InstructionHandle ih) {
        Set<ExceptionHandler> hsSet = this.exceptionhandlers.get(ih);
        if (hsSet == null) {
            return new ExceptionHandler[0];
        }
        return hsSet.toArray(new ExceptionHandler[hsSet.size()]);
    }
}

