/*
 * Decompiled with CFR 0.152.
 */
package afu.org.apache.commons.bcel6.verifier.structurals;

import afu.org.apache.commons.bcel6.classfile.Constant;
import afu.org.apache.commons.bcel6.classfile.ConstantClass;
import afu.org.apache.commons.bcel6.classfile.ConstantDouble;
import afu.org.apache.commons.bcel6.classfile.ConstantFloat;
import afu.org.apache.commons.bcel6.classfile.ConstantInteger;
import afu.org.apache.commons.bcel6.classfile.ConstantLong;
import afu.org.apache.commons.bcel6.classfile.ConstantString;
import afu.org.apache.commons.bcel6.generic.AALOAD;
import afu.org.apache.commons.bcel6.generic.AASTORE;
import afu.org.apache.commons.bcel6.generic.ACONST_NULL;
import afu.org.apache.commons.bcel6.generic.ALOAD;
import afu.org.apache.commons.bcel6.generic.ANEWARRAY;
import afu.org.apache.commons.bcel6.generic.ARETURN;
import afu.org.apache.commons.bcel6.generic.ARRAYLENGTH;
import afu.org.apache.commons.bcel6.generic.ASTORE;
import afu.org.apache.commons.bcel6.generic.ATHROW;
import afu.org.apache.commons.bcel6.generic.ArrayType;
import afu.org.apache.commons.bcel6.generic.BALOAD;
import afu.org.apache.commons.bcel6.generic.BASTORE;
import afu.org.apache.commons.bcel6.generic.BIPUSH;
import afu.org.apache.commons.bcel6.generic.CALOAD;
import afu.org.apache.commons.bcel6.generic.CASTORE;
import afu.org.apache.commons.bcel6.generic.CHECKCAST;
import afu.org.apache.commons.bcel6.generic.ConstantPoolGen;
import afu.org.apache.commons.bcel6.generic.D2F;
import afu.org.apache.commons.bcel6.generic.D2I;
import afu.org.apache.commons.bcel6.generic.D2L;
import afu.org.apache.commons.bcel6.generic.DADD;
import afu.org.apache.commons.bcel6.generic.DALOAD;
import afu.org.apache.commons.bcel6.generic.DASTORE;
import afu.org.apache.commons.bcel6.generic.DCMPG;
import afu.org.apache.commons.bcel6.generic.DCMPL;
import afu.org.apache.commons.bcel6.generic.DCONST;
import afu.org.apache.commons.bcel6.generic.DDIV;
import afu.org.apache.commons.bcel6.generic.DLOAD;
import afu.org.apache.commons.bcel6.generic.DMUL;
import afu.org.apache.commons.bcel6.generic.DNEG;
import afu.org.apache.commons.bcel6.generic.DREM;
import afu.org.apache.commons.bcel6.generic.DRETURN;
import afu.org.apache.commons.bcel6.generic.DSTORE;
import afu.org.apache.commons.bcel6.generic.DSUB;
import afu.org.apache.commons.bcel6.generic.DUP;
import afu.org.apache.commons.bcel6.generic.DUP2;
import afu.org.apache.commons.bcel6.generic.DUP2_X1;
import afu.org.apache.commons.bcel6.generic.DUP2_X2;
import afu.org.apache.commons.bcel6.generic.DUP_X1;
import afu.org.apache.commons.bcel6.generic.DUP_X2;
import afu.org.apache.commons.bcel6.generic.EmptyVisitor;
import afu.org.apache.commons.bcel6.generic.F2D;
import afu.org.apache.commons.bcel6.generic.F2I;
import afu.org.apache.commons.bcel6.generic.F2L;
import afu.org.apache.commons.bcel6.generic.FADD;
import afu.org.apache.commons.bcel6.generic.FALOAD;
import afu.org.apache.commons.bcel6.generic.FASTORE;
import afu.org.apache.commons.bcel6.generic.FCMPG;
import afu.org.apache.commons.bcel6.generic.FCMPL;
import afu.org.apache.commons.bcel6.generic.FCONST;
import afu.org.apache.commons.bcel6.generic.FDIV;
import afu.org.apache.commons.bcel6.generic.FLOAD;
import afu.org.apache.commons.bcel6.generic.FMUL;
import afu.org.apache.commons.bcel6.generic.FNEG;
import afu.org.apache.commons.bcel6.generic.FREM;
import afu.org.apache.commons.bcel6.generic.FRETURN;
import afu.org.apache.commons.bcel6.generic.FSTORE;
import afu.org.apache.commons.bcel6.generic.FSUB;
import afu.org.apache.commons.bcel6.generic.GETFIELD;
import afu.org.apache.commons.bcel6.generic.GETSTATIC;
import afu.org.apache.commons.bcel6.generic.GOTO;
import afu.org.apache.commons.bcel6.generic.GOTO_W;
import afu.org.apache.commons.bcel6.generic.I2B;
import afu.org.apache.commons.bcel6.generic.I2C;
import afu.org.apache.commons.bcel6.generic.I2D;
import afu.org.apache.commons.bcel6.generic.I2F;
import afu.org.apache.commons.bcel6.generic.I2L;
import afu.org.apache.commons.bcel6.generic.I2S;
import afu.org.apache.commons.bcel6.generic.IADD;
import afu.org.apache.commons.bcel6.generic.IALOAD;
import afu.org.apache.commons.bcel6.generic.IAND;
import afu.org.apache.commons.bcel6.generic.IASTORE;
import afu.org.apache.commons.bcel6.generic.ICONST;
import afu.org.apache.commons.bcel6.generic.IDIV;
import afu.org.apache.commons.bcel6.generic.IFEQ;
import afu.org.apache.commons.bcel6.generic.IFGE;
import afu.org.apache.commons.bcel6.generic.IFGT;
import afu.org.apache.commons.bcel6.generic.IFLE;
import afu.org.apache.commons.bcel6.generic.IFLT;
import afu.org.apache.commons.bcel6.generic.IFNE;
import afu.org.apache.commons.bcel6.generic.IFNONNULL;
import afu.org.apache.commons.bcel6.generic.IFNULL;
import afu.org.apache.commons.bcel6.generic.IF_ACMPEQ;
import afu.org.apache.commons.bcel6.generic.IF_ACMPNE;
import afu.org.apache.commons.bcel6.generic.IF_ICMPEQ;
import afu.org.apache.commons.bcel6.generic.IF_ICMPGE;
import afu.org.apache.commons.bcel6.generic.IF_ICMPGT;
import afu.org.apache.commons.bcel6.generic.IF_ICMPLE;
import afu.org.apache.commons.bcel6.generic.IF_ICMPLT;
import afu.org.apache.commons.bcel6.generic.IF_ICMPNE;
import afu.org.apache.commons.bcel6.generic.IINC;
import afu.org.apache.commons.bcel6.generic.ILOAD;
import afu.org.apache.commons.bcel6.generic.IMUL;
import afu.org.apache.commons.bcel6.generic.INEG;
import afu.org.apache.commons.bcel6.generic.INSTANCEOF;
import afu.org.apache.commons.bcel6.generic.INVOKEDYNAMIC;
import afu.org.apache.commons.bcel6.generic.INVOKEINTERFACE;
import afu.org.apache.commons.bcel6.generic.INVOKESPECIAL;
import afu.org.apache.commons.bcel6.generic.INVOKESTATIC;
import afu.org.apache.commons.bcel6.generic.INVOKEVIRTUAL;
import afu.org.apache.commons.bcel6.generic.IOR;
import afu.org.apache.commons.bcel6.generic.IREM;
import afu.org.apache.commons.bcel6.generic.IRETURN;
import afu.org.apache.commons.bcel6.generic.ISHL;
import afu.org.apache.commons.bcel6.generic.ISHR;
import afu.org.apache.commons.bcel6.generic.ISTORE;
import afu.org.apache.commons.bcel6.generic.ISUB;
import afu.org.apache.commons.bcel6.generic.IUSHR;
import afu.org.apache.commons.bcel6.generic.IXOR;
import afu.org.apache.commons.bcel6.generic.JSR;
import afu.org.apache.commons.bcel6.generic.JSR_W;
import afu.org.apache.commons.bcel6.generic.L2D;
import afu.org.apache.commons.bcel6.generic.L2F;
import afu.org.apache.commons.bcel6.generic.L2I;
import afu.org.apache.commons.bcel6.generic.LADD;
import afu.org.apache.commons.bcel6.generic.LALOAD;
import afu.org.apache.commons.bcel6.generic.LAND;
import afu.org.apache.commons.bcel6.generic.LASTORE;
import afu.org.apache.commons.bcel6.generic.LCMP;
import afu.org.apache.commons.bcel6.generic.LCONST;
import afu.org.apache.commons.bcel6.generic.LDC;
import afu.org.apache.commons.bcel6.generic.LDC2_W;
import afu.org.apache.commons.bcel6.generic.LDC_W;
import afu.org.apache.commons.bcel6.generic.LDIV;
import afu.org.apache.commons.bcel6.generic.LLOAD;
import afu.org.apache.commons.bcel6.generic.LMUL;
import afu.org.apache.commons.bcel6.generic.LNEG;
import afu.org.apache.commons.bcel6.generic.LOOKUPSWITCH;
import afu.org.apache.commons.bcel6.generic.LOR;
import afu.org.apache.commons.bcel6.generic.LREM;
import afu.org.apache.commons.bcel6.generic.LRETURN;
import afu.org.apache.commons.bcel6.generic.LSHL;
import afu.org.apache.commons.bcel6.generic.LSHR;
import afu.org.apache.commons.bcel6.generic.LSTORE;
import afu.org.apache.commons.bcel6.generic.LSUB;
import afu.org.apache.commons.bcel6.generic.LUSHR;
import afu.org.apache.commons.bcel6.generic.LXOR;
import afu.org.apache.commons.bcel6.generic.MONITORENTER;
import afu.org.apache.commons.bcel6.generic.MONITOREXIT;
import afu.org.apache.commons.bcel6.generic.MULTIANEWARRAY;
import afu.org.apache.commons.bcel6.generic.NEW;
import afu.org.apache.commons.bcel6.generic.NEWARRAY;
import afu.org.apache.commons.bcel6.generic.NOP;
import afu.org.apache.commons.bcel6.generic.ObjectType;
import afu.org.apache.commons.bcel6.generic.POP;
import afu.org.apache.commons.bcel6.generic.POP2;
import afu.org.apache.commons.bcel6.generic.PUTFIELD;
import afu.org.apache.commons.bcel6.generic.PUTSTATIC;
import afu.org.apache.commons.bcel6.generic.RET;
import afu.org.apache.commons.bcel6.generic.RETURN;
import afu.org.apache.commons.bcel6.generic.ReturnaddressType;
import afu.org.apache.commons.bcel6.generic.SALOAD;
import afu.org.apache.commons.bcel6.generic.SASTORE;
import afu.org.apache.commons.bcel6.generic.SIPUSH;
import afu.org.apache.commons.bcel6.generic.SWAP;
import afu.org.apache.commons.bcel6.generic.TABLESWITCH;
import afu.org.apache.commons.bcel6.generic.Type;
import afu.org.apache.commons.bcel6.verifier.structurals.Frame;
import afu.org.apache.commons.bcel6.verifier.structurals.LocalVariables;
import afu.org.apache.commons.bcel6.verifier.structurals.OperandStack;
import afu.org.apache.commons.bcel6.verifier.structurals.UninitializedObjectType;
import afu.org.checkerframework.checker.initialization.qual.Initialized;
import afu.org.checkerframework.checker.interning.qual.UnknownInterned;
import afu.org.checkerframework.checker.nullness.qual.NonNull;
import afu.org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import afu.org.checkerframework.checker.signature.qual.UnannotatedString;

public class ExecutionVisitor
extends EmptyVisitor {
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Frame frame = null;
    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg = null;

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString OperandStack stack() {
        return this.frame.getStack();
    }

    private @UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LocalVariables locals() {
        return this.frame.getLocals();
    }

    public void setConstantPoolGen(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ConstantPoolGen cpg) {
        this.cpg = cpg;
    }

    public void setFrame(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString Frame f) {
        this.frame = f;
    }

    @Override
    public void visitAALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AALOAD o) {
        this.stack().pop();
        Type t = this.stack().pop();
        if (t == Type.NULL) {
            this.stack().push(Type.NULL);
        } else {
            ArrayType at = (ArrayType)t;
            this.stack().push(at.getElementType());
        }
    }

    @Override
    public void visitAASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString AASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitACONST_NULL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ACONST_NULL o) {
        this.stack().push(Type.NULL);
    }

    @Override
    public void visitALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ALOAD o) {
        this.stack().push(this.locals().get(o.getIndex()));
    }

    @Override
    public void visitANEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ANEWARRAY o) {
        this.stack().pop();
        this.stack().push(new ArrayType(o.getType(this.cpg), 1));
    }

    @Override
    public void visitARETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ARETURN o) {
        this.stack().pop();
    }

    @Override
    public void visitARRAYLENGTH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ARRAYLENGTH o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ASTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
    }

    @Override
    public void visitATHROW(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ATHROW o) {
        Type t = this.stack().pop();
        this.stack().clear();
        if (t.equals(Type.NULL)) {
            this.stack().push(Type.getType("Ljava/lang/NullPointerException;"));
        } else {
            this.stack().push(t);
        }
    }

    @Override
    public void visitBALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitBASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitBIPUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString BIPUSH o) {
        this.stack().push(Type.INT);
    }

    @Override
    public void visitCALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitCASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitCHECKCAST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString CHECKCAST o) {
        this.stack().pop();
        this.stack().push(o.getType(this.cpg));
    }

    @Override
    public void visitD2F(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString D2F o) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitD2I(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString D2I o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitD2L(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString D2L o) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitDADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DADD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitDCMPG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DCMPG o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitDCMPL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DCMPL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitDCONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DCONST o) {
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DDIV o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DLOAD o) {
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DMUL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDNEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DNEG o) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DREM o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DRETURN o) {
        this.stack().pop();
    }

    @Override
    public void visitDSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DSTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
        this.locals().set(o.getIndex() + 1, Type.UNKNOWN);
    }

    @Override
    public void visitDSUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DSUB o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitDUP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DUP o) {
        Type t = this.stack().pop();
        this.stack().push(t);
        this.stack().push(t);
    }

    @Override
    public void visitDUP_X1(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DUP_X1 o) {
        Type w1 = this.stack().pop();
        Type w2 = this.stack().pop();
        this.stack().push(w1);
        this.stack().push(w2);
        this.stack().push(w1);
    }

    @Override
    public void visitDUP_X2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DUP_X2 o) {
        Type w1 = this.stack().pop();
        Type w2 = this.stack().pop();
        if (w2.getSize() == 2) {
            this.stack().push(w1);
            this.stack().push(w2);
            this.stack().push(w1);
        } else {
            Type w3 = this.stack().pop();
            this.stack().push(w1);
            this.stack().push(w3);
            this.stack().push(w2);
            this.stack().push(w1);
        }
    }

    @Override
    public void visitDUP2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DUP2 o) {
        Type t = this.stack().pop();
        if (t.getSize() == 2) {
            this.stack().push(t);
            this.stack().push(t);
        } else {
            Type u = this.stack().pop();
            this.stack().push(u);
            this.stack().push(t);
            this.stack().push(u);
            this.stack().push(t);
        }
    }

    @Override
    public void visitDUP2_X1(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DUP2_X1 o) {
        Type t = this.stack().pop();
        if (t.getSize() == 2) {
            Type u = this.stack().pop();
            this.stack().push(t);
            this.stack().push(u);
            this.stack().push(t);
        } else {
            Type u = this.stack().pop();
            Type v = this.stack().pop();
            this.stack().push(u);
            this.stack().push(t);
            this.stack().push(v);
            this.stack().push(u);
            this.stack().push(t);
        }
    }

    @Override
    public void visitDUP2_X2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString DUP2_X2 o) {
        Type t = this.stack().pop();
        if (t.getSize() == 2) {
            Type u = this.stack().pop();
            if (u.getSize() == 2) {
                this.stack().push(t);
                this.stack().push(u);
                this.stack().push(t);
            } else {
                Type v = this.stack().pop();
                this.stack().push(t);
                this.stack().push(v);
                this.stack().push(u);
                this.stack().push(t);
            }
        } else {
            Type u = this.stack().pop();
            Type v = this.stack().pop();
            if (v.getSize() == 2) {
                this.stack().push(u);
                this.stack().push(t);
                this.stack().push(v);
                this.stack().push(u);
                this.stack().push(t);
            } else {
                Type w = this.stack().pop();
                this.stack().push(u);
                this.stack().push(t);
                this.stack().push(w);
                this.stack().push(v);
                this.stack().push(u);
                this.stack().push(t);
            }
        }
    }

    @Override
    public void visitF2D(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString F2D o) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitF2I(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString F2I o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitF2L(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString F2L o) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitFADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FADD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitFCMPG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FCMPG o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitFCMPL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FCMPL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitFCONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FCONST o) {
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FDIV o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FLOAD o) {
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FMUL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFNEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FNEG o) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FREM o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitFRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FRETURN o) {
        this.stack().pop();
    }

    @Override
    public void visitFSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FSTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
    }

    @Override
    public void visitFSUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString FSUB o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitGETFIELD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString GETFIELD o) {
        this.stack().pop();
        Type t = o.getFieldType(this.cpg);
        if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
            t = Type.INT;
        }
        this.stack().push(t);
    }

    @Override
    public void visitGETSTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString GETSTATIC o) {
        Type t = o.getFieldType(this.cpg);
        if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
            t = Type.INT;
        }
        this.stack().push(t);
    }

    @Override
    public void visitGOTO(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString GOTO o) {
    }

    @Override
    public void visitGOTO_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString GOTO_W o) {
    }

    @Override
    public void visitI2B(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString I2B o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitI2C(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString I2C o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitI2D(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString I2D o) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitI2F(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString I2F o) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitI2L(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString I2L o) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitI2S(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString I2S o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IADD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIAND(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IAND o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitICONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ICONST o) {
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IDIV o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIF_ACMPEQ(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ACMPEQ o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ACMPNE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ACMPNE o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPEQ(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ICMPEQ o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPGE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ICMPGE o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPGT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ICMPGT o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPLE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ICMPLE o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPLT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ICMPLT o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIF_ICMPNE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IF_ICMPNE o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitIFEQ(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFEQ o) {
        this.stack().pop();
    }

    @Override
    public void visitIFGE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFGE o) {
        this.stack().pop();
    }

    @Override
    public void visitIFGT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFGT o) {
        this.stack().pop();
    }

    @Override
    public void visitIFLE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFLE o) {
        this.stack().pop();
    }

    @Override
    public void visitIFLT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFLT o) {
        this.stack().pop();
    }

    @Override
    public void visitIFNE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFNE o) {
        this.stack().pop();
    }

    @Override
    public void visitIFNONNULL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFNONNULL o) {
        this.stack().pop();
    }

    @Override
    public void visitIFNULL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IFNULL o) {
        this.stack().pop();
    }

    @Override
    public void visitIINC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IINC o) {
    }

    @Override
    public void visitILOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ILOAD o) {
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IMUL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitINEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INEG o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitINSTANCEOF(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INSTANCEOF o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitINVOKEDYNAMIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKEDYNAMIC o) {
        for (int i = 0; i < o.getArgumentTypes(this.cpg).length; ++i) {
            this.stack().pop();
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitINVOKEINTERFACE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKEINTERFACE o) {
        this.stack().pop();
        for (int i = 0; i < o.getArgumentTypes(this.cpg).length; ++i) {
            this.stack().pop();
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitINVOKESPECIAL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKESPECIAL o) {
        if (o.getMethodName(this.cpg).equals("<init>")) {
            UninitializedObjectType t = (UninitializedObjectType)this.stack().peek(o.getArgumentTypes(this.cpg).length);
            if (t == Frame.getThis()) {
                Frame.setThis(null);
            }
            this.stack().initializeObject(t);
            this.locals().initializeObject(t);
        }
        this.stack().pop();
        for (int i = 0; i < o.getArgumentTypes(this.cpg).length; ++i) {
            this.stack().pop();
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitINVOKESTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKESTATIC o) {
        for (int i = 0; i < o.getArgumentTypes(this.cpg).length; ++i) {
            this.stack().pop();
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitINVOKEVIRTUAL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString INVOKEVIRTUAL o) {
        this.stack().pop();
        for (int i = 0; i < o.getArgumentTypes(this.cpg).length; ++i) {
            this.stack().pop();
        }
        if (o.getReturnType(this.cpg) != Type.VOID) {
            Type t = o.getReturnType(this.cpg);
            if (t.equals(Type.BOOLEAN) || t.equals(Type.CHAR) || t.equals(Type.BYTE) || t.equals(Type.SHORT)) {
                t = Type.INT;
            }
            this.stack().push(t);
        }
    }

    @Override
    public void visitIOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IOR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IREM o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IRETURN o) {
        this.stack().pop();
    }

    @Override
    public void visitISHL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ISHL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitISHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ISHR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitISTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ISTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
    }

    @Override
    public void visitISUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString ISUB o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIUSHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IUSHR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitIXOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString IXOR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitJSR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JSR o) {
        this.stack().push(new ReturnaddressType(o.physicalSuccessor()));
    }

    @Override
    public void visitJSR_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString JSR_W o) {
        this.stack().push(new ReturnaddressType(o.physicalSuccessor()));
    }

    @Override
    public void visitL2D(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString L2D o) {
        this.stack().pop();
        this.stack().push(Type.DOUBLE);
    }

    @Override
    public void visitL2F(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString L2F o) {
        this.stack().pop();
        this.stack().push(Type.FLOAT);
    }

    @Override
    public void visitL2I(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString L2I o) {
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitLADD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LADD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLAND(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LAND o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitLCMP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LCMP o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitLCONST(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LCONST o) {
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLDC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LDC o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (c instanceof ConstantInteger) {
            this.stack().push(Type.INT);
        }
        if (c instanceof ConstantFloat) {
            this.stack().push(Type.FLOAT);
        }
        if (c instanceof ConstantString) {
            this.stack().push(Type.STRING);
        }
        if (c instanceof ConstantClass) {
            this.stack().push(Type.CLASS);
        }
    }

    public void visitLDC_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LDC_W o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (c instanceof ConstantInteger) {
            this.stack().push(Type.INT);
        }
        if (c instanceof ConstantFloat) {
            this.stack().push(Type.FLOAT);
        }
        if (c instanceof ConstantString) {
            this.stack().push(Type.STRING);
        }
        if (c instanceof ConstantClass) {
            this.stack().push(Type.CLASS);
        }
    }

    @Override
    public void visitLDC2_W(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LDC2_W o) {
        Constant c = this.cpg.getConstant(o.getIndex());
        if (c instanceof ConstantLong) {
            this.stack().push(Type.LONG);
        }
        if (c instanceof ConstantDouble) {
            this.stack().push(Type.DOUBLE);
        }
    }

    @Override
    public void visitLDIV(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LDIV o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLLOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LLOAD o) {
        this.stack().push(this.locals().get(o.getIndex()));
    }

    @Override
    public void visitLMUL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LMUL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLNEG(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LNEG o) {
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLOOKUPSWITCH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LOOKUPSWITCH o) {
        this.stack().pop();
    }

    @Override
    public void visitLOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LOR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLREM(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LREM o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LRETURN o) {
        this.stack().pop();
    }

    @Override
    public void visitLSHL(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LSHL o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLSHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LSHR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLSTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LSTORE o) {
        this.locals().set(o.getIndex(), this.stack().pop());
        this.locals().set(o.getIndex() + 1, Type.UNKNOWN);
    }

    @Override
    public void visitLSUB(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LSUB o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLUSHR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LUSHR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitLXOR(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString LXOR o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.LONG);
    }

    @Override
    public void visitMONITORENTER(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MONITORENTER o) {
        this.stack().pop();
    }

    @Override
    public void visitMONITOREXIT(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MONITOREXIT o) {
        this.stack().pop();
    }

    @Override
    public void visitMULTIANEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString MULTIANEWARRAY o) {
        for (int i = 0; i < o.getDimensions(); ++i) {
            this.stack().pop();
        }
        this.stack().push(o.getType(this.cpg));
    }

    @Override
    public void visitNEW(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString NEW o) {
        this.stack().push(new UninitializedObjectType((ObjectType)o.getType(this.cpg)));
    }

    @Override
    public void visitNEWARRAY(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString NEWARRAY o) {
        this.stack().pop();
        this.stack().push(o.getType());
    }

    @Override
    public void visitNOP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString NOP o) {
    }

    @Override
    public void visitPOP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString POP o) {
        this.stack().pop();
    }

    @Override
    public void visitPOP2(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString POP2 o) {
        Type t = this.stack().pop();
        if (t.getSize() == 1) {
            this.stack().pop();
        }
    }

    @Override
    public void visitPUTFIELD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString PUTFIELD o) {
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitPUTSTATIC(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString PUTSTATIC o) {
        this.stack().pop();
    }

    @Override
    public void visitRET(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString RET o) {
    }

    @Override
    public void visitRETURN(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString RETURN o) {
    }

    @Override
    public void visitSALOAD(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SALOAD o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().push(Type.INT);
    }

    @Override
    public void visitSASTORE(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SASTORE o) {
        this.stack().pop();
        this.stack().pop();
        this.stack().pop();
    }

    @Override
    public void visitSIPUSH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SIPUSH o) {
        this.stack().push(Type.INT);
    }

    @Override
    public void visitSWAP(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString SWAP o) {
        Type t = this.stack().pop();
        Type u = this.stack().pop();
        this.stack().push(t);
        this.stack().push(u);
    }

    @Override
    public void visitTABLESWITCH(@UnknownInterned @UnknownKeyFor @NonNull @Initialized @UnannotatedString TABLESWITCH o) {
        this.stack().pop();
    }
}

