/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.internal.fs;

import afu.org.tmatesoft.sqljet.core.internal.fs.SqlJetFileLockManager;
import java.io.IOException;
import java.nio.channels.FileLock;

public class SqlJetFileLock
extends FileLock {
    private final SqlJetFileLockManager manager;
    private final FileLock fileLock;
    private long locksCount;

    public SqlJetFileLock(SqlJetFileLockManager manager, FileLock fileLock) {
        super(fileLock.channel(), fileLock.position(), fileLock.size(), fileLock.isShared());
        this.manager = manager;
        this.fileLock = fileLock;
        this.locksCount = 1L;
    }

    public boolean isValid() {
        return this.fileLock.isValid();
    }

    public void release() throws IOException {
        --this.locksCount;
        if (this.locksCount == 0L) {
            if (this.fileLock.isValid()) {
                this.fileLock.release();
            }
            this.manager.deleteLock(this);
        }
    }

    public void addLock() {
        ++this.locksCount;
    }
}

