/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.internal.schema;

import afu.org.antlr.runtime.tree.CommonTree;
import afu.org.tmatesoft.sqljet.core.internal.schema.SqlJetForeignKeyDeferrable;
import afu.org.tmatesoft.sqljet.core.internal.schema.SqlJetForeignKeyMatchAction;
import afu.org.tmatesoft.sqljet.core.internal.schema.SqlJetForeignKeyUpdateAction;
import afu.org.tmatesoft.sqljet.core.schema.ISqlJetForeignKey;
import afu.org.tmatesoft.sqljet.core.schema.ISqlJetForeignKeyAction;
import afu.org.tmatesoft.sqljet.core.schema.ISqlJetForeignKeyDeferrable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetForeignKey
implements ISqlJetForeignKey {
    private final String foreignTableName;
    private final List<String> columnNames;
    private final List<ISqlJetForeignKeyAction> actions;
    private final ISqlJetForeignKeyDeferrable deferrable;

    public SqlJetForeignKey(CommonTree ast) {
        assert ("references".equalsIgnoreCase(ast.getText()));
        this.foreignTableName = ast.getChild(0).getText();
        CommonTree columnsNode = (CommonTree)ast.getChild(1);
        assert ("columns".equalsIgnoreCase(columnsNode.getText()));
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i = 0; i < columnsNode.getChildCount(); ++i) {
            columnNames.add(columnsNode.getChild(i).getText());
        }
        this.columnNames = Collections.unmodifiableList(columnNames);
        ArrayList<ISqlJetForeignKeyAction> actions = new ArrayList<ISqlJetForeignKeyAction>();
        SqlJetForeignKeyDeferrable deferrable = null;
        for (int i = 2; i < ast.getChildCount(); ++i) {
            CommonTree child = (CommonTree)ast.getChild(i);
            if ("deferrable".equalsIgnoreCase(child.getText())) {
                assert (deferrable == null);
                deferrable = new SqlJetForeignKeyDeferrable(child);
                continue;
            }
            if ("on".equalsIgnoreCase(child.getText())) {
                actions.add(new SqlJetForeignKeyUpdateAction(child));
                continue;
            }
            if ("match".equalsIgnoreCase(child.getText())) {
                actions.add(new SqlJetForeignKeyMatchAction(child));
                continue;
            }
            assert (false);
        }
        this.actions = Collections.unmodifiableList(actions);
        this.deferrable = deferrable;
    }

    @Override
    public String getForeignTableName() {
        return this.foreignTableName;
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public List<ISqlJetForeignKeyAction> getActions() {
        return this.actions;
    }

    @Override
    public ISqlJetForeignKeyDeferrable getDeferrable() {
        return this.deferrable;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer("REFERENCES ");
        buffer.append(this.getForeignTableName());
        buffer.append(" (");
        for (i = 0; i < this.getColumnNames().size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getColumnNames().get(i));
        }
        buffer.append(")");
        for (i = 0; i < this.getActions().size(); ++i) {
            buffer.append(' ');
            buffer.append(this.getActions().get(i));
        }
        if (this.getDeferrable() != null) {
            buffer.append(' ');
            buffer.append(this.getDeferrable());
        }
        return buffer.toString();
    }
}

