/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.sqljet.core.table;

public class SqlJetScope {
    private SqlJetScopeBound myLeftBound;
    private SqlJetScopeBound myRightBound;

    public SqlJetScope(Object[] leftKey, Object[] rightKey) {
        this(new SqlJetScopeBound(leftKey), new SqlJetScopeBound(rightKey));
    }

    public SqlJetScope(Object[] leftKey, boolean isLeftKeyIncluded, Object[] rightKey, boolean isRightKeyIncluded) {
        this(new SqlJetScopeBound(leftKey, isLeftKeyIncluded), new SqlJetScopeBound(rightKey, isRightKeyIncluded));
    }

    public SqlJetScope(SqlJetScopeBound leftBound, SqlJetScopeBound rightBound) {
        this.myLeftBound = leftBound == null ? new SqlJetScopeBound(null, true) : leftBound;
        this.myRightBound = rightBound == null ? new SqlJetScopeBound(null, true) : rightBound;
    }

    public SqlJetScopeBound getLeftBound() {
        return this.myLeftBound;
    }

    public SqlJetScopeBound getRightBound() {
        return this.myRightBound;
    }

    public SqlJetScope reverse() {
        SqlJetScopeBound rightBound = this.getRightBound() != null ? new SqlJetScopeBound(this.getRightBound().getValue(), this.getRightBound().isInclusive()) : null;
        SqlJetScopeBound leftBound = this.getLeftBound() != null ? new SqlJetScopeBound(this.getLeftBound().getValue(), this.getLeftBound().isInclusive()) : null;
        return new SqlJetScope(rightBound, leftBound);
    }

    public String toString() {
        return this.getLeftBound() + ":" + this.getRightBound();
    }

    public static class SqlJetScopeBound {
        private Object[] myValue;
        private boolean myIsInclusive;

        public SqlJetScopeBound(Object[] value) {
            this(value, true);
        }

        public SqlJetScopeBound(Object[] value, boolean inclusive) {
            this.myValue = value;
            this.myIsInclusive = inclusive;
        }

        public Object[] getValue() {
            return this.myValue;
        }

        public boolean isInclusive() {
            return this.myIsInclusive;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.isInclusive() ? (char)'[' : '(');
            if (this.getValue() == null) {
                sb.append(this.getValue());
            } else if (this.getValue().length > 0) {
                sb.append(this.getValue()[0]);
                if (this.getValue().length > 1) {
                    sb.append(",...");
                }
            }
            sb.append(this.isInclusive() ? (char)']' : ')');
            return sb.toString();
        }
    }
}

