/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svn;

import afu.org.tmatesoft.svn.cli.svn.SVNCommand;
import afu.org.tmatesoft.svn.cli.svn.SVNOption;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPath;
import afu.org.tmatesoft.svn.core.wc.SVNWCClient;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SVNCleanupCommand
extends SVNCommand {
    public SVNCleanupCommand() {
        super("cleanup", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.DIFF3_CMD);
        return options;
    }

    @Override
    public void run() throws SVNException {
        List<String> targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        if (targets.isEmpty()) {
            targets.add("");
        }
        SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
        for (String targetName : targets) {
            SVNPath target = new SVNPath(targetName);
            if (!target.isFile()) continue;
            client.doCleanup(target.getFile());
        }
    }
}

