/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svn;

import afu.org.tmatesoft.svn.cli.svn.SVNCommand;
import afu.org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import afu.org.tmatesoft.svn.cli.svn.SVNOption;
import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import afu.org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPath;
import afu.org.tmatesoft.svn.core.wc.SVNRevision;
import afu.org.tmatesoft.svn.core.wc.SVNUpdateClient;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SVNExportCommand
extends SVNCommand {
    public SVNExportCommand() {
        super("export", null);
    }

    @Override
    protected Collection createSupportedOptions() {
        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.NATIVE_EOL);
        options.add(SVNOption.IGNORE_EXTERNALS);
        options.add(SVNOption.IGNORE_KEYWORDS);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNDepth depth;
        String to;
        List<String> targets = this.getSVNEnvironment().combineTargets(new ArrayList(), true);
        if (targets.isEmpty()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS), SVNLogType.CLIENT);
        }
        if (targets.size() > 2) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR), SVNLogType.CLIENT);
        }
        SVNPath from = new SVNPath(targets.get(0), true);
        SVNRevision pegRevision = from.getPegRevision();
        if (targets.size() == 1) {
            to = SVNPathUtil.tail(from.getTarget());
            if (from.isURL()) {
                to = SVNEncodingUtil.uriDecode(to);
            }
        } else {
            to = targets.get(1);
        }
        SVNUpdateClient client = this.getSVNEnvironment().getClientManager().getUpdateClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment(), false, true, false));
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        try {
            SVNPath dst = new SVNPath(to);
            String eol = this.getSVNEnvironment().getNativeEOL();
            SVNRevision revision = this.getSVNEnvironment().getStartRevision();
            client.setExportExpandsKeywords(!this.getSVNEnvironment().isIgnoreKeywords());
            if (from.isFile()) {
                client.doExport(from.getFile(), dst.getFile(), pegRevision, revision, eol, this.getSVNEnvironment().isForce(), depth);
            } else {
                client.doExport(from.getURL(), dst.getFile(), pegRevision, revision, eol, this.getSVNEnvironment().isForce(), depth);
            }
        }
        catch (SVNException e) {
            SVNErrorMessage err = e.getErrorMessage();
            if (err != null && err.getErrorCode() == SVNErrorCode.WC_OBSTRUCTED_UPDATE) {
                err = err.wrap("Destination directory exists; please remove the directory or use --force to overwrite");
            }
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
    }
}

