/*
 * Decompiled with CFR 0.152.
 */
package afu.org.tmatesoft.svn.cli.svn;

import afu.org.tmatesoft.svn.cli.svn.SVNCommand;
import afu.org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import afu.org.tmatesoft.svn.cli.svn.SVNOption;
import afu.org.tmatesoft.svn.core.SVNCommitInfo;
import afu.org.tmatesoft.svn.core.SVNDepth;
import afu.org.tmatesoft.svn.core.SVNErrorCode;
import afu.org.tmatesoft.svn.core.SVNErrorMessage;
import afu.org.tmatesoft.svn.core.SVNException;
import afu.org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import afu.org.tmatesoft.svn.core.internal.wc.SVNPath;
import afu.org.tmatesoft.svn.core.wc.SVNCommitClient;
import afu.org.tmatesoft.svn.util.SVNLogType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SVNImportCommand
extends SVNCommand {
    public SVNImportCommand() {
        super("import", null);
    }

    @Override
    public boolean isCommitter() {
        return true;
    }

    @Override
    protected Collection createSupportedOptions() {
        Collection<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.QUIET);
        options.add(SVNOption.NON_RECURSIVE);
        options.add(SVNOption.DEPTH);
        options.add(SVNOption.AUTOPROPS);
        options.add(SVNOption.FORCE);
        options.add(SVNOption.NO_AUTOPROPS);
        options = SVNOption.addLogMessageOptions(options);
        options.add(SVNOption.NO_IGNORE);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNDepth depth;
        List<String> targets = this.getSVNEnvironment().combineTargets(new ArrayList(), true);
        SVNPath url = null;
        SVNPath src = null;
        if (targets.isEmpty()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Repository URL required when importing"), SVNLogType.CLIENT);
        } else if (targets.size() > 2) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Too many arguments to import command"), SVNLogType.CLIENT);
        } else if (targets.size() == 1) {
            src = new SVNPath("");
            url = new SVNPath(targets.get(0));
        } else {
            src = new SVNPath(targets.get(0));
            url = new SVNPath(targets.get(1));
        }
        if (!url.isURL()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Invalid URL ''{0}''", (Object)url.getTarget()), SVNLogType.CLIENT);
        }
        SVNCommitClient client = this.getSVNEnvironment().getClientManager().getCommitClient();
        if (!this.getSVNEnvironment().isQuiet()) {
            client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
        }
        if ((depth = this.getSVNEnvironment().getDepth()) == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        client.setCommitHandler(this.getSVNEnvironment());
        SVNCommitInfo info = client.doImport(src.getFile(), url.getURL(), this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties(), !this.getSVNEnvironment().isNoIgnore(), this.getSVNEnvironment().isForce(), depth, !this.getSVNEnvironment().isNoAutoProps());
        if (!this.getSVNEnvironment().isQuiet()) {
            this.getSVNEnvironment().printCommitInfo(info);
        }
    }
}

